/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.security;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessManager {
    private final SessionDelegate delegate;
    private final PermissionProvider permissionProvider;

    public AccessManager(SessionDelegate delegate, PermissionProvider permissionProvider) {
        this.delegate = delegate;
        this.permissionProvider = permissionProvider;
    }

    public boolean hasPermissions(final @NotNull String oakPath, final @NotNull String actions) {
        return this.delegate.safePerform(new SessionOperation<Boolean>("hasPermissions"){

            @Override
            @NotNull
            public Boolean perform() {
                return AccessManager.this.permissionProvider.isGranted(oakPath, actions);
            }
        });
    }

    public boolean hasPermissions(final @NotNull Tree tree, final @Nullable PropertyState property, final long permissions) throws RepositoryException {
        return this.delegate.safePerform(new SessionOperation<Boolean>("hasPermissions"){

            @Override
            @NotNull
            public Boolean perform() {
                return AccessManager.this.permissionProvider.isGranted(tree, property, permissions);
            }
        });
    }

    public void checkPermissions(@NotNull String oakPath, @NotNull String actions) throws RepositoryException {
        if (!this.hasPermissions(oakPath, actions)) {
            throw new AccessDeniedException("Access denied.");
        }
    }

    public void checkPermissions(@NotNull Tree tree, @Nullable PropertyState property, long permissions) throws RepositoryException {
        if (!this.hasPermissions(tree, property, permissions)) {
            throw new AccessDeniedException("Access denied.");
        }
    }
}

