/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.observation.EventJournal;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import org.apache.jackrabbit.api.observation.JackrabbitEventFilter;
import org.apache.jackrabbit.api.observation.JackrabbitObservationManager;
import org.apache.jackrabbit.commons.iterator.EventListenerIteratorAdapter;
import org.apache.jackrabbit.commons.observation.ListenerTracker;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.observation.ChangeProcessor;
import org.apache.jackrabbit.oak.jcr.observation.OakEventFilterImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.plugins.observation.ExcludeExternal;
import org.apache.jackrabbit.oak.plugins.observation.filter.ChangeSetFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.ChangeSetFilterImpl;
import org.apache.jackrabbit.oak.plugins.observation.filter.FilterBuilder;
import org.apache.jackrabbit.oak.plugins.observation.filter.FilterProvider;
import org.apache.jackrabbit.oak.plugins.observation.filter.PermissionProviderFactory;
import org.apache.jackrabbit.oak.plugins.observation.filter.Selectors;
import org.apache.jackrabbit.oak.plugins.observation.filter.UniversalFilter;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.stats.StatisticManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ObservationManagerImpl
implements JackrabbitObservationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ObservationManagerImpl.class);
    private static final int STOP_TIME_OUT = 1000;
    public static final Marker OBSERVATION = MarkerFactory.getMarker((String)"observation");
    private static final Marker DEPRECATED = MarkerFactory.getMarker((String)"deprecated");
    private final Map<EventListener, ChangeProcessor> processors = new HashMap<EventListener, ChangeProcessor>();
    private final SessionDelegate sessionDelegate;
    private final ReadOnlyNodeTypeManager ntMgr;
    private final AuthorizationConfiguration authorizationConfig;
    private final NamePathMapper namePathMapper;
    private final Whiteboard whiteboard;
    private final StatisticManager statisticManager;
    private final int queueLength;
    private final CommitRateLimiter commitRateLimiter;
    private final PermissionProviderFactory permissionProviderFactory;
    private final BlobAccessProvider blobAccessProvider;

    public ObservationManagerImpl(SessionContext sessionContext, ReadOnlyNodeTypeManager nodeTypeManager, Whiteboard whiteboard, int queueLength, CommitRateLimiter commitRateLimiter) {
        this.sessionDelegate = sessionContext.getSessionDelegate();
        this.authorizationConfig = (AuthorizationConfiguration)sessionContext.getSecurityProvider().getConfiguration(AuthorizationConfiguration.class);
        this.ntMgr = nodeTypeManager;
        this.namePathMapper = sessionContext;
        this.whiteboard = whiteboard;
        this.statisticManager = sessionContext.getStatisticManager();
        this.queueLength = queueLength;
        this.commitRateLimiter = commitRateLimiter;
        this.blobAccessProvider = sessionContext.getBlobAccessProvider();
        this.permissionProviderFactory = new PermissionProviderFactory(){
            Set<Principal> principals;
            {
                this.principals = ObservationManagerImpl.this.sessionDelegate.getAuthInfo().getPrincipals();
            }

            @NotNull
            public PermissionProvider create(Root root) {
                return ObservationManagerImpl.this.authorizationConfig.getPermissionProvider(root, ObservationManagerImpl.this.sessionDelegate.getWorkspaceName(), this.principals);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<ChangeProcessor> toBeStopped;
        ObservationManagerImpl observationManagerImpl = this;
        synchronized (observationManagerImpl) {
            toBeStopped = new ArrayList<ChangeProcessor>(this.processors.values());
            this.processors.clear();
        }
        for (ChangeProcessor processor : toBeStopped) {
            ObservationManagerImpl.stop(processor);
        }
    }

    synchronized ChangeProcessor getChangeProcessor(EventListener listener) {
        return this.processors.get(listener);
    }

    private synchronized void addEventListener(EventListener listener, ListenerTracker tracker, FilterProvider filterProvider) {
        ChangeProcessor processor = this.processors.get(listener);
        if (processor == null) {
            LOG.debug(OBSERVATION, "Registering event listener {} with filter {}", (Object)listener, (Object)filterProvider);
            processor = new ChangeProcessor(this.sessionDelegate.getContentSession(), this.namePathMapper, tracker, filterProvider, this.statisticManager, this.queueLength, this.commitRateLimiter, this.blobAccessProvider);
            this.processors.put(listener, processor);
            processor.start(this.whiteboard);
        } else {
            LOG.debug(OBSERVATION, "Changing event listener {} to filter {}", (Object)listener, (Object)filterProvider);
            processor.setFilterProvider(filterProvider);
        }
    }

    public void addEventListener(EventListener listener, FilterProvider filterProvider) {
        WarningListenerTracker tracker = new WarningListenerTracker(true, listener, 0, null, true, null, null, false);
        this.addEventListener(listener, tracker, filterProvider);
    }

    public void addEventListener(EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeName, boolean noLocal) throws RepositoryException {
        JackrabbitEventFilter filter = new JackrabbitEventFilter();
        filter.setEventTypes(eventTypes);
        if (absPath != null) {
            filter.setAbsPath(absPath);
        }
        filter.setIsDeep(isDeep);
        if (uuids != null) {
            filter.setIdentifiers(uuids);
        }
        if (nodeTypeName != null) {
            filter.setNodeTypes(nodeTypeName);
        }
        filter.setNoLocal(noLocal);
        filter.setNoExternal(listener instanceof ExcludeExternal);
        this.addEventListener(listener, filter);
    }

    public void addEventListener(EventListener listener, JackrabbitEventFilter filter) throws RepositoryException {
        String[] includeGlobPaths;
        OakEventFilterImpl oakEventFilter = null;
        if (filter instanceof OakEventFilterImpl) {
            oakEventFilter = (OakEventFilterImpl)filter;
        }
        int eventTypes = filter.getEventTypes();
        boolean isDeep = filter.getIsDeep();
        String[] uuids = filter.getIdentifiers();
        String[] nodeTypeName = filter.getNodeTypes();
        boolean noLocal = filter.getNoLocal();
        boolean noExternal = filter.getNoExternal() || listener instanceof ExcludeExternal;
        boolean noInternal = filter.getNoInternal();
        Set<String> includePaths = ObservationManagerImpl.getOakPaths(this.namePathMapper, filter.getAdditionalPaths(), "include");
        String absPath = filter.getAbsPath();
        if (absPath != null) {
            includePaths.add(this.namePathMapper.getOakPath(absPath));
        }
        Set<String> excludedPaths = ObservationManagerImpl.getOakPaths(this.namePathMapper, filter.getExcludedPaths(), "exclude");
        PathUtils.unifyInExcludes(includePaths, excludedPaths);
        if (oakEventFilter != null && (includeGlobPaths = oakEventFilter.getIncludeGlobPaths()) != null) {
            includePaths.addAll(Arrays.asList(includeGlobPaths));
        }
        if (includePaths.isEmpty()) {
            LOG.warn("The passed filter excludes all events. No event listener registered");
            return;
        }
        FilterBuilder filterBuilder = new FilterBuilder();
        String depthPattern = isDeep ? "*/**" : "*";
        ArrayList<FilterBuilder.Condition> includeConditions = new ArrayList<FilterBuilder.Condition>();
        filterBuilder.addPathsForMBean(includePaths);
        for (String path : includePaths) {
            String deepenedPath = path.endsWith("*") ? path : (path.contains("*") ? PathUtils.concat((String)path, (String)"*") : PathUtils.concat((String)path, (String)depthPattern));
            includeConditions.add(filterBuilder.path(deepenedPath));
            if (oakEventFilter != null && oakEventFilter.getIncludeAncestorsRemove()) continue;
            filterBuilder.addSubTree(this.pathWithoutGlob(path));
        }
        List<FilterBuilder.Condition> excludeConditions = ObservationManagerImpl.createExclusions(filterBuilder, excludedPaths);
        String[] validatedNodeTypeNames = this.validateNodeTypeNames(nodeTypeName);
        UniversalFilter.Selector nodeTypeSelector = Selectors.PARENT;
        boolean deleteSubtree = true;
        if (oakEventFilter != null) {
            FilterBuilder.Condition additionalIncludes = oakEventFilter.getAdditionalIncludeConditions(includePaths);
            if (additionalIncludes != null) {
                includeConditions.add(additionalIncludes);
            }
            filterBuilder.aggregator(oakEventFilter.getAggregator());
            if (oakEventFilter.getApplyNodeTypeOnSelf()) {
                nodeTypeSelector = Selectors.THIS;
            }
            if (oakEventFilter.getIncludeSubtreeOnRemove()) {
                deleteSubtree = false;
            }
        }
        if (deleteSubtree) {
            excludeConditions.add(filterBuilder.deleteSubtree());
        }
        FilterBuilder.Condition condition = filterBuilder.all(new FilterBuilder.Condition[]{filterBuilder.all(excludeConditions), filterBuilder.any(includeConditions), filterBuilder.moveSubtree(), filterBuilder.eventType(eventTypes), filterBuilder.uuid(Selectors.PARENT, uuids), filterBuilder.nodeType(nodeTypeSelector, validatedNodeTypeNames), filterBuilder.accessControl(this.permissionProviderFactory)});
        if (oakEventFilter != null) {
            condition = oakEventFilter.wrapMainCondition(condition, filterBuilder, this.permissionProviderFactory);
        }
        filterBuilder.includeSessionLocal(!noLocal).includeClusterExternal(!noExternal).includeClusterLocal(!noInternal).condition(condition);
        WarningListenerTracker tracker = new WarningListenerTracker(!noExternal, listener, eventTypes, absPath, isDeep, uuids, nodeTypeName, noLocal);
        Set<String> additionalIncludePaths = null;
        if (oakEventFilter != null) {
            additionalIncludePaths = oakEventFilter.calcPrefilterIncludePaths(includePaths);
        }
        HashSet<String> explodedNodeTypes = null;
        if (validatedNodeTypeNames != null) {
            explodedNodeTypes = new HashSet<String>();
            for (String nt : validatedNodeTypeNames) {
                this.explodeSubtypes(nt, explodedNodeTypes);
            }
        }
        filterBuilder.setChangeSetFilter((ChangeSetFilter)new ChangeSetFilterImpl(includePaths, isDeep, additionalIncludePaths, excludedPaths, null, explodedNodeTypes, null));
        this.addEventListener(listener, tracker, filterBuilder.build());
    }

    private void explodeSubtypes(String nodeType, Set<String> set) throws RepositoryException {
        set.add(nodeType);
        NodeTypeIterator it = this.ntMgr.getNodeType(nodeType).getSubtypes();
        while (it.hasNext()) {
            String subnt = String.valueOf(it.next());
            if (set.contains(subnt)) continue;
            set.add(subnt);
            this.explodeSubtypes(subnt, set);
        }
    }

    private String pathWithoutGlob(String path) {
        String next;
        if (!path.contains("*")) {
            return path;
        }
        Iterator it = PathUtils.elements((String)path).iterator();
        String result = "/";
        while (it.hasNext() && !(next = (String)it.next()).contains("*")) {
            result = PathUtils.concat((String)result, (String)next);
        }
        return result;
    }

    private static List<FilterBuilder.Condition> createExclusions(FilterBuilder filterBuilder, Iterable<String> excludedPaths) {
        ArrayList<FilterBuilder.Condition> conditions = new ArrayList<FilterBuilder.Condition>();
        for (String path : excludedPaths) {
            conditions.add(filterBuilder.not(filterBuilder.path(path + "/**")));
        }
        return conditions;
    }

    private static Set<String> getOakPaths(NamePathMapper mapper, String[] paths, String type) throws RepositoryException {
        HashSet<String> oakPaths = new HashSet<String>();
        for (String path : paths) {
            String oakPath = mapper.getOakPath(path);
            if (oakPath == null) {
                throw new RepositoryException("Invalid " + type + " path: " + path);
            }
            oakPaths.add(oakPath);
        }
        return oakPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener listener) {
        ChangeProcessor processor;
        ObservationManagerImpl observationManagerImpl = this;
        synchronized (observationManagerImpl) {
            processor = this.processors.remove(listener);
        }
        if (processor != null) {
            ObservationManagerImpl.stop(processor);
        }
    }

    public EventListenerIterator getRegisteredEventListeners() {
        return new EventListenerIteratorAdapter(this.processors.keySet());
    }

    public void setUserData(@Nullable String userData) {
        this.sessionDelegate.setUserData(userData);
    }

    public EventJournal getEventJournal() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public EventJournal getEventJournal(int eventTypes, String absPath, boolean isDeep, String[] uuid, String[] nodeTypeName) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    @Nullable
    private String[] validateNodeTypeNames(@Nullable String[] nodeTypeNames) throws NoSuchNodeTypeException, RepositoryException {
        if (nodeTypeNames == null) {
            return null;
        }
        String[] oakNames = new String[nodeTypeNames.length];
        for (int i = 0; i < nodeTypeNames.length; ++i) {
            this.ntMgr.getNodeType(nodeTypeNames[i]);
            oakNames[i] = this.namePathMapper.getOakName(nodeTypeNames[i]);
        }
        return oakNames;
    }

    private static void stop(ChangeProcessor processor) {
        if (!processor.stopAndWait(1000, TimeUnit.MILLISECONDS)) {
            LOG.warn(OBSERVATION, "Timed out waiting for change processor to stop after 1000 milliseconds. Falling back to asynchronous stop on " + String.valueOf(processor) + " (listener details: '" + processor.getListenerToString() + "')");
            processor.stop();
        }
    }

    private class WarningListenerTracker
    extends ListenerTracker {
        private final boolean enableWarning;

        public WarningListenerTracker(boolean enableWarning, EventListener listener, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeName, boolean noLocal) {
            super(listener, eventTypes, absPath, isDeep, uuids, nodeTypeName, noLocal);
            this.enableWarning = enableWarning;
        }

        protected void warn(String message) {
            if (this.enableWarning) {
                LOG.warn(DEPRECATED, message, (Throwable)this.initStackTrace);
            }
        }

        protected void beforeEventDelivery() {
            ObservationManagerImpl.this.sessionDelegate.refreshAtNextAccess();
        }
    }
}

