/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.index.IndexingContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.AsyncIndexesSizeStatsUpdate;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyUpdateCallback;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexStatsUpdateCallback
implements PropertyUpdateCallback {
    private static final String NO_DOCS = "_NO_DOCS";
    private static final String INDEX_SIZE = "_INDEX_SIZE";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String indexPath;
    private final LuceneIndexMBean luceneIndexMBean;
    private final StatisticsProvider statisticsProvider;
    private final AsyncIndexesSizeStatsUpdate asyncIndexesSizeStatsUpdate;
    private final IndexingContext indexingContext;

    LuceneIndexStatsUpdateCallback(String indexPath, @NotNull LuceneIndexMBean luceneIndexMBean, @NotNull StatisticsProvider statisticsProvider, AsyncIndexesSizeStatsUpdate asyncIndexesSizeStatsUpdate, IndexingContext indexingContext) {
        this.indexPath = indexPath;
        this.luceneIndexMBean = luceneIndexMBean;
        this.statisticsProvider = statisticsProvider;
        this.asyncIndexesSizeStatsUpdate = asyncIndexesSizeStatsUpdate;
        this.indexingContext = indexingContext;
    }

    @Override
    public void propertyUpdated(String nodePath, String propertyRelativePath, PropertyDefinition pd, @Nullable PropertyState before, @Nullable PropertyState after) {
    }

    @Override
    public void done() {
        if (this.shouldUpdateStats()) {
            try {
                long startTime = System.currentTimeMillis();
                int docCount = Integer.parseInt(this.luceneIndexMBean.getDocCount(this.indexPath));
                HistogramStats docCountHistogram = this.statisticsProvider.getHistogram(this.indexPath + NO_DOCS, StatsOptions.METRICS_ONLY);
                docCountHistogram.update((long)docCount);
                this.log.trace("{} stats updated, docCount {}, timeToUpdate {}", new Object[]{this.indexPath, docCount, System.currentTimeMillis() - startTime});
                long indexSize = Long.parseLong(this.luceneIndexMBean.getSize(this.indexPath));
                HistogramStats indexSizeHistogram = this.statisticsProvider.getHistogram(this.indexPath + INDEX_SIZE, StatsOptions.METRICS_ONLY);
                indexSizeHistogram.update(indexSize);
                long endTime = System.currentTimeMillis();
                this.asyncIndexesSizeStatsUpdate.setLastStatsUpdateTime(this.indexPath, endTime);
                this.log.debug("{} stats updated; docCount {}, size {}, timeToUpdate {}", new Object[]{this.indexPath, docCount, indexSize, endTime - startTime});
            }
            catch (IOException e) {
                this.log.warn("could not update no_docs/index_size stats for index at {}", (Object)this.indexPath, (Object)e);
            }
        }
    }

    private boolean shouldUpdateStats() {
        boolean timeToUpdate = false;
        if (this.indexingContext.isAsync() && this.asyncIndexesSizeStatsUpdate != null && this.asyncIndexesSizeStatsUpdate.getScheduleTimeInMillis() >= 0L && this.isScheduled()) {
            timeToUpdate = true;
        }
        return timeToUpdate;
    }

    private boolean isScheduled() {
        long lastStatsUpdateTime = this.asyncIndexesSizeStatsUpdate.getLastStatsUpdateTime(this.indexPath);
        long defaultStatsUpdateTime = this.asyncIndexesSizeStatsUpdate.getScheduleTimeInMillis();
        return System.currentTimeMillis() > lastStatsUpdateTime + defaultStatsUpdateTime;
    }
}

