/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.ActiveDeletedBlobCollectorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.BlobFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakDirectory;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedOakDirectory
extends Directory {
    public static final String ENABLE_WRITING_SINGLE_BLOB_INDEX_FILE_PARAM = "oak.lucene.enableSingleBlobIndexFiles";
    private static boolean enableWritingSingleBlobIndexFile = Boolean.parseBoolean(System.getProperty("oak.lucene.enableSingleBlobIndexFiles", "true"));
    static final int DELETE_THRESHOLD_UNTIL_REOPEN = 100;
    private static final Logger LOG = LoggerFactory.getLogger(BufferedOakDirectory.class);
    private final BlobFactory blobFactory;
    private final ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback;
    private final String dataNodeName;
    private final LuceneIndexDefinition definition;
    private final OakDirectory base;
    private final Set<String> bufferedForDelete = Sets.newConcurrentHashSet();
    private NodeBuilder bufferedBuilder = EmptyNodeState.EMPTY_NODE.builder();
    private OakDirectory buffered;
    private int deleteCount;

    public static void setEnableWritingSingleBlobIndexFile(boolean val) {
        boolean cliVal;
        String cliValStr = System.getProperty(ENABLE_WRITING_SINGLE_BLOB_INDEX_FILE_PARAM);
        if (cliValStr != null && (cliVal = Boolean.parseBoolean(cliValStr)) != val) {
            LOG.warn("Ignoring configuration {} as CLI param overrides with a different value", (Object)val);
            if (cliVal != enableWritingSingleBlobIndexFile) {
                enableWritingSingleBlobIndexFile = cliVal;
            }
            return;
        }
        enableWritingSingleBlobIndexFile = val;
    }

    public static boolean isEnableWritingSingleBlobIndexFile() {
        return enableWritingSingleBlobIndexFile;
    }

    static void reReadCommandLineParam() {
        String val = System.getProperty(ENABLE_WRITING_SINGLE_BLOB_INDEX_FILE_PARAM);
        if (val != null) {
            enableWritingSingleBlobIndexFile = Boolean.parseBoolean(val);
        }
    }

    public BufferedOakDirectory(@NotNull NodeBuilder builder, @NotNull String dataNodeName, @NotNull LuceneIndexDefinition definition, @Nullable BlobStore blobStore) {
        this(builder, dataNodeName, definition, blobStore, ActiveDeletedBlobCollectorFactory.BlobDeletionCallback.NOOP);
    }

    public BufferedOakDirectory(@NotNull NodeBuilder builder, @NotNull String dataNodeName, @NotNull LuceneIndexDefinition definition, @Nullable BlobStore blobStore, @NotNull ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback) {
        this.blobFactory = blobStore != null ? BlobFactory.getBlobStoreBlobFactory(blobStore) : BlobFactory.getNodeBuilderBlobFactory(builder);
        this.blobDeletionCallback = blobDeletionCallback;
        this.dataNodeName = (String)Preconditions.checkNotNull((Object)dataNodeName);
        this.definition = (LuceneIndexDefinition)Preconditions.checkNotNull((Object)definition);
        this.base = new OakDirectory((NodeBuilder)Preconditions.checkNotNull((Object)builder), dataNodeName, definition, false, this.blobFactory, blobDeletionCallback, BufferedOakDirectory.isEnableWritingSingleBlobIndexFile());
        this.reopenBuffered();
    }

    @Override
    public String[] listAll() throws IOException {
        LOG.debug("[{}]listAll()", (Object)this.definition.getIndexPath());
        TreeSet all = Sets.newTreeSet();
        all.addAll(Arrays.asList(this.base.listAll()));
        all.addAll(Arrays.asList(this.buffered.listAll()));
        all.removeAll(this.bufferedForDelete);
        return all.toArray(new String[all.size()]);
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        LOG.debug("[{}]fileExists({})", (Object)this.definition.getIndexPath(), (Object)name);
        if (this.bufferedForDelete.contains(name)) {
            return false;
        }
        return this.buffered.fileExists(name) || this.base.fileExists(name);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        LOG.debug("[{}]deleteFile({})", (Object)this.definition.getIndexPath(), (Object)name);
        if (this.base.fileExists(name)) {
            this.bufferedForDelete.add(name);
        }
        if (this.buffered.fileExists(name)) {
            this.buffered.deleteFile(name);
            this.fileDeleted();
        }
    }

    @Override
    public long fileLength(String name) throws IOException {
        LOG.debug("[{}]fileLength({})", (Object)this.definition.getIndexPath(), (Object)name);
        if (this.bufferedForDelete.contains(name)) {
            String msg = String.format("already deleted: [%s] %s", this.definition.getIndexPath(), name);
            throw new FileNotFoundException(msg);
        }
        OakDirectory dir = this.base;
        if (this.buffered.fileExists(name)) {
            dir = this.buffered;
        }
        return ((Directory)dir).fileLength(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        LOG.debug("[{}]createOutput({})", (Object)this.definition.getIndexPath(), (Object)name);
        this.bufferedForDelete.remove(name);
        return this.buffered.createOutput(name, context);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        LOG.debug("[{}]sync({})", (Object)this.definition.getIndexPath(), names);
        this.buffered.sync(names);
        this.base.sync(names);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        LOG.debug("[{}]openInput({})", (Object)this.definition.getIndexPath(), (Object)name);
        if (this.bufferedForDelete.contains(name)) {
            String msg = String.format("already deleted: [%s] %s", this.definition.getIndexPath(), name);
            throw new FileNotFoundException(msg);
        }
        OakDirectory dir = this.base;
        if (this.buffered.fileExists(name)) {
            dir = this.buffered;
        }
        return ((Directory)dir).openInput(name, context);
    }

    @Override
    public Lock makeLock(String name) {
        return this.base.makeLock(name);
    }

    @Override
    public void clearLock(String name) throws IOException {
        this.base.clearLock(name);
    }

    @Override
    public void close() throws IOException {
        LOG.debug("[{}]close()", (Object)this.definition.getIndexPath());
        this.buffered.close();
        for (String name : this.buffered.listAll()) {
            this.buffered.copy(this.base, name);
        }
        for (String name : this.bufferedForDelete) {
            this.base.deleteFile(name);
        }
        this.base.close();
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.base.setLockFactory(lockFactory);
    }

    @Override
    public LockFactory getLockFactory() {
        return this.base.getLockFactory();
    }

    private void fileDeleted() throws IOException {
        if (++this.deleteCount >= 100) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reopen buffered OakDirectory. Current list of files: {}", Arrays.asList(this.buffered.listAll()));
            }
            this.buffered.close();
            this.reopenBuffered();
        }
    }

    private void reopenBuffered() {
        this.bufferedBuilder = ModifiedNodeState.squeeze((NodeState)this.bufferedBuilder.getNodeState()).builder();
        this.buffered = new OakDirectory(this.bufferedBuilder, this.dataNodeName, this.definition, false, this.blobFactory, this.blobDeletionCallback, BufferedOakDirectory.isEnableWritingSingleBlobIndexFile());
    }
}

