/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.blob.datastore.InMemoryDataRecord;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.ActiveDeletedBlobCollectorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.BlobFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakIndexInput;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakIndexOutput;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OakDirectory
extends Directory {
    static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(OakDirectory.class.getName() + ".perf")));
    static final Logger LOG = LoggerFactory.getLogger((String)OakDirectory.class.getName());
    public static final String PROP_DIR_LISTING = "dirListing";
    static final String PROP_BLOB_SIZE = "blobSize";
    static final String PROP_UNIQUE_KEY = "uniqueKey";
    public static final String PROP_UNSAFE_FOR_ACTIVE_DELETION = "unsafeForActiveDeletion";
    static final int UNIQUE_KEY_SIZE = 16;
    private static final SecureRandom secureRandom = new SecureRandom();
    protected final NodeBuilder builder;
    protected final String dataNodeName;
    protected final NodeBuilder directoryBuilder;
    private final LuceneIndexDefinition definition;
    private LockFactory lockFactory;
    private final boolean readOnly;
    private final boolean streamingWriteEnabled;
    private final Set<String> fileNames = Sets.newConcurrentHashSet();
    private final Set<String> fileNamesAtStart;
    private final String indexName;
    private final BlobFactory blobFactory;
    private final ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback;
    private volatile boolean dirty;

    public OakDirectory(NodeBuilder builder, LuceneIndexDefinition definition, boolean readOnly) {
        this(builder, ":data", definition, readOnly);
    }

    public OakDirectory(NodeBuilder builder, String dataNodeName, LuceneIndexDefinition definition, boolean readOnly) {
        this(builder, dataNodeName, definition, readOnly, BlobFactory.getNodeBuilderBlobFactory(builder));
    }

    public OakDirectory(NodeBuilder builder, String dataNodeName, LuceneIndexDefinition definition, boolean readOnly, @Nullable GarbageCollectableBlobStore blobStore) {
        this(builder, dataNodeName, definition, readOnly, blobStore, ActiveDeletedBlobCollectorFactory.BlobDeletionCallback.NOOP);
    }

    public OakDirectory(NodeBuilder builder, String dataNodeName, LuceneIndexDefinition definition, boolean readOnly, @Nullable GarbageCollectableBlobStore blobStore, @NotNull ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback) {
        this(builder, dataNodeName, definition, readOnly, blobStore != null ? BlobFactory.getBlobStoreBlobFactory((BlobStore)blobStore) : BlobFactory.getNodeBuilderBlobFactory(builder), blobDeletionCallback);
    }

    public OakDirectory(NodeBuilder builder, String dataNodeName, LuceneIndexDefinition definition, boolean readOnly, BlobFactory blobFactory) {
        this(builder, dataNodeName, definition, readOnly, blobFactory, ActiveDeletedBlobCollectorFactory.BlobDeletionCallback.NOOP);
    }

    public OakDirectory(NodeBuilder builder, String dataNodeName, LuceneIndexDefinition definition, boolean readOnly, BlobFactory blobFactory, @NotNull ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback) {
        this(builder, dataNodeName, definition, readOnly, blobFactory, blobDeletionCallback, false);
    }

    public OakDirectory(NodeBuilder builder, String dataNodeName, LuceneIndexDefinition definition, boolean readOnly, BlobFactory blobFactory, @NotNull ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback, boolean streamingWriteEnabled) {
        this.lockFactory = NoLockFactory.getNoLockFactory();
        this.builder = builder;
        this.dataNodeName = dataNodeName;
        this.directoryBuilder = readOnly ? builder.getChildNode(dataNodeName) : builder.child(dataNodeName);
        this.definition = definition;
        this.readOnly = readOnly;
        this.fileNames.addAll(this.getListing());
        this.fileNamesAtStart = ImmutableSet.copyOf(this.fileNames);
        this.indexName = definition.getIndexName();
        this.blobFactory = blobFactory;
        this.blobDeletionCallback = blobDeletionCallback;
        this.streamingWriteEnabled = streamingWriteEnabled;
    }

    @Override
    public String[] listAll() throws IOException {
        return this.fileNames.toArray(new String[this.fileNames.size()]);
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        return this.fileNames.contains(name);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        Preconditions.checkArgument((!this.readOnly ? 1 : 0) != 0, (Object)"Read only directory");
        this.fileNames.remove(name);
        NodeBuilder f = this.directoryBuilder.getChildNode(name);
        if (!f.hasProperty(PROP_UNSAFE_FOR_ACTIVE_DELETION) || !((Boolean)f.getProperty(PROP_UNSAFE_FOR_ACTIVE_DELETION).getValue(Type.BOOLEAN)).booleanValue()) {
            PropertyState property = f.getProperty("jcr:data");
            if (property != null && (property.getType() == Type.BINARIES || property.getType() == Type.BINARY)) {
                for (Blob b : (Iterable)property.getValue(Type.BINARIES)) {
                    String blobId = b.getContentIdentity();
                    if (blobId == null || InMemoryDataRecord.isInstance((String)blobId)) continue;
                    this.blobDeletionCallback.deleted(blobId, Lists.newArrayList((Object[])new String[]{this.definition.getIndexPath(), this.dataNodeName, name}));
                }
            }
        } else {
            LOG.debug("Not marking {} under {} for active deletion", (Object)name, (Object)this.indexName);
        }
        if (f instanceof ReadOnlyBuilder) {
            LOG.debug("Preserve read-only node: " + name);
        } else {
            f.remove();
        }
        this.markDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long fileLength(String name) throws IOException {
        NodeBuilder file = this.directoryBuilder.getChildNode(name);
        if (!file.exists()) {
            String msg = String.format("[%s] %s", this.indexName, name);
            throw new FileNotFoundException(msg);
        }
        try (OakIndexInput input = new OakIndexInput(name, file, this.indexName, this.blobFactory);){
            long l = input.length();
            return l;
        }
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        Preconditions.checkArgument((!this.readOnly ? 1 : 0) != 0, (Object)"Read only directory");
        if (this.directoryBuilder.hasChildNode(name)) {
            this.directoryBuilder.getChildNode(name).remove();
        }
        NodeBuilder file = this.directoryBuilder.child(name);
        byte[] uniqueKey = new byte[16];
        secureRandom.nextBytes(uniqueKey);
        String key = StringUtils.convertBytesToHex((byte[])uniqueKey);
        file.setProperty(PROP_UNIQUE_KEY, (Object)key);
        file.setProperty(PROP_BLOB_SIZE, (Object)this.definition.getBlobSize());
        if (this.blobDeletionCallback.isMarkingForActiveDeletionUnsafe()) {
            file.setProperty(PROP_UNSAFE_FOR_ACTIVE_DELETION, (Object)true);
            LOG.debug("Setting {} under {} as unsafe for active deletion", (Object)name, (Object)this.indexName);
        }
        this.fileNames.add(name);
        this.markDirty();
        return new OakIndexOutput(name, file, this.indexName, this.blobFactory, this.streamingWriteEnabled);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        NodeBuilder file = this.directoryBuilder.getChildNode(name);
        if (file.exists()) {
            return new OakIndexInput(name, file, this.indexName, this.blobFactory);
        }
        String msg = String.format("[%s] %s", this.indexName, name);
        throw new FileNotFoundException(msg);
    }

    @Override
    public Lock makeLock(String name) {
        return this.lockFactory.makeLock(name);
    }

    @Override
    public void clearLock(String name) throws IOException {
        this.lockFactory.clearLock(name);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (!this.readOnly && this.definition.saveDirListing() && !this.fileNamesAtStart.equals(this.fileNames)) {
            if (this.directoryBuilder instanceof ReadOnlyBuilder) {
                LOG.debug("Preserve files of read-only directory: " + this.fileNames);
            } else {
                this.directoryBuilder.setProperty(PropertyStates.createProperty((String)PROP_DIR_LISTING, this.fileNames, (Type)Type.STRINGS));
            }
        }
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.lockFactory = lockFactory;
    }

    @Override
    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    @Override
    public String toString() {
        return "Directory for " + this.definition.getIndexName();
    }

    public void copy(OakDirectory dest, String name) throws IOException {
        if (this.blobFactory != dest.blobFactory) {
            throw new IllegalArgumentException("Source and destination directory must reference the same BlobFactory");
        }
        NodeBuilder file = this.directoryBuilder.getChildNode(name);
        if (file.exists()) {
            if (dest.directoryBuilder instanceof ReadOnlyBuilder) {
                LOG.debug("Preserve read-only child: " + name);
            } else {
                NodeBuilder destFile = dest.directoryBuilder.setChildNode(name, EmptyNodeState.EMPTY_NODE);
                for (PropertyState p : file.getProperties()) {
                    destFile.setProperty(p);
                }
                dest.fileNames.add(name);
                dest.markDirty();
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void markDirty() {
        this.dirty = true;
    }

    private Set<String> getListing() {
        PropertyState listing;
        long start = PERF_LOGGER.start();
        Iterable fileNames = null;
        if (this.definition.saveDirListing() && (listing = this.directoryBuilder.getProperty(PROP_DIR_LISTING)) != null) {
            fileNames = (Iterable)listing.getValue(Type.STRINGS);
        }
        if (fileNames == null) {
            fileNames = this.directoryBuilder.getChildNodeNames();
        }
        ImmutableSet result = ImmutableSet.copyOf(fileNames);
        PERF_LOGGER.end(start, 100L, "Directory listing performed. Total {} files", (Object)result.size());
        return result;
    }
}

