/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.commit.AnnotatingConflictHandler;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.BucketSwitcher;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.HybridPropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.RecursiveDelete;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.UniqueIndexCleaner;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.ResetCommitAttributeHook;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIndexCleaner
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStore nodeStore;
    private final IndexPathService indexPathService;
    private final AsyncIndexInfoService asyncIndexInfoService;
    private UniqueIndexCleaner uniqueIndexCleaner = new UniqueIndexCleaner(TimeUnit.HOURS, 1L);
    private Map<String, Long> lastAsyncInfo = Collections.emptyMap();
    private final TimerStats cleanupTime;
    private final MeterStats noopMeter;
    private boolean recursiveDelete;

    public PropertyIndexCleaner(NodeStore nodeStore, IndexPathService indexPathService, AsyncIndexInfoService asyncIndexInfoService, StatisticsProvider statsProvider) {
        this.nodeStore = (NodeStore)Preconditions.checkNotNull((Object)nodeStore);
        this.indexPathService = (IndexPathService)Preconditions.checkNotNull((Object)indexPathService);
        this.asyncIndexInfoService = (AsyncIndexInfoService)Preconditions.checkNotNull((Object)asyncIndexInfoService);
        this.cleanupTime = statsProvider.getTimer("HYBRID_PROPERTY_CLEANER", StatsOptions.METRICS_ONLY);
        this.noopMeter = statsProvider.getMeter("HYBRID_PROPERTY_NOOP", StatsOptions.METRICS_ONLY);
    }

    @Override
    public void run() {
        try {
            this.performCleanup(false);
        }
        catch (Exception e) {
            this.log.warn("Cleanup run failed with error", (Throwable)e);
        }
    }

    public int performCleanup(String paths, int batchSize, int sleepPerBatch, int maxRemoveCount) throws CommitFailedException {
        String[] list = paths.split(",");
        int numOfNodesDeleted = 0;
        for (String s : list) {
            this.log.info("Cleanup of {}", (Object)s);
            if (!NodeStateUtils.isHidden((String)PathUtils.getName((String)s))) {
                this.log.warn("Not a hidden node: {}", (Object)s);
                continue;
            }
            RecursiveDelete rd = new RecursiveDelete(this.nodeStore, (CommitHook)this.createCommitHook(), PropertyIndexCleaner::createCommitInfo);
            rd.setBatchSize(batchSize);
            rd.setSleepPerBatch(sleepPerBatch);
            rd.setMaxRemoveCount(maxRemoveCount);
            rd.run(Collections.singletonList(s));
            numOfNodesDeleted += rd.getNumRemoved();
        }
        return numOfNodesDeleted;
    }

    public CleanupStats performCleanup(boolean forceCleanup) throws CommitFailedException {
        CleanupStats stats = new CleanupStats();
        Stopwatch w = Stopwatch.createStarted();
        Map asyncInfo = this.asyncIndexInfoService.getIndexedUptoPerLane();
        if (this.lastAsyncInfo.equals(asyncInfo) && !forceCleanup) {
            this.log.debug("No change found in async state from last run {}. Skipping the run", (Object)asyncInfo);
            this.noopMeter.mark();
            return stats;
        }
        stats.cleanupPerformed = true;
        List<String> syncIndexes = this.getSyncIndexPaths();
        IndexInfo indexInfo = this.switchBucketsAndCollectIndexData(syncIndexes, asyncInfo, stats);
        this.purgeOldBuckets(indexInfo.oldBucketPaths, stats);
        this.purgeOldUniqueIndexEntries(indexInfo.uniqueIndexPaths, stats);
        this.lastAsyncInfo = asyncInfo;
        if (w.elapsed(TimeUnit.MINUTES) > 5L) {
            this.log.info("Property index cleanup done in {}. {}", (Object)w, (Object)stats);
        } else {
            this.log.debug("Property index cleanup done in {}. {}", (Object)w, (Object)stats);
        }
        this.cleanupTime.update(w.elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        return stats;
    }

    public void setCreatedTimeThreshold(TimeUnit unit, long time) {
        this.uniqueIndexCleaner = new UniqueIndexCleaner(unit, time);
    }

    public boolean isRecursiveDelete() {
        return this.recursiveDelete;
    }

    public void setRecursiveDelete(boolean recursiveDelete) {
        this.recursiveDelete = recursiveDelete;
    }

    List<String> getSyncIndexPaths() {
        ArrayList<String> indexPaths = new ArrayList<String>();
        NodeState root = this.nodeStore.getRoot();
        for (String indexPath : this.indexPathService.getIndexPaths()) {
            NodeState idx = NodeStateUtils.getNode((NodeState)root, (String)indexPath);
            if (!"lucene".equals(idx.getString("type")) || !idx.hasChildNode(":property-index")) continue;
            indexPaths.add(indexPath);
        }
        return indexPaths;
    }

    private IndexInfo switchBucketsAndCollectIndexData(List<String> indexPaths, Map<String, Long> asyncInfo, CleanupStats stats) throws CommitFailedException {
        IndexInfo indexInfo = new IndexInfo();
        NodeState root = this.nodeStore.getRoot();
        NodeBuilder builder = root.builder();
        boolean modified = false;
        for (String indexPath : indexPaths) {
            NodeState idx = NodeStateUtils.getNode((NodeState)root, (String)indexPath);
            NodeBuilder idxb = PropertyIndexCleaner.child(builder, indexPath);
            String laneName = IndexUtils.getAsyncLaneName((NodeState)idx, (String)indexPath);
            Long lastIndexedTo = asyncInfo.get(laneName);
            if (lastIndexedTo == null) {
                this.log.warn("Not able to determine async index info for lane {}. Known lanes {}", (Object)laneName, asyncInfo.keySet());
                continue;
            }
            NodeState propertyIndexNode = idx.getChildNode(":property-index");
            NodeBuilder propIndexNodeBuilder = idxb.getChildNode(":property-index");
            for (ChildNodeEntry cne : propertyIndexNode.getChildNodeEntries()) {
                NodeState propIdxState = cne.getNodeState();
                String propName = cne.getName();
                if (HybridPropertyIndexUtil.simplePropertyIndex(propIdxState)) {
                    NodeBuilder propIdx = propIndexNodeBuilder.getChildNode(propName);
                    BucketSwitcher bs = new BucketSwitcher(propIdx);
                    modified |= bs.switchBucket(lastIndexedTo);
                    for (String bucketName : bs.getOldBuckets()) {
                        String bucketPath = PathUtils.concat((String)indexPath, (String[])new String[]{":property-index", propName, bucketName});
                        indexInfo.oldBucketPaths.add(bucketPath);
                        stats.purgedIndexPaths.add(indexPath);
                    }
                    continue;
                }
                if (!HybridPropertyIndexUtil.uniquePropertyIndex(propIdxState)) continue;
                String indexNodePath = PathUtils.concat((String)indexPath, (String[])new String[]{":property-index", propName});
                indexInfo.uniqueIndexPaths.put(indexNodePath, lastIndexedTo);
            }
        }
        if (modified) {
            this.merge(builder);
        }
        return indexInfo;
    }

    private void purgeOldBuckets(List<String> bucketPaths, CleanupStats stats) throws CommitFailedException {
        if (bucketPaths.isEmpty()) {
            return;
        }
        if (this.recursiveDelete) {
            RecursiveDelete rd = new RecursiveDelete(this.nodeStore, (CommitHook)this.createCommitHook(), PropertyIndexCleaner::createCommitInfo);
            rd.run(bucketPaths);
            stats.numOfNodesDeleted += rd.getNumRemoved();
        } else {
            NodeState root = this.nodeStore.getRoot();
            NodeBuilder builder = root.builder();
            for (String path : bucketPaths) {
                NodeBuilder bucket = PropertyIndexCleaner.child(builder, path);
                bucket.remove();
            }
            this.merge(builder);
        }
        stats.purgedBucketCount = bucketPaths.size();
    }

    private void purgeOldUniqueIndexEntries(Map<String, Long> asyncInfo, CleanupStats stats) throws CommitFailedException {
        NodeState root = this.nodeStore.getRoot();
        NodeBuilder builder = root.builder();
        for (Map.Entry<String, Long> e : asyncInfo.entrySet()) {
            String indexNodePath = e.getKey();
            NodeBuilder idxb = PropertyIndexCleaner.child(builder, indexNodePath);
            int removalCount = this.uniqueIndexCleaner.clean(idxb, e.getValue());
            if (removalCount > 0) {
                stats.purgedIndexPaths.add(PathUtils.getAncestorPath((String)indexNodePath, (int)2));
                this.log.debug("Removed [{}] entries from [{}]", (Object)removalCount, (Object)indexNodePath);
            }
            stats.uniqueIndexEntryRemovalCount += removalCount;
        }
        if (stats.uniqueIndexEntryRemovalCount > 0) {
            this.merge(builder);
        }
    }

    private void merge(NodeBuilder builder) throws CommitFailedException {
        CompositeHook hooks = this.createCommitHook();
        this.nodeStore.merge(builder, (CommitHook)hooks, PropertyIndexCleaner.createCommitInfo());
    }

    private CompositeHook createCommitHook() {
        return new CompositeHook(new CommitHook[]{ResetCommitAttributeHook.INSTANCE, new ConflictHook((ThreeWayConflictHandler)new AnnotatingConflictHandler()), new EditorHook(CompositeEditorProvider.compose(Collections.singletonList(new ConflictValidatorProvider())))});
    }

    private static CommitInfo createCommitInfo() {
        ImmutableMap info = ImmutableMap.of((Object)"oak.commitAttributes", (Object)new SimpleCommitContext());
        return new CommitInfo("oak:unknown", "oak:unknown", (Map)info);
    }

    private static NodeBuilder child(NodeBuilder nb, String path) {
        for (String name : PathUtils.elements((String)((String)Preconditions.checkNotNull((Object)path)))) {
            nb = nb.getChildNode(name);
        }
        return nb;
    }

    public static class CleanupStats {
        public int uniqueIndexEntryRemovalCount;
        public int purgedBucketCount;
        public Set<String> purgedIndexPaths = new HashSet<String>();
        public boolean cleanupPerformed;
        public int numOfNodesDeleted;

        public String toString() {
            String nodeCountMsg = this.numOfNodesDeleted > 0 ? String.format("(%d nodes)", this.numOfNodesDeleted) : "";
            return String.format("Removed %d index buckets %s, %d unique index entries from indexes %s", this.purgedBucketCount, nodeCountMsg, this.uniqueIndexEntryRemovalCount, this.purgedIndexPaths);
        }
    }

    private static final class IndexInfo {
        final List<String> oldBucketPaths = new ArrayList<String>();
        final Map<String, Long> uniqueIndexPaths = new HashMap<String, Long>();

        private IndexInfo() {
        }
    }
}

