/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import java.util.HashMap;
import java.util.Map;

public class MoreLikeThisHelperUtil {
    public static final String MLT_FILED = "mlt.fl";
    public static final String MLT_MIN_DOC_FREQ = "mlt.mindf";
    public static final String MLT_MAX_DOC_FREQ = "mlt.maxdf";
    public static final String MLT_MIN_TERM_FREQ = "mlt.mintf";
    public static final String MLT_BOOST = "mlt.boost";
    public static final String MLT_BOOST_FACTOR = "mlt.qf";
    public static final String MLT_MAX_DOC_FREQ_PCT = "mlt.maxdfp";
    public static final String MLT_MAX_NUM_TOKENS_PARSED = "mlt.maxntp";
    public static final String MLT_MAX_QUERY_TERMS = "mlt.maxqt";
    public static final String MLT_MAX_WORD_LENGTH = "mlt.maxwl";
    public static final String MLT_MIN_WORD_LENGTH = "mlt.minwl";
    public static final String MLT_STOP_WORDS = "mlt.stopwords";
    public static final String MLT_STREAM_BODY = "stream.body";
    public static final String MLT_MIN_SHOULD_MATCH = "mlt.minshouldmatch";

    public static Map<String, String> getParamMapFromMltQuery(String mltQueryString) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            for (String param : mltQueryString.split("&")) {
                String[] keyValuePair = param.split("=");
                if (keyValuePair.length != 2 || keyValuePair[0] == null || keyValuePair[1] == null) {
                    throw new RuntimeException("Unparsable native MLT query: " + mltQueryString);
                }
                paramMap.put(keyValuePair[0], keyValuePair[1]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing native MLT query: " + mltQueryString);
        }
        if (paramMap.size() == 0) {
            throw new RuntimeException("No params found while parsing the MLT query : " + mltQueryString);
        }
        return paramMap;
    }
}

