/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Chars;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.index.Cursors;
import org.apache.jackrabbit.oak.plugins.index.search.IndexLookup;
import org.apache.jackrabbit.oak.plugins.index.search.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.SizeEstimator;
import org.apache.jackrabbit.oak.plugins.index.search.spi.query.FulltextIndexPlanner;
import org.apache.jackrabbit.oak.plugins.index.search.spi.query.IndexName;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FulltextIndex
implements QueryIndex.AdvancedQueryIndex,
QueryIndex,
QueryIndex.NativeQueryIndex,
QueryIndex.AdvanceFulltextQueryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(FulltextIndex.class);
    public static final String ATTR_PLAN_RESULT = "oak.fulltext.planResult";
    private static final double MIN_COST = 2.1;
    private static final char[] QUERY_OPERATORS = new char[]{':', '/', '!', '&', '|', '='};

    protected abstract IndexNode acquireIndexNode(String var1);

    protected abstract String getType();

    protected abstract SizeEstimator getSizeEstimator(QueryIndex.IndexPlan var1);

    protected abstract Predicate<NodeState> getIndexDefinitionPredicate();

    protected abstract String getFulltextRequestString(QueryIndex.IndexPlan var1, IndexNode var2, NodeState var3);

    protected abstract boolean filterReplacedIndexes();

    protected abstract boolean runIsActiveIndexCheck();

    protected FulltextIndexPlanner getPlanner(IndexNode indexNode, String path, Filter filter, List<QueryIndex.OrderEntry> sortOrder) {
        return new FulltextIndexPlanner(indexNode, path, filter, sortOrder);
    }

    public double getMinimumCost() {
        return 2.1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState rootState) {
        Collection<String> indexPaths = new IndexLookup(rootState, this.getIndexDefinitionPredicate()).collectIndexNodePaths(filter);
        if (this.filterReplacedIndexes()) {
            indexPaths = IndexName.filterReplacedIndexes(indexPaths, rootState, this.runIsActiveIndexCheck());
        }
        ArrayList plans = Lists.newArrayListWithCapacity((int)indexPaths.size());
        for (String path : indexPaths) {
            IndexNode indexNode = null;
            try {
                QueryIndex.IndexPlan plan;
                indexNode = this.acquireIndexNode(path);
                if (indexNode == null || (plan = this.getPlanner(indexNode, path, filter, sortOrder).getPlan()) == null) continue;
                plans.add(plan);
            }
            catch (Exception e) {
                LOG.error("Error getting plan for {}", (Object)path);
                LOG.error("Exception:", (Throwable)e);
            }
            finally {
                if (indexNode == null) continue;
                indexNode.release();
            }
        }
        return plans;
    }

    public double getCost(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    public String getPlan(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        Filter filter = plan.getFilter();
        IndexNode index = this.acquireIndexNode(plan);
        Preconditions.checkState((index != null ? 1 : 0) != 0, (Object)("The fulltext index of type " + this.getType() + "  index is not available"));
        try {
            FullTextExpression ft = filter.getFullTextConstraint();
            StringBuilder sb = new StringBuilder(this.getType()).append(":");
            String path = FulltextIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath;
            sb.append(FulltextIndex.getIndexName(plan)).append("(").append(path).append(") ");
            sb.append(this.getFulltextRequestString(plan, index, root));
            if (plan.getSortOrder() != null && !plan.getSortOrder().isEmpty()) {
                sb.append(" ordering:").append(plan.getSortOrder());
            }
            if (ft != null) {
                sb.append(" ft:(").append(ft).append(")");
            }
            FulltextIndex.addSyncIndexPlan(plan, sb);
            String string = sb.toString();
            return string;
        }
        finally {
            index.release();
        }
    }

    protected static void addSyncIndexPlan(QueryIndex.IndexPlan plan, StringBuilder sb) {
        FulltextIndexPlanner.PlanResult pr = FulltextIndex.getPlanResult(plan);
        if (pr.hasPropertyIndexResult()) {
            FulltextIndexPlanner.PropertyIndexResult pres = pr.getPropertyIndexResult();
            sb.append(" sync:(").append(pres.propertyName);
            if (!pres.propertyName.equals(pres.pr.propertyName)) {
                sb.append("[").append(pres.pr.propertyName).append("]");
            }
            sb.append(" ").append(pres.pr);
            sb.append(")");
        }
        if (pr.evaluateSyncNodeTypeRestriction()) {
            sb.append(" sync:(nodeType");
            sb.append(" primaryTypes : ").append(plan.getFilter().getPrimaryTypes());
            sb.append(" mixinTypes : ").append(plan.getFilter().getMixinTypes());
            sb.append(")");
        }
    }

    public Cursor query(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    protected static boolean shouldInclude(String docPath, QueryIndex.IndexPlan plan) {
        String path = FulltextIndex.getPathRestriction(plan);
        boolean include = true;
        Filter filter = plan.getFilter();
        switch (filter.getPathRestriction()) {
            case EXACT: {
                include = path.equals(docPath);
                break;
            }
            case DIRECT_CHILDREN: {
                include = PathUtils.getParentPath((String)docPath).equals(path);
                break;
            }
            case ALL_CHILDREN: {
                include = PathUtils.isAncestor((String)path, (String)docPath);
            }
        }
        return include;
    }

    public QueryIndex.NodeAggregator getNodeAggregator() {
        return null;
    }

    public static boolean isNodePath(String fulltextTermPath) {
        return fulltextTermPath.endsWith("/*");
    }

    protected IndexNode acquireIndexNode(QueryIndex.IndexPlan plan) {
        return this.acquireIndexNode(FulltextIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath);
    }

    protected static String getIndexName(QueryIndex.IndexPlan plan) {
        return PathUtils.getName((String)FulltextIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath);
    }

    public static int determinePropertyType(PropertyDefinition defn, Filter.PropertyRestriction pr) {
        int typeFromRestriction = pr.propertyType;
        if (typeFromRestriction == 0) {
            if (pr.first != null && pr.first.getType() != Type.UNDEFINED) {
                typeFromRestriction = pr.first.getType().tag();
            } else if (pr.last != null && pr.last.getType() != Type.UNDEFINED) {
                typeFromRestriction = pr.last.getType().tag();
            } else if (pr.list != null && !pr.list.isEmpty()) {
                typeFromRestriction = ((PropertyValue)pr.list.get(0)).getType().tag();
            }
        }
        return FulltextIndex.getPropertyType(defn, pr.propertyName, typeFromRestriction);
    }

    protected static int getPropertyType(PropertyDefinition defn, String name, int defaultVal) {
        if (defn.isTypeDefined()) {
            return defn.getType();
        }
        return defaultVal;
    }

    protected static FulltextIndexPlanner.PlanResult getPlanResult(QueryIndex.IndexPlan plan) {
        return (FulltextIndexPlanner.PlanResult)plan.getAttribute(ATTR_PLAN_RESULT);
    }

    protected static String rewriteQueryText(String textsearch) {
        StringBuilder rewritten = new StringBuilder();
        textsearch = textsearch.replaceAll("AND", "and");
        textsearch = textsearch.replaceAll("NOT", "not");
        boolean escaped = false;
        for (int i = 0; i < textsearch.length(); ++i) {
            char c = textsearch.charAt(i);
            if (c == '\\') {
                if (escaped) {
                    rewritten.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (c == '\'') {
                if (escaped) {
                    escaped = false;
                }
                rewritten.append(c);
                continue;
            }
            if (Chars.contains((char[])QUERY_OPERATORS, (char)c)) {
                rewritten.append('\\').append(c);
                continue;
            }
            if (escaped) {
                rewritten.append('\\');
                escaped = false;
            }
            rewritten.append(c);
        }
        return rewritten.toString();
    }

    public static String getPathRestriction(QueryIndex.IndexPlan plan) {
        Filter f = plan.getFilter();
        String pathPrefix = plan.getPathPrefix();
        if (pathPrefix.isEmpty()) {
            return f.getPath();
        }
        String relativePath = PathUtils.relativize((String)pathPrefix, (String)f.getPath());
        return "/" + relativePath;
    }

    public static String parseFacetField(String columnName) {
        return columnName.substring("rep:facet".length() + 1, columnName.length() - 1);
    }

    public static class Facet {
        private final String label;
        private final int count;

        public Facet(String label, int count) {
            this.label = label;
            this.count = count;
        }

        @NotNull
        public String getLabel() {
            return this.label;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return "Facet{label='" + this.label + '\'' + ", count=" + this.count + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Facet facet = (Facet)o;
            return Objects.equals(this.label, facet.label);
        }

        public int hashCode() {
            return Objects.hash(this.label);
        }
    }

    public static interface IteratorRewoundStateProvider {
        public int rewoundCount();
    }

    protected static class FulltextPathCursor
    implements Cursor {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final int TRAVERSING_WARNING = Integer.getInteger("oak.traversing.warning", 10000);
        private final Cursor pathCursor;
        private final String pathPrefix;
        FulltextResultRow currentRow;
        private final SizeEstimator sizeEstimator;
        private long estimatedSize;
        private final int numberOfFacets;

        public FulltextPathCursor(final Iterator<FulltextResultRow> it, final IteratorRewoundStateProvider iterStateProvider, final QueryIndex.IndexPlan plan, final QueryLimits settings, SizeEstimator sizeEstimator) {
            this.pathPrefix = plan.getPathPrefix();
            this.sizeEstimator = sizeEstimator;
            Iterator<String> pathIterator = new Iterator<String>(){
                private int readCount;
                private int rewoundCount;

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    if (iterStateProvider.rewoundCount() > this.rewoundCount) {
                        this.readCount = 0;
                        this.rewoundCount = iterStateProvider.rewoundCount();
                    }
                    currentRow = (FulltextResultRow)it.next();
                    ++this.readCount;
                    if (this.readCount % TRAVERSING_WARNING == 0) {
                        Cursors.checkReadLimit((long)this.readCount, (QueryLimits)settings);
                        log.warn("Index-Traversed {} nodes with filter {}", (Object)this.readCount, (Object)plan.getFilter());
                    }
                    return currentRow.path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            FulltextIndexPlanner.PlanResult planResult = FulltextIndex.getPlanResult(plan);
            this.pathCursor = new Cursors.PathCursor((Iterator)pathIterator, planResult.isUniquePathsRequired(), settings);
            this.numberOfFacets = planResult.indexDefinition.getNumberOfTopFacets();
        }

        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        public void remove() {
            this.pathCursor.remove();
        }

        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                public boolean isVirtualRow() {
                    return currentRow.isVirutal;
                }

                public String getPath() {
                    String sub = pathRow.getPath();
                    if (this.isVirtualRow()) {
                        return sub;
                    }
                    if (!"".equals(pathPrefix) && PathUtils.denotesRoot((String)sub)) {
                        return pathPrefix;
                    }
                    if (PathUtils.isAbsolute((String)sub)) {
                        return pathPrefix + sub;
                    }
                    return PathUtils.concat((String)pathPrefix, (String)sub);
                }

                public PropertyValue getValue(String columnName) {
                    String excerpt;
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble((Double)currentRow.score);
                    }
                    if ("rep:spellcheck()".equals(columnName) || "rep:suggest()".equals(columnName)) {
                        return PropertyValues.newString((String)currentRow.suggestion);
                    }
                    if ("oak:scoreExplanation".equals(columnName)) {
                        return PropertyValues.newString((String)currentRow.explanation);
                    }
                    if (columnName.startsWith("rep:excerpt") && (excerpt = currentRow.excerpts.get(columnName)) != null) {
                        return PropertyValues.newString((String)excerpt);
                    }
                    if (columnName.startsWith("rep:facet")) {
                        try {
                            List<Facet> facets = currentRow.getFacets(numberOfFacets, columnName);
                            if (facets != null) {
                                JsopBuilder writer = new JsopBuilder();
                                writer.object();
                                for (Facet f : facets) {
                                    writer.key(f.getLabel()).value((long)f.getCount());
                                }
                                writer.endObject();
                                return PropertyValues.newString((String)writer.toString());
                            }
                        }
                        catch (IOException | RuntimeException e) {
                            LOG.warn(e.getMessage());
                            LOG.debug(e.getMessage(), (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                    return pathRow.getValue(columnName);
                }
            };
        }

        public long getSize(Result.SizePrecision precision, long max) {
            if (this.estimatedSize != 0L) {
                return this.estimatedSize;
            }
            this.estimatedSize = this.sizeEstimator.getSize();
            return this.estimatedSize;
        }
    }

    public static interface FacetProvider {
        public List<Facet> getFacets(int var1, String var2) throws IOException;
    }

    public static class FulltextResultRow {
        public final String path;
        public final double score;
        public final String suggestion;
        public final boolean isVirutal;
        public final Map<String, String> excerpts;
        public final String explanation;
        private final FacetProvider facetProvider;

        public FulltextResultRow(String path, double score, Map<String, String> excerpts, FacetProvider facetProvider, String explanation) {
            this.explanation = explanation;
            this.excerpts = excerpts;
            this.facetProvider = facetProvider;
            this.isVirutal = false;
            this.path = path;
            this.score = score;
            this.suggestion = null;
        }

        public FulltextResultRow(String suggestion, long weight) {
            this(suggestion, (double)weight);
        }

        public FulltextResultRow(String suggestion, double weight) {
            this.isVirutal = true;
            this.path = "/";
            this.score = weight;
            this.suggestion = suggestion;
            this.excerpts = null;
            this.facetProvider = null;
            this.explanation = null;
        }

        public FulltextResultRow(String suggestion) {
            this(suggestion, 1L);
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }

        public List<Facet> getFacets(int numberOfFacets, String columnName) throws IOException {
            if (this.facetProvider == null) {
                return null;
            }
            return this.facetProvider.getFacets(numberOfFacets, columnName);
        }
    }
}

