/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.FacetTestHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexStatistics;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndexFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReader;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.search.update.ReaderRefreshPolicy;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexNodeManager {
    static final String ASYNC = ":async";
    private static final AtomicInteger SEARCHER_ID_COUNTER = new AtomicInteger();
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(LuceneIndexNodeManager.class.getName() + ".perf")));
    public static final String OLD_FACET_PROVIDER_TEST_FAILURE_SLEEP_INSTRUMENT_NAME = "oak.lucene.oldFacetProviderTestFailSleepInstrument";
    private static final int OLD_FACET_PROVIDER_TEST_FAILURE_SLEEP_INSTRUMENT_VALUE = Integer.getInteger("oak.lucene.oldFacetProviderTestFailSleepInstrument", 0);
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexNodeManager.class);
    private final List<LuceneIndexReader> readers;
    private final String name;
    private final LuceneIndexDefinition definition;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile SearcherHolder searcherHolder;
    private final NRTIndex nrtIndex;
    private final ReaderRefreshPolicy refreshPolicy;
    private final Semaphore refreshLock = new Semaphore(1);
    private final Runnable refreshCallback = new Runnable(){

        @Override
        public void run() {
            FacetTestHelper.sleep(OLD_FACET_PROVIDER_TEST_FAILURE_SLEEP_INSTRUMENT_VALUE);
            if (LuceneIndexNodeManager.this.refreshLock.tryAcquire()) {
                try {
                    LuceneIndexNodeManager.this.refreshReaders();
                }
                finally {
                    LuceneIndexNodeManager.this.refreshLock.release();
                }
            }
        }
    };
    private boolean closed = false;

    static LuceneIndexNodeManager open(String indexPath, NodeState root, NodeState defnNodeState, LuceneIndexReaderFactory readerFactory, @Nullable NRTIndexFactory nrtFactory) throws IOException {
        NRTIndex nrtIndex;
        LuceneIndexDefinition definition = new LuceneIndexDefinition(root, defnNodeState, indexPath);
        List<LuceneIndexReader> readers = readerFactory.createReaders(definition, defnNodeState, indexPath);
        NRTIndex nRTIndex = nrtIndex = nrtFactory != null ? nrtFactory.createIndex(definition) : null;
        if (!readers.isEmpty() || nrtIndex != null && !LuceneIndexNodeManager.hasAsyncIndexerRun(root, indexPath, defnNodeState)) {
            return new LuceneIndexNodeManager(PathUtils.getName((String)indexPath), definition, readers, nrtIndex);
        }
        return null;
    }

    static boolean hasAsyncIndexerRun(NodeState root, String indexPath, NodeState defnNodeState) {
        boolean hasAsyncNode = root.hasChildNode(ASYNC);
        String asyncLaneName = IndexUtils.getAsyncLaneName((NodeState)defnNodeState, (String)indexPath, (PropertyState)defnNodeState.getProperty("async"));
        if (asyncLaneName != null) {
            return hasAsyncNode && root.getChildNode(ASYNC).hasProperty(asyncLaneName);
        }
        return false;
    }

    LuceneIndexNodeManager(String name, LuceneIndexDefinition definition, List<LuceneIndexReader> readers, @Nullable NRTIndex nrtIndex) throws IOException {
        Preconditions.checkArgument((!readers.isEmpty() || nrtIndex != null ? 1 : 0) != 0);
        this.name = name;
        this.definition = definition;
        this.readers = readers;
        this.nrtIndex = nrtIndex;
        this.searcherHolder = this.createHolder(this.getNRTReaders());
        this.refreshPolicy = nrtIndex != null ? nrtIndex.getRefreshPolicy() : ReaderRefreshPolicy.NEVER;
    }

    private String getName() {
        return this.name;
    }

    LuceneIndexDefinition getDefinition() {
        return this.definition;
    }

    @Nullable
    private Directory getSuggestDirectory() {
        return this.readers.isEmpty() ? null : this.getDefaultReader().getSuggestDirectory();
    }

    @Nullable
    private AnalyzingInfixSuggester getLookup() {
        return this.readers.isEmpty() ? null : this.getDefaultReader().getLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    LuceneIndexNode acquire() {
        this.lock.readLock().lock();
        if (this.closed) {
            this.lock.readLock().unlock();
            return null;
        }
        boolean success = false;
        try {
            this.refreshPolicy.refreshOnReadIfRequired(this.refreshCallback);
            SearcherHolder local = this.searcherHolder;
            int tryCount = 0;
            while (!local.searcher.getIndexReader().tryIncRef()) {
                Preconditions.checkState((++tryCount < 10 ? 1 : 0) != 0, (String)"Not able to get open searcher in %s attempts", (Object[])new Object[]{tryCount});
                local = this.searcherHolder;
            }
            IndexNodeImpl indexNode = new IndexNodeImpl(local);
            success = true;
            IndexNodeImpl indexNodeImpl = indexNode;
            return indexNodeImpl;
        }
        finally {
            if (!success) {
                this.lock.readLock().unlock();
            }
        }
    }

    private void release() {
        this.lock.readLock().unlock();
    }

    void close() throws IOException {
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.closed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.releaseHolder(this.searcherHolder);
        this.closeReaders(this.readers);
    }

    private List<LuceneIndexReader> getPrimaryReaders() {
        return this.readers;
    }

    @Nullable
    private LuceneIndexWriter getLocalWriter() throws IOException {
        return this.nrtIndex != null ? this.nrtIndex.getWriter() : null;
    }

    private void refreshReadersOnWriteIfRequired() {
        this.refreshPolicy.refreshOnWriteIfRequired(this.refreshCallback);
    }

    private void refreshReaders() {
        long start = PERF_LOGGER.start();
        List<LuceneIndexReader> newNRTReaders = this.getNRTReaders();
        if (newNRTReaders != this.searcherHolder.nrtReaders) {
            SearcherHolder old = this.searcherHolder;
            this.searcherHolder = this.createHolder(newNRTReaders);
            this.releaseHolder(old);
            PERF_LOGGER.end(start, 0L, "Refreshed reader for index [{}]", (Object)this.definition);
        }
    }

    private LuceneIndexReader getDefaultReader() {
        return this.readers.get(0);
    }

    private IndexReader createReader(List<LuceneIndexReader> nrtReaders) {
        if (this.readers.size() == 1 && nrtReaders.isEmpty()) {
            IndexReader reader = this.readers.get(0).getReader();
            reader.incRef();
            return reader;
        }
        if (nrtReaders.size() == 1 && this.readers.isEmpty()) {
            IndexReader reader = nrtReaders.get(0).getReader();
            reader.incRef();
            return reader;
        }
        IndexReader[] readerArr = new IndexReader[this.readers.size() + nrtReaders.size()];
        int i = 0;
        for (LuceneIndexReader r : Iterables.concat(this.readers, nrtReaders)) {
            readerArr[i++] = r.getReader();
        }
        return new MultiReader(readerArr, false);
    }

    private List<LuceneIndexReader> getNRTReaders() {
        return this.nrtIndex != null ? this.nrtIndex.getReaders() : Collections.emptyList();
    }

    private SearcherHolder createHolder(List<LuceneIndexReader> newNRTReaders) {
        return new SearcherHolder(new IndexSearcher(this.createReader(newNRTReaders)), newNRTReaders);
    }

    private void closeReaders(Iterable<LuceneIndexReader> readers) {
        for (LuceneIndexReader r : readers) {
            try {
                r.close();
            }
            catch (IOException e) {
                log.warn("Error occurred while releasing reader for index [{}]", (Object)this.definition.getIndexPath(), (Object)e);
            }
        }
    }

    private void releaseHolder(SearcherHolder holder) {
        this.decrementSearcherUsageCount(holder.searcher);
    }

    private void decrementSearcherUsageCount(IndexSearcher searcher) {
        try {
            searcher.getIndexReader().decRef();
        }
        catch (IOException e) {
            log.warn("Error occurred while releasing reader for index [{}]", (Object)this.definition.getIndexPath(), (Object)e);
        }
    }

    private class IndexNodeImpl
    implements LuceneIndexNode {
        private final SearcherHolder holder;
        private final AtomicBoolean released = new AtomicBoolean();

        private IndexNodeImpl(SearcherHolder searcherHolder) {
            this.holder = searcherHolder;
        }

        @Override
        public void release() {
            if (this.released.compareAndSet(false, true)) {
                try {
                    LuceneIndexNodeManager.this.decrementSearcherUsageCount(this.holder.searcher);
                }
                finally {
                    LuceneIndexNodeManager.this.release();
                }
            }
        }

        @Override
        public IndexSearcher getSearcher() {
            return this.holder.searcher;
        }

        @Override
        public LuceneIndexStatistics getIndexStatistics() {
            return this.holder.getIndexStatistics();
        }

        @Override
        public LuceneIndexDefinition getDefinition() {
            return LuceneIndexNodeManager.this.definition;
        }

        @Override
        public List<LuceneIndexReader> getPrimaryReaders() {
            return LuceneIndexNodeManager.this.getPrimaryReaders();
        }

        @Override
        public Directory getSuggestDirectory() {
            return LuceneIndexNodeManager.this.getSuggestDirectory();
        }

        @Override
        public List<LuceneIndexReader> getNRTReaders() {
            return this.holder.nrtReaders;
        }

        @Override
        public AnalyzingInfixSuggester getLookup() {
            return LuceneIndexNodeManager.this.getLookup();
        }

        @Override
        public int getIndexNodeId() {
            return this.holder.searcherId;
        }

        @Override
        public LuceneIndexWriter getLocalWriter() throws IOException {
            return LuceneIndexNodeManager.this.getLocalWriter();
        }

        @Override
        public void refreshReadersOnWriteIfRequired() {
            LuceneIndexNodeManager.this.refreshReadersOnWriteIfRequired();
        }
    }

    private static class SearcherHolder {
        final IndexSearcher searcher;
        final List<LuceneIndexReader> nrtReaders;
        final int searcherId = SEARCHER_ID_COUNTER.incrementAndGet();
        final LuceneIndexStatistics indexStatistics;

        public SearcherHolder(IndexSearcher searcher, List<LuceneIndexReader> nrtReaders) {
            this.searcher = searcher;
            this.nrtReaders = nrtReaders;
            this.indexStatistics = new LuceneIndexStatistics(searcher.getIndexReader());
        }

        public LuceneIndexStatistics getIndexStatistics() {
            return this.indexStatistics;
        }
    }
}

