/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalProperty;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalPropertyBuilder;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexedPaths;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDocInfo;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDocumentHolder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneJournalPropertyBuilder
implements JournalPropertyBuilder<LuceneDocumentHolder> {
    private static final Logger log = LoggerFactory.getLogger(LuceneJournalPropertyBuilder.class);
    private final Multimap<String, String> indexedNodes = HashMultimap.create();
    private boolean limitWarningLogged = false;
    private final int maxSize;

    LuceneJournalPropertyBuilder(int maxSize) {
        this.maxSize = maxSize;
    }

    public void addProperty(@Nullable LuceneDocumentHolder docHolder) {
        if (docHolder != null) {
            for (LuceneDocInfo luceneDocInfo : docHolder.getAllLuceneDocInfo()) {
                if (!this.sizeWithinLimits()) continue;
                this.indexedNodes.put((Object)luceneDocInfo.getDocPath(), (Object)luceneDocInfo.getIndexPath());
            }
        }
    }

    public String buildAsString() {
        JsopBuilder json = new JsopBuilder();
        json.object();
        for (Map.Entry e : this.indexedNodes.asMap().entrySet()) {
            json.key((String)e.getKey()).array();
            for (String v : (Collection)e.getValue()) {
                json.value(v);
            }
            json.endArray();
        }
        json.endObject();
        return json.toString();
    }

    public void addSerializedProperty(@Nullable String json) {
        if (json == null || json.isEmpty()) {
            return;
        }
        JsopTokenizer reader = new JsopTokenizer(json);
        reader.read(123);
        if (!reader.matches(125)) {
            do {
                String path = reader.readString();
                reader.read(58);
                reader.read(91);
                boolean first = true;
                while (!reader.matches(93)) {
                    if (!first) {
                        reader.read(44);
                    }
                    String s = reader.readString();
                    if (this.sizeWithinLimits()) {
                        this.indexedNodes.put((Object)path, (Object)s);
                    }
                    first = false;
                }
            } while (reader.matches(44));
            reader.read(125);
        }
        reader.read(0);
    }

    public JournalProperty build() {
        return new IndexedPaths(this.indexedNodes);
    }

    private boolean sizeWithinLimits() {
        if (this.indexedNodes.size() >= this.maxSize) {
            if (!this.limitWarningLogged) {
                log.warn("Max size of {} reached. Further addition of index path data would be dropped", (Object)this.maxSize);
                this.limitWarningLogged = true;
            }
            return false;
        }
        return true;
    }
}

