/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class UniqueIndexCleaner {
    private final long createTimeMarginMillis;

    public UniqueIndexCleaner(TimeUnit timeUnit, long createTimeMargin) {
        this.createTimeMarginMillis = timeUnit.toMillis(createTimeMargin);
    }

    public int clean(NodeBuilder builder, long lastIndexedTo) {
        int removalCount = 0;
        NodeState baseState = builder.getBaseState();
        for (ChildNodeEntry e : baseState.getChildNodeEntries()) {
            long entryCreationTime = e.getNodeState().getLong("jcr:created");
            if (!this.entryCovered(entryCreationTime, lastIndexedTo)) continue;
            builder.child(e.getName()).remove();
            ++removalCount;
        }
        return removalCount;
    }

    private boolean entryCovered(long entryCreationTime, long lastIndexedTo) {
        return lastIndexedTo - entryCreationTime >= this.createTimeMarginMillis;
    }
}

