/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.reader;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.DefaultIndexReader;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReader;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.MultiplexersLucene;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.jetbrains.annotations.Nullable;

public class DefaultIndexReaderFactory
implements LuceneIndexReaderFactory {
    private final IndexCopier cloner;
    private final MountInfoProvider mountInfoProvider;

    public DefaultIndexReaderFactory(MountInfoProvider mountInfoProvider, @Nullable IndexCopier cloner) {
        this.cloner = cloner;
        this.mountInfoProvider = mountInfoProvider;
    }

    @Override
    public List<LuceneIndexReader> createReaders(LuceneIndexDefinition definition, NodeState defnState, String indexPath) throws IOException {
        if (!this.mountInfoProvider.hasNonDefaultMounts()) {
            LuceneIndexReader reader = this.createReader(definition, defnState, indexPath, ":data", ":suggest-data");
            return reader != null ? ImmutableList.of((Object)reader) : Collections.emptyList();
        }
        return this.createMountedReaders(definition, defnState, indexPath);
    }

    private List<LuceneIndexReader> createMountedReaders(LuceneIndexDefinition definition, NodeState defnState, String indexPath) throws IOException {
        ImmutableList.Builder readers = ImmutableList.builder();
        LuceneIndexReader reader = this.createReader(this.mountInfoProvider.getDefaultMount(), definition, defnState, indexPath);
        if (reader != null) {
            readers.add((Object)reader);
        }
        for (Mount m : this.mountInfoProvider.getNonDefaultMounts()) {
            reader = this.createReader(m, definition, defnState, indexPath);
            if (reader == null || reader.getReader() == null || reader.getReader().numDocs() <= 0) continue;
            readers.add((Object)reader);
        }
        return readers.build();
    }

    @Nullable
    private LuceneIndexReader createReader(Mount mount, LuceneIndexDefinition definition, NodeState defnNodeState, String indexPath) throws IOException {
        return this.createReader(definition, defnNodeState, indexPath, MultiplexersLucene.getIndexDirName(mount), MultiplexersLucene.getSuggestDirName(mount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private LuceneIndexReader createReader(LuceneIndexDefinition definition, NodeState defnNodeState, String indexPath, String indexDataNodeName, String suggestDataNodeName) throws IOException {
        String path;
        Directory directory = null;
        NodeState data = defnNodeState.getChildNode(indexDataNodeName);
        if (data.exists()) {
            directory = new OakDirectory((NodeBuilder)new ReadOnlyBuilder(defnNodeState), indexDataNodeName, definition, true);
            if (this.cloner != null) {
                directory = this.cloner.wrapForRead(indexPath, definition, directory, indexDataNodeName);
            }
        } else if ("file".equalsIgnoreCase(defnNodeState.getString("persistence")) && (path = defnNodeState.getString("path")) != null && new File(path).exists()) {
            directory = FSDirectory.open(new File(path));
        }
        if (directory != null) {
            Directory suggestDirectory = null;
            if (definition.isSuggestEnabled()) {
                suggestDirectory = new OakDirectory((NodeBuilder)new ReadOnlyBuilder(defnNodeState), suggestDataNodeName, definition, true);
                if (this.cloner != null && definition.getUniqueId() != null) {
                    suggestDirectory = this.cloner.wrapForRead(indexPath, definition, suggestDirectory, suggestDataNodeName);
                }
            }
            try {
                DefaultIndexReader reader = new DefaultIndexReader(directory, suggestDirectory, definition.getAnalyzer());
                directory = null;
                DefaultIndexReader defaultIndexReader = reader;
                return defaultIndexReader;
            }
            finally {
                if (directory != null) {
                    directory.close();
                }
            }
        }
        return null;
    }

    @Override
    public MountInfoProvider getMountInfoProvider() {
        return this.mountInfoProvider;
    }
}

