/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util.fv;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

final class FeaturePositionTokenFilter
extends TokenFilter {
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private int tokenCount = 0;

    FeaturePositionTokenFilter(TokenStream stream) {
        super(stream);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            ++this.tokenCount;
            String token = new String(this.termAttribute.buffer(), 0, this.termAttribute.length());
            this.termAttribute.setEmpty();
            this.termAttribute.append(String.valueOf(this.tokenCount));
            this.termAttribute.append("_");
            this.termAttribute.append(token);
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.tokenCount = 0;
    }
}

