/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.editor;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Calendar;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexingContext;
import org.apache.jackrabbit.oak.plugins.index.search.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.search.ReindexOperations;
import org.apache.jackrabbit.oak.plugins.index.search.spi.binary.FulltextBinaryTextExtractor;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.DocumentMaker;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexWriterFactory;
import org.apache.jackrabbit.oak.plugins.index.search.util.NodeStateCloner;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FulltextIndexEditorContext<D> {
    private static final Logger log = LoggerFactory.getLogger(FulltextIndexEditorContext.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(FulltextIndexEditorContext.class.getName() + ".perf")));
    protected IndexDefinition definition;
    protected final NodeBuilder definitionBuilder;
    private final FulltextIndexWriterFactory<D> indexWriterFactory;
    private FulltextIndexWriter<D> writer = null;
    private long indexedNodes;
    private final IndexUpdateCallback updateCallback;
    private boolean reindex;
    private final ExtractedTextCache extractedTextCache;
    private final NodeState root;
    private final IndexingContext indexingContext;
    private final boolean asyncIndexing;
    private static Clock clock = Clock.SIMPLE;
    private final boolean indexDefnRewritten;
    private FulltextBinaryTextExtractor textExtractor;
    private PropertyUpdateCallback propertyUpdateCallback;

    protected FulltextIndexEditorContext(NodeState root, NodeBuilder definition, @Nullable IndexDefinition indexDefinition, IndexUpdateCallback updateCallback, FulltextIndexWriterFactory<D> indexWriterFactory, ExtractedTextCache extractedTextCache, IndexingContext indexingContext, boolean asyncIndexing) {
        this.root = root;
        this.indexingContext = (IndexingContext)Preconditions.checkNotNull((Object)indexingContext);
        this.definitionBuilder = definition;
        this.indexWriterFactory = indexWriterFactory;
        this.definition = indexDefinition != null ? indexDefinition : this.createIndexDefinition(root, definition, indexingContext, asyncIndexing);
        this.indexedNodes = 0L;
        this.updateCallback = updateCallback;
        this.extractedTextCache = extractedTextCache;
        this.asyncIndexing = asyncIndexing;
        if (this.definition.isOfOldFormat()) {
            this.indexDefnRewritten = true;
            IndexDefinition.updateDefinition(definition, indexingContext.getIndexPath());
        } else {
            this.indexDefnRewritten = false;
        }
    }

    public abstract IndexDefinition.Builder newDefinitionBuilder();

    public abstract DocumentMaker<D> newDocumentMaker(IndexDefinition.IndexingRule var1, String var2);

    protected FulltextBinaryTextExtractor createBinaryTextExtractor(ExtractedTextCache extractedTextCache, IndexDefinition definition, boolean reindex) {
        return new FulltextBinaryTextExtractor(extractedTextCache, definition, reindex);
    }

    public FulltextIndexWriter<D> getWriter() {
        if (this.writer == null) {
            this.writer = this.indexWriterFactory.newInstance(this.definition, this.definitionBuilder, this.indexingContext.getCommitInfo(), this.reindex);
        }
        return this.writer;
    }

    public IndexingContext getIndexingContext() {
        return this.indexingContext;
    }

    @Nullable
    public PropertyUpdateCallback getPropertyUpdateCallback() {
        return this.propertyUpdateCallback;
    }

    public void setPropertyUpdateCallback(PropertyUpdateCallback propertyUpdateCallback) {
        this.propertyUpdateCallback = propertyUpdateCallback;
    }

    public void closeWriter() throws IOException {
        Calendar currentTime = FulltextIndexEditorContext.getCalendar();
        long start = PERF_LOGGER.start();
        boolean indexUpdated = this.getWriter().close(currentTime.getTimeInMillis());
        if (indexUpdated) {
            PERF_LOGGER.end(start, -1L, "Closed writer for directory {}", (Object)this.definition);
            NodeBuilder status = this.definitionBuilder.child(":status");
            status.setProperty("lastUpdated", (Object)this.getUpdatedTime(currentTime), Type.DATE);
            status.setProperty("indexedNodes", (Object)this.indexedNodes);
            if (this.reindex) {
                status.setProperty("reindexCompletionTimestamp", (Object)ISO8601.format((Calendar)currentTime), Type.DATE);
                log.info("reindexCompletionTimestamp set to current time for index:" + this.definition.getIndexPath());
            }
            PERF_LOGGER.end(start, -1L, "Overall Closed IndexWriter for directory {}", (Object)this.definition);
            if (this.textExtractor != null) {
                this.textExtractor.done(this.reindex);
            }
        }
    }

    private String getUpdatedTime(Calendar currentTime) {
        CommitInfo info = this.getIndexingContext().getCommitInfo();
        String checkpointTime = (String)info.getInfo().get("indexingCheckpointTime");
        if (checkpointTime != null) {
            return checkpointTime;
        }
        return ISO8601.format((Calendar)currentTime);
    }

    protected static void setClock(Clock c) {
        Preconditions.checkNotNull((Object)c);
        clock = c;
    }

    private static Calendar getCalendar() {
        Calendar ret = Calendar.getInstance();
        ret.setTime(clock.getDate());
        return ret;
    }

    public void enableReindexMode() {
        this.reindex = true;
        ReindexOperations reindexOps = new ReindexOperations(this.root, this.definitionBuilder, this.definition.getIndexPath(), this.newDefinitionBuilder(), this.storedIndexDefinitionEnabled());
        this.definition = reindexOps.apply(this.indexDefnRewritten);
    }

    public boolean storedIndexDefinitionEnabled() {
        return !IndexDefinition.isDisableStoredIndexDefinition();
    }

    public long incIndexedNodes() {
        ++this.indexedNodes;
        return this.indexedNodes;
    }

    public boolean isAsyncIndexing() {
        return this.asyncIndexing;
    }

    public long getIndexedNodes() {
        return this.indexedNodes;
    }

    public void indexUpdate() throws CommitFailedException {
        this.updateCallback.indexUpdate();
    }

    public IndexDefinition getDefinition() {
        return this.definition;
    }

    protected FulltextBinaryTextExtractor getTextExtractor() {
        if (this.textExtractor == null && this.isAsyncIndexing()) {
            this.textExtractor = this.createBinaryTextExtractor(this.extractedTextCache, this.definition, this.reindex);
        }
        return this.textExtractor;
    }

    public boolean isReindex() {
        return this.reindex;
    }

    public static String configureUniqueId(NodeBuilder definition) {
        NodeBuilder status = definition.child(":status");
        String uid = status.getString("uid");
        if (uid == null) {
            try {
                uid = String.valueOf(Clock.SIMPLE.getTimeIncreasing());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                uid = String.valueOf(Clock.SIMPLE.getTime());
            }
            status.setProperty("uid", (Object)uid);
        }
        return uid;
    }

    private IndexDefinition createIndexDefinition(NodeState root, NodeBuilder definition, IndexingContext indexingContext, boolean asyncIndexing) {
        NodeState defnState = definition.getBaseState();
        if (asyncIndexing) {
            Long defRandom = this.getLongPropertyOrNull(definition.getProperty("seed"));
            if (defRandom == null) {
                long seed = UUID.randomUUID().getMostSignificantBits();
                definition.setProperty("seed", (Object)seed);
                defRandom = seed;
            }
            if (this.storedIndexDefinitionEnabled()) {
                if (definition.getBoolean("refresh")) {
                    definition.removeProperty("refresh");
                    NodeState clonedState = NodeStateCloner.cloneVisibleState(defnState);
                    definition.setChildNode(":index-definition", clonedState);
                    definition.getChildNode(":index-definition").setProperty("creationTimestamp", (Object)ISO8601.format((Calendar)Calendar.getInstance()), Type.DATE);
                    log.info("Refreshed the index definition for [{}]", (Object)indexingContext.getIndexPath());
                    log.info("IndexDefinition creation timestamp updated for [{}]", (Object)indexingContext.getIndexPath());
                    if (log.isDebugEnabled()) {
                        log.debug("Updated index definition is {}", (Object)NodeStateUtils.toString((NodeState)clonedState));
                    }
                } else if (!definition.hasChildNode(":index-definition")) {
                    definition.setChildNode(":index-definition", NodeStateCloner.cloneVisibleState(defnState));
                    definition.getChildNode(":index-definition").setProperty("creationTimestamp", (Object)ISO8601.format((Calendar)Calendar.getInstance()), Type.DATE);
                    log.info("Stored the cloned index definition for [{}]. Changes in index definition would now only be effective post reindexing", (Object)indexingContext.getIndexPath());
                    log.info("IndexDefinition creation timestamp added for [{}]", (Object)indexingContext.getIndexPath());
                } else {
                    NodeState clonedState = defnState.getChildNode(":index-definition");
                    Long clonedRandom = this.getLongPropertyOrNull(clonedState.getProperty("seed"));
                    if (clonedRandom == null || clonedRandom != defRandom) {
                        definition.getChildNode(":index-definition").setProperty("seed", (Object)defRandom);
                    }
                }
            }
        }
        return this.newDefinitionBuilder().root(root).defn(defnState).indexPath(indexingContext.getIndexPath()).build();
    }

    private Long getLongPropertyOrNull(PropertyState propertyState) {
        Long ret = null;
        if (propertyState != null) {
            try {
                ret = (Long)propertyState.getValue(Type.LONG);
            }
            catch (Exception e) {
                log.debug("Error occurred while reading property as long.", (Throwable)e);
            }
        }
        return ret;
    }
}

