/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.ContextAwareCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexCommitCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexingContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.AsyncIndexesSizeStatsUpdate;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditor;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexStatsUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.ActiveDeletedBlobCollectorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.CopyOnWriteDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DefaultDirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexingQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LocalIndexWriterFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDocumentHolder;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.LuceneIndexPropertyQuery;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.PropertyIndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.DefaultIndexWriterFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterConfig;
import org.apache.jackrabbit.oak.plugins.index.search.CompositePropertyUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.search.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexWriterFactory;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitContext;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.lucene.index.IndexableField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexEditorProvider
implements IndexEditorProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IndexCopier indexCopier;
    private final ExtractedTextCache extractedTextCache;
    private final IndexAugmentorFactory augmentorFactory;
    private final IndexTracker indexTracker;
    private final MountInfoProvider mountInfoProvider;
    private final ActiveDeletedBlobCollectorFactory.ActiveDeletedBlobCollector activeDeletedBlobCollector;
    private GarbageCollectableBlobStore blobStore;
    private IndexingQueue indexingQueue;
    private boolean nrtIndexingEnabled;
    private LuceneIndexWriterConfig writerConfig = new LuceneIndexWriterConfig();
    private final LuceneIndexMBean mbean;
    private final StatisticsProvider statisticsProvider;
    private int inMemoryDocsLimit = Integer.getInteger("oak.lucene.inMemoryDocsLimit", 500);
    private AsyncIndexesSizeStatsUpdate asyncIndexesSizeStatsUpdate;

    public LuceneIndexEditorProvider() {
        this(null);
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier) {
        this(indexCopier, new ExtractedTextCache(0L, 0L));
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache) {
        this(indexCopier, extractedTextCache, null, Mounts.defaultMountInfoProvider());
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache, @Nullable IndexAugmentorFactory augmentorFactory, MountInfoProvider mountInfoProvider) {
        this(indexCopier, null, extractedTextCache, augmentorFactory, mountInfoProvider);
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, @Nullable IndexTracker indexTracker, ExtractedTextCache extractedTextCache, @Nullable IndexAugmentorFactory augmentorFactory, MountInfoProvider mountInfoProvider) {
        this(indexCopier, indexTracker, extractedTextCache, augmentorFactory, mountInfoProvider, ActiveDeletedBlobCollectorFactory.NOOP, null, null);
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, @Nullable IndexTracker indexTracker, ExtractedTextCache extractedTextCache, @Nullable IndexAugmentorFactory augmentorFactory, MountInfoProvider mountInfoProvider, @NotNull ActiveDeletedBlobCollectorFactory.ActiveDeletedBlobCollector activeDeletedBlobCollector, @Nullable LuceneIndexMBean mbean, @Nullable StatisticsProvider statisticsProvider) {
        this.indexCopier = indexCopier;
        this.indexTracker = indexTracker;
        this.extractedTextCache = extractedTextCache != null ? extractedTextCache : new ExtractedTextCache(0L, 0L);
        this.augmentorFactory = augmentorFactory;
        this.mountInfoProvider = (MountInfoProvider)Preconditions.checkNotNull((Object)mountInfoProvider);
        this.activeDeletedBlobCollector = activeDeletedBlobCollector;
        this.mbean = mbean;
        this.statisticsProvider = statisticsProvider;
    }

    public LuceneIndexEditorProvider withAsyncIndexesSizeStatsUpdate(AsyncIndexesSizeStatsUpdate asyncIndexesSizeStatsUpdate) {
        this.asyncIndexesSizeStatsUpdate = asyncIndexesSizeStatsUpdate;
        return this;
    }

    public Editor getIndexEditor(@NotNull String type, @NotNull NodeBuilder definition, @NotNull NodeState root, @NotNull IndexUpdateCallback callback) throws CommitFailedException {
        if ("lucene".equals(type)) {
            Preconditions.checkArgument((boolean)(callback instanceof ContextAwareCallback), (String)"callback instance not of type ContextAwareCallback [%s]", (Object)callback);
            IndexingContext indexingContext = ((ContextAwareCallback)callback).getIndexingContext();
            ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback = this.activeDeletedBlobCollector.getBlobDeletionCallback();
            indexingContext.registerIndexCommitCallback((IndexCommitCallback)blobDeletionCallback);
            FulltextIndexWriterFactory<Iterable<IndexableField>> writerFactory = null;
            IndexDefinition indexDefinition = null;
            boolean asyncIndexing = true;
            String indexPath = indexingContext.getIndexPath();
            LinkedList<PropertyUpdateCallback> callbacks = new LinkedList<PropertyUpdateCallback>();
            PropertyIndexUpdateCallback propertyIndexUpdateCallback = null;
            if (this.nrtIndexingEnabled() && !indexingContext.isAsync() && IndexDefinition.supportsSyncOrNRTIndexing(definition)) {
                if (indexingContext.isReindexing()) {
                    return null;
                }
                CommitContext commitContext = LuceneIndexEditorProvider.getCommitContext(indexingContext);
                if (commitContext == null) {
                    this.log.warn("No CommitContext found for commit", (Throwable)new Exception());
                    return null;
                }
                writerFactory = new LocalIndexWriterFactory(this.getDocumentHolder(commitContext), indexPath);
                if (this.indexTracker != null && (indexDefinition = this.indexTracker.getIndexDefinition(indexPath)) != null && !indexDefinition.hasMatchingNodeTypeReg(root)) {
                    this.log.debug("Detected change in NodeType registry for index {}. Would not use existing index definition", (Object)indexDefinition.getIndexPath());
                    indexDefinition = null;
                }
                if (indexDefinition == null) {
                    indexDefinition = LuceneIndexDefinition.newBuilder(root, definition.getNodeState(), indexPath).build();
                }
                if (indexDefinition.hasSyncPropertyDefinitions()) {
                    propertyIndexUpdateCallback = new PropertyIndexUpdateCallback(indexPath, definition, root);
                    if (this.indexTracker != null) {
                        LuceneIndexPropertyQuery query = new LuceneIndexPropertyQuery(this.indexTracker, indexPath);
                        propertyIndexUpdateCallback.getUniquenessConstraintValidator().setSecondStore(query);
                    }
                }
                definition = new ReadOnlyBuilder(definition.getNodeState());
                asyncIndexing = false;
            }
            if (writerFactory == null) {
                COWDirectoryCleanupCallback cowDirectoryCleanupCallback = new COWDirectoryCleanupCallback();
                indexingContext.registerIndexCommitCallback((IndexCommitCallback)cowDirectoryCleanupCallback);
                writerFactory = new DefaultIndexWriterFactory(this.mountInfoProvider, this.newDirectoryFactory(blobDeletionCallback, cowDirectoryCleanupCallback), this.writerConfig);
            }
            LuceneIndexEditorContext context = new LuceneIndexEditorContext(root, definition, indexDefinition, callback, writerFactory, this.extractedTextCache, this.augmentorFactory, indexingContext, asyncIndexing);
            if (propertyIndexUpdateCallback != null) {
                callbacks.add(propertyIndexUpdateCallback);
            }
            if (this.mbean != null && this.statisticsProvider != null) {
                callbacks.add(new LuceneIndexStatsUpdateCallback(indexPath, this.mbean, this.statisticsProvider, this.asyncIndexesSizeStatsUpdate, indexingContext));
            }
            if (!callbacks.isEmpty()) {
                CompositePropertyUpdateCallback compositePropertyUpdateCallback = new CompositePropertyUpdateCallback(callbacks);
                context.setPropertyUpdateCallback(compositePropertyUpdateCallback);
            }
            return new LuceneIndexEditor(context);
        }
        return null;
    }

    IndexCopier getIndexCopier() {
        return this.indexCopier;
    }

    IndexingQueue getIndexingQueue() {
        return this.indexingQueue;
    }

    public ExtractedTextCache getExtractedTextCache() {
        return this.extractedTextCache;
    }

    public void setInMemoryDocsLimit(int inMemoryDocsLimit) {
        this.inMemoryDocsLimit = inMemoryDocsLimit;
    }

    protected DirectoryFactory newDirectoryFactory(ActiveDeletedBlobCollectorFactory.BlobDeletionCallback blobDeletionCallback, IndexCopier.COWDirectoryTracker cowDirectoryTracker) {
        return new DefaultDirectoryFactory(this.indexCopier, this.blobStore, blobDeletionCallback, cowDirectoryTracker);
    }

    private LuceneDocumentHolder getDocumentHolder(CommitContext commitContext) {
        LuceneDocumentHolder holder = (LuceneDocumentHolder)commitContext.get("luceneDocs");
        if (holder == null) {
            holder = new LuceneDocumentHolder(this.indexingQueue, this.inMemoryDocsLimit);
            commitContext.set("luceneDocs", (Object)holder);
        }
        return holder;
    }

    public void setBlobStore(@Nullable GarbageCollectableBlobStore blobStore) {
        this.blobStore = blobStore;
    }

    public void setIndexingQueue(IndexingQueue indexingQueue) {
        this.indexingQueue = indexingQueue;
        this.nrtIndexingEnabled = indexingQueue != null;
    }

    public void setWriterConfig(LuceneIndexWriterConfig writerConfig) {
        this.writerConfig = writerConfig;
    }

    GarbageCollectableBlobStore getBlobStore() {
        return this.blobStore;
    }

    private boolean nrtIndexingEnabled() {
        return this.nrtIndexingEnabled;
    }

    private static CommitContext getCommitContext(IndexingContext indexingContext) {
        return (CommitContext)indexingContext.getCommitInfo().getInfo().get("oak.commitAttributes");
    }

    private static class COWDirectoryCleanupCallback
    implements IndexCommitCallback,
    IndexCopier.COWDirectoryTracker {
        private static final Logger LOG = LoggerFactory.getLogger(COWDirectoryCleanupCallback.class);
        private List<CopyOnWriteDirectory> openedCoWDirectories = Lists.newArrayList();
        private List<File> reindexingLocalDirectories = Lists.newArrayList();

        private COWDirectoryCleanupCallback() {
        }

        public void commitProgress(IndexCommitCallback.IndexProgress indexProgress) {
            if (indexProgress == IndexCommitCallback.IndexProgress.COMMIT_FAILED) {
                for (CopyOnWriteDirectory d : this.openedCoWDirectories) {
                    try {
                        d.close();
                    }
                    catch (Exception e) {
                        LOG.warn("Error occurred while closing {}", (Object)d, (Object)e);
                    }
                }
                for (File f : this.reindexingLocalDirectories) {
                    if (FileUtils.deleteQuietly((File)f)) continue;
                    LOG.warn("Failed to delete {}", (Object)f);
                }
            }
        }

        @Override
        public void registerOpenedDirectory(@NotNull CopyOnWriteDirectory directory) {
            this.openedCoWDirectories.add(directory);
        }

        @Override
        public void registerReindexingLocalDirectory(@NotNull File dir) {
            this.reindexingLocalDirectories.add(dir);
        }
    }
}

