/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.TokenizerChain;
import org.apache.jackrabbit.oak.plugins.index.search.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NodeStateAnalyzerFactory {
    private static final AtomicBoolean versionWarningAlreadyLogged = new AtomicBoolean(false);
    private static final Set<String> IGNORE_PROP_NAMES = ImmutableSet.of((Object)"class", (Object)"name", (Object)"jcr:primaryType");
    private static final Logger log = LoggerFactory.getLogger(NodeStateAnalyzerFactory.class);
    private final ResourceLoader defaultLoader;
    private final Version defaultVersion;

    NodeStateAnalyzerFactory(Version defaultVersion) {
        this(new ClasspathResourceLoader(NodeStateAnalyzerFactory.class.getClassLoader()), defaultVersion);
    }

    NodeStateAnalyzerFactory(ResourceLoader defaultLoader, Version defaultVersion) {
        this.defaultLoader = defaultLoader;
        this.defaultVersion = defaultVersion;
    }

    public Analyzer createInstance(NodeState state) {
        if (state.hasProperty("class")) {
            return this.createAnalyzerViaReflection(state);
        }
        return this.composeAnalyzer(state);
    }

    private Analyzer composeAnalyzer(NodeState state) {
        TokenizerFactory tf = this.loadTokenizer(state.getChildNode("tokenizer"));
        CharFilterFactory[] cfs = this.loadCharFilterFactories(state.getChildNode("charFilters"));
        TokenFilterFactory[] tffs = this.loadTokenFilterFactories(state.getChildNode("filters"));
        return new TokenizerChain(cfs, tf, tffs);
    }

    private TokenFilterFactory[] loadTokenFilterFactories(NodeState tokenFiltersState) {
        ArrayList result = Lists.newArrayList();
        Tree tree = TreeFactory.createReadOnlyTree((NodeState)tokenFiltersState);
        for (Tree t : tree.getChildren()) {
            NodeState state = tokenFiltersState.getChildNode(t.getName());
            String factoryType = NodeStateAnalyzerFactory.getFactoryType(state, t.getName());
            Map<String, String> args = this.convertNodeState(state);
            TokenFilterFactory cf = TokenFilterFactory.forName(factoryType, args);
            this.init(cf, state);
            result.add(cf);
        }
        return result.toArray(new TokenFilterFactory[result.size()]);
    }

    private CharFilterFactory[] loadCharFilterFactories(NodeState charFiltersState) {
        ArrayList result = Lists.newArrayList();
        Tree tree = TreeFactory.createReadOnlyTree((NodeState)charFiltersState);
        for (Tree t : tree.getChildren()) {
            NodeState state = charFiltersState.getChildNode(t.getName());
            String factoryType = NodeStateAnalyzerFactory.getFactoryType(state, t.getName());
            Map<String, String> args = this.convertNodeState(state);
            CharFilterFactory cf = CharFilterFactory.forName(factoryType, args);
            this.init(cf, state);
            result.add(cf);
        }
        return result.toArray(new CharFilterFactory[result.size()]);
    }

    private TokenizerFactory loadTokenizer(NodeState state) {
        String clazz = (String)Preconditions.checkNotNull((Object)state.getString("name"));
        Map<String, String> args = this.convertNodeState(state);
        TokenizerFactory tf = TokenizerFactory.forName(clazz, args);
        this.init(tf, state);
        return tf;
    }

    private Analyzer createAnalyzerViaReflection(NodeState state) {
        String clazz = state.getString("class");
        Class<Analyzer> analyzerClazz = this.defaultLoader.findClass(clazz, Analyzer.class);
        Version matchVersion = this.getVersion(state);
        CharArraySet stopwords = null;
        if (StopwordAnalyzerBase.class.isAssignableFrom(analyzerClazz) && state.hasChildNode("stopwords")) {
            try {
                stopwords = NodeStateAnalyzerFactory.loadStopwordSet(state.getChildNode("stopwords"), "stopwords", matchVersion);
            }
            catch (IOException e) {
                throw new RuntimeException("Error occurred while loading stopwords", e);
            }
        }
        Constructor<Analyzer> c = null;
        try {
            if (stopwords != null) {
                c = analyzerClazz.getConstructor(Version.class, CharArraySet.class);
                return c.newInstance(new Object[]{matchVersion, stopwords});
            }
            c = analyzerClazz.getConstructor(Version.class);
            return c.newInstance(new Object[]{matchVersion});
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Error occurred while instantiating Analyzer for " + analyzerClazz, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error occurred while instantiating Analyzer for " + analyzerClazz, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error occurred while instantiating Analyzer for " + analyzerClazz, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error occurred while instantiating Analyzer for " + analyzerClazz, e);
        }
    }

    private void init(AbstractAnalysisFactory o, NodeState state) {
        if (o instanceof ResourceLoaderAware) {
            try {
                ((ResourceLoaderAware)((Object)o)).inform(new NodeStateResourceLoader(state, this.defaultLoader));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error occurred while initializing type " + o.getClass(), e);
            }
        }
        if (state.hasProperty("luceneMatchVersion")) {
            o.setExplicitLuceneMatchVersion(true);
        }
    }

    Map<String, String> convertNodeState(NodeState state) {
        HashMap result = Maps.newHashMap();
        for (PropertyState ps : state.getProperties()) {
            String name = ps.getName();
            if (ps.getType() == Type.BINARY || ps.isArray() || name != null && NodeStateUtils.isHidden((String)name) || IGNORE_PROP_NAMES.contains(name)) continue;
            result.put(name, (String)ps.getValue(Type.STRING));
        }
        result.put("luceneMatchVersion", this.getVersion(state).toString());
        return result;
    }

    private Version getVersion(NodeState state) {
        Version version = this.defaultVersion;
        if (state.hasProperty("luceneMatchVersion")) {
            version = NodeStateAnalyzerFactory.parseLuceneVersionString(state.getString("luceneMatchVersion"));
        }
        return version;
    }

    private static String getFactoryType(NodeState state, String nodeStateName) {
        String type = state.getString("name");
        return type != null ? type : nodeStateName;
    }

    private static Version parseLuceneVersionString(String matchVersion) {
        Version version = Version.parseLeniently(matchVersion);
        if (version == Version.LUCENE_CURRENT && !versionWarningAlreadyLogged.getAndSet(true)) {
            log.warn("You should not use LATEST as luceneMatchVersion property: if you use this setting, and then Solr upgrades to a newer release of Lucene, sizable changes may happen. If precise back compatibility is important then you should instead explicitly specify an actual Lucene version.");
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharArraySet loadStopwordSet(NodeState file, String name, Version matchVersion) throws IOException {
        CharArraySet charArraySet;
        Blob blob = ConfigUtil.getBlob(file, name);
        InputStreamReader stopwords = new InputStreamReader(blob.getNewStream(), IOUtils.CHARSET_UTF_8);
        try {
            charArraySet = WordlistLoader.getWordSet((Reader)stopwords, matchVersion);
        }
        catch (Throwable throwable) {
            IOUtils.close(stopwords);
            throw throwable;
        }
        IOUtils.close(stopwords);
        return charArraySet;
    }

    static class NodeStateResourceLoader
    implements ResourceLoader {
        private final NodeState state;
        private final ResourceLoader delegate;

        public NodeStateResourceLoader(NodeState state, ResourceLoader delegate) {
            this.state = state;
            this.delegate = delegate;
        }

        @Override
        public InputStream openResource(String resource) throws IOException {
            if (this.state.hasChildNode(resource)) {
                return ConfigUtil.getBlob(this.state.getChildNode(resource), resource).getNewStream();
            }
            return this.delegate.openResource(resource);
        }

        @Override
        public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
            if (CharFilterFactory.class.isAssignableFrom(expectedType)) {
                return CharFilterFactory.lookupClass(cname).asSubclass(expectedType);
            }
            if (TokenizerFactory.class.isAssignableFrom(expectedType)) {
                return TokenizerFactory.lookupClass(cname).asSubclass(expectedType);
            }
            if (TokenFilterFactory.class.isAssignableFrom(expectedType)) {
                return TokenFilterFactory.lookupClass(cname).asSubclass(expectedType);
            }
            return this.delegate.findClass(cname, expectedType);
        }

        @Override
        public <T> T newInstance(String cname, Class<T> expectedType) {
            throw new UnsupportedOperationException();
        }
    }
}

