/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexFileSystemStatistics
implements Runnable {
    private final StatisticsProvider statisticsProvider;
    private final IndexCopier indexCopier;
    private static final String LOCAL_INDEX_DIR_SIZE = "LOCAL_INDEX_DIR_SIZE";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public LuceneIndexFileSystemStatistics(StatisticsProvider statsProvider, IndexCopier indexCopier) {
        this.statisticsProvider = statsProvider;
        this.indexCopier = indexCopier;
    }

    @Override
    public void run() {
        this.calculateLocalIndexDirSize();
    }

    private void calculateLocalIndexDirSize() {
        CounterStats indexDirectorySizeStats;
        long localIndexDirSize = this.indexCopier.getLocalIndexDirSize();
        long deltaInSize = localIndexDirSize - (indexDirectorySizeStats = this.statisticsProvider.getCounterStats(LOCAL_INDEX_DIR_SIZE, StatsOptions.DEFAULT)).getCount();
        if (deltaInSize != 0L) {
            indexDirectorySizeStats.inc(deltaInSize);
            this.log.debug("index directory size stats updated; size {} delta {}", (Object)localIndexDirSize, (Object)deltaInSize);
        }
    }
}

