/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.IOException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.BlobFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakBufferedIndexFile;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakStreamingIndexFile;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.store.DataInput;
import org.jetbrains.annotations.NotNull;

public interface OakIndexFile {
    public static OakIndexFile getOakIndexFile(String name, NodeBuilder file, String dirDetails, @NotNull BlobFactory blobFactory) {
        return OakIndexFile.getOakIndexFile(name, file, dirDetails, blobFactory, false);
    }

    public static OakIndexFile getOakIndexFile(String name, NodeBuilder file, String dirDetails, @NotNull BlobFactory blobFactory, boolean streamingWriteEnabled) {
        PropertyState property = file.getProperty("jcr:data");
        boolean useStreaming = property != null ? property.getType() == Type.BINARY : streamingWriteEnabled;
        return useStreaming ? new OakStreamingIndexFile(name, file, dirDetails, blobFactory) : new OakBufferedIndexFile(name, file, dirDetails, blobFactory);
    }

    public boolean supportsCopyFromDataInput();

    public String getName();

    public long length();

    public boolean isClosed();

    public void close();

    public long position();

    public void seek(long var1) throws IOException;

    public OakIndexFile clone();

    public void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void copyBytes(DataInput var1, long var2) throws IOException;

    public void flush() throws IOException;
}

