/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.DocumentQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDoc;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDocumentHolder;
import org.apache.jackrabbit.oak.spi.commit.CommitContext;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalIndexObserver
implements Observer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DocumentQueue docQueue;

    public LocalIndexObserver(DocumentQueue docQueue, StatisticsProvider sp) {
        this.docQueue = docQueue;
    }

    public void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        if (info.isExternal()) {
            return;
        }
        CommitContext commitContext = (CommitContext)info.getInfo().get("oak.commitAttributes");
        if (commitContext == null) {
            return;
        }
        LuceneDocumentHolder holder = (LuceneDocumentHolder)commitContext.get("luceneDocs");
        if (holder == null) {
            return;
        }
        commitContext.remove("luceneDocs");
        int droppedCount = 0;
        for (LuceneDoc doc : holder.getNRTIndexedDocs()) {
            if (this.docQueue.add(doc)) continue;
            ++droppedCount;
        }
        this.docQueue.addAllSynchronously(holder.getSyncIndexedDocs());
        if (droppedCount > 0) {
            this.log.warn("Dropped [{}] docs from indexing as queue is full", (Object)droppedCount);
        }
    }
}

