/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import java.util.Locale;

public interface FulltextIndexConstants {
    public static final String INDEX_DATA_CHILD_NAME = ":data";
    public static final String INCLUDE_PROPERTY_TYPES = "includePropertyTypes";
    public static final String EXCLUDE_PROPERTY_NAMES = "excludePropertyNames";
    public static final String PERSISTENCE_NAME = "persistence";
    public static final String PERSISTENCE_OAK = "repository";
    public static final String TEST_MODE = "testMode";
    public static final String PERSISTENCE_FILE = "file";
    public static final String PERSISTENCE_PATH = "path";
    public static final String EXPERIMENTAL_STORAGE = "oak.experimental.storage";
    public static final String FULL_TEXT_ENABLED = "fulltextEnabled";
    public static final String INCLUDE_PROPERTY_NAMES = "includePropertyNames";
    public static final String PROP_TYPE = "type";
    public static final String ORDERED_PROP_NAMES = "orderedProps";
    public static final String BLOB_SIZE = "blobSize";
    public static final String FUNC_NAME = "functionName";
    public static final String PROP_NODE = "properties";
    public static final String INDEX_RULES = "indexRules";
    public static final String FIELD_BOOST = "boost";
    public static final String PROP_NAME = "name";
    public static final String PROP_IS_REGEX = "isRegexp";
    public static final String PROP_INDEX = "index";
    public static final String PROP_USE_IN_EXCERPT = "useInExcerpt";
    public static final String EXCERPT_NODE_FIELD_NAME = ".";
    public static final String PROP_NODE_SCOPE_INDEX = "nodeScopeIndex";
    public static final String PROP_PROPERTY_INDEX = "propertyIndex";
    public static final String PROP_ANALYZED = "analyzed";
    public static final String RULE_INHERITED = "inherited";
    public static final String PROP_ORDERED = "ordered";
    public static final String PROP_SCORER_PROVIDER = "scorerProviderName";
    public static final String PROP_WEIGHT = "weight";
    public static final String PROP_DYNAMIC_BOOST = "dynamicBoost";
    public static final float DYNAMIC_BOOST_WEIGHT = 1.0E-4f;
    public static final String PROP_SYNC = "sync";
    public static final String PROP_UNIQUE = "unique";
    public static final String EVALUATE_PATH_RESTRICTION = "evaluatePathRestrictions";
    public static final String PROP_VALUE_REGEX = "valueRegex";
    public static final String PROP_QUERY_FILTER_REGEX = "queryFilterRegex";
    public static final String PROP_INCLUDED_TYPE = "oak.experimental.includePropertyTypes";
    public static final String REGEX_ALL_PROPS = "^[^\\/]*$";
    public static final String AGGREGATES = "aggregates";
    public static final String AGG_PRIMARY_TYPE = "primaryType";
    public static final String AGG_PATH = "path";
    public static final String AGG_RECURSIVE_LIMIT = "reaggregateLimit";
    public static final String AGG_RELATIVE_NODE = "relativeNode";
    public static final String COST_PER_ENTRY = "costPerEntry";
    public static final String COST_PER_EXECUTION = "costPerExecution";
    public static final String TIKA = "tika";
    public static final String TIKA_CONFIG = "config.xml";
    public static final String TIKA_MAX_EXTRACT_LENGTH = "maxExtractLength";
    public static final String TIKA_MIME_TYPES = "mimeTypes";
    public static final String TIKA_MAPPED_TYPE = "mappedType";
    public static final String MAX_FIELD_LENGTH = "maxFieldLength";
    public static final String PROP_USE_IN_SUGGEST = "useInSuggest";
    public static final String SUGGESTION_CONFIG = "suggestion";
    public static final String SUGGEST_UPDATE_FREQUENCY_MINUTES = "suggestUpdateFrequencyMinutes";
    public static final String PROP_USE_IN_SPELLCHECK = "useInSpellcheck";
    public static final String PROP_USE_IN_SIMILARITY = "useInSimilarity";
    public static final String PROP_SIMILARITY_RERANK = "similarityRerank";
    public static final String PROP_SIMILARITY_TAGS = "similarityTags";
    public static final String PROP_NULL_CHECK_ENABLED = "nullCheckEnabled";
    public static final String PROP_NOT_NULL_CHECK_ENABLED = "notNullCheckEnabled";
    public static final String INDEX_NODE_NAME = "indexNodeName";
    public static final String PROPDEF_PROP_NODE_NAME = ":nodeName";
    public static final String FACETS = "facets";
    public static final String SUGGEST_ANALYZED = "suggestAnalyzed";
    public static final String COMPAT_MODE = "compatVersion";
    public static final String CODEC_NAME = "codec";
    public static final String MERGE_POLICY_NAME = "mergePolicy";
    public static final String PROP_SECURE_FACETS = "secure";
    public static final String PROP_SECURE_FACETS_VALUE_INSECURE = "insecure";
    public static final String PROP_SECURE_FACETS_VALUE_STATISTICAL = "statistical";
    public static final String PROP_SECURE_FACETS_VALUE_SECURE = "secure";
    public static final String PROP_SECURE_FACETS_VALUE_JVM_PARAM = "oak.facets.secure";
    public static final String STATISTICAL_FACET_SAMPLE_SIZE_JVM_PARAM = "oak.facet.statistical.sampleSize";
    public static final String PROP_STATISTICAL_FACET_SAMPLE_SIZE = "sampleSize";
    public static final int STATISTICAL_FACET_SAMPLE_SIZE_DEFAULT = 1000;
    public static final String PROP_SIMILARITY_SEARCH_DENSE_VECTOR_SIZE = "similaritySearchDenseVectorSize";
    public static final String PROP_FACETS_TOP_CHILDREN = "topChildren";
    public static final String PROP_FACETS = "facets";
    public static final String PROP_EXCLUDE_FROM_AGGREGATE = "excludeFromAggregation";
    public static final String PROP_FUNCTION = "function";
    public static final String PROP_REFRESH_DEFN = "refresh";
    public static final String PROP_RANDOM_SEED = "seed";
    public static final String PROP_INDEX_NODE_TYPE = "nodeTypeIndex";
    public static final String USE_IF_EXISTS = "useIfExists";
    public static final String INDEX_SIMILARITY_BINARIES = "indexSimilarityBinaries";
    public static final String INDEX_SIMILARITY_STRINGS = "indexSimilarityStrings";
    public static final String ANALYZERS = "analyzers";
    public static final String ANL_DEFAULT = "default";
    public static final String ANL_FILTERS = "filters";
    public static final String ANL_STOPWORDS = "stopwords";
    public static final String ANL_TOKENIZER = "tokenizer";
    public static final String ANL_CHAR_FILTERS = "charFilters";
    public static final String ANL_CLASS = "class";
    public static final String ANL_NAME = "name";
    public static final String INDEX_ORIGINAL_TERM = "indexOriginalTerm";

    public static enum IndexingMode {
        SYNC,
        NRT,
        ASYNC;


        public String asyncValueName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static IndexingMode from(String indexingMode) {
            return IndexingMode.valueOf(indexingMode.toUpperCase(Locale.ENGLISH));
        }
    }
}

