/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.jackrabbit.guava.common.collect.ArrayListMultimap;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.StrictPathRestriction;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePatternUtil;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.search.IndexStatistics;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.spi.query.FulltextIndex;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextVisitor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class FulltextIndexPlanner {
    public static final int DEFAULT_PROPERTY_WEIGHT = Integer.getInteger("oak.fulltext.defaultPropertyWeight", 5);
    public static final String ATTR_FACET_FIELDS = "oak.facet.fields";
    private static final String FLAG_ENTRY_COUNT = "oak.fulltext.useActualEntryCount";
    private static final Logger log = LoggerFactory.getLogger(FulltextIndexPlanner.class);
    private final IndexDefinition definition;
    private final Filter filter;
    private final String indexPath;
    protected final List<QueryIndex.OrderEntry> sortOrder;
    private final IndexNode indexNode;
    protected PlanResult result;
    protected static boolean useActualEntryCount = Boolean.parseBoolean(System.getProperty("oak.fulltext.useActualEntryCount", "true"));

    public FulltextIndexPlanner(IndexNode indexNode, String indexPath, Filter filter, List<QueryIndex.OrderEntry> sortOrder) {
        this.indexNode = indexNode;
        this.indexPath = indexPath;
        this.definition = indexNode.getDefinition();
        this.filter = filter;
        this.sortOrder = sortOrder;
    }

    public QueryIndex.IndexPlan getPlan() {
        if (this.definition == null) {
            log.debug("Index {} not loaded", (Object)this.indexPath);
            return null;
        }
        QueryIndex.IndexPlan.Builder builder = this.getPlanBuilder();
        if (this.definition.isTestMode()) {
            if (builder == null) {
                if (this.notSupportedFeature()) {
                    return null;
                }
                String msg = String.format("No plan found for filter [%s] while using definition [%s] and testMode is found to be enabled", this.filter, this.definition);
                throw new IllegalStateException(msg);
            }
            builder.setEstimatedEntryCount(1L).setCostPerExecution(0.001).setCostPerEntry(0.001);
        }
        return builder != null ? builder.build() : null;
    }

    public String toString() {
        return "IndexPlanner{indexPath='" + this.indexPath + "', filter=" + this.filter + ", sortOrder=" + this.sortOrder + "}";
    }

    public static void setUseActualEntryCount(boolean useActualEntryCount) {
        FulltextIndexPlanner.useActualEntryCount = useActualEntryCount;
    }

    private QueryIndex.IndexPlan.Builder getPlanBuilder() {
        log.trace("Evaluating plan with index definition {}", (Object)this.definition);
        if (this.wrongIndex()) {
            return null;
        }
        if (this.filter.getQueryLimits().getStrictPathRestriction().equals(StrictPathRestriction.ENABLE.name()) && !this.isPlanWithValidPathFilter()) {
            return null;
        }
        if (!this.definition.getVersion().isAtLeast(IndexFormatVersion.V2)) {
            log.trace("Index is old format. Not supported");
            return null;
        }
        FullTextExpression ft = this.filter.getFullTextConstraint();
        if (ft != null && !this.definition.isFullTextEnabled()) {
            return null;
        }
        IndexDefinition.IndexingRule indexingRule = this.getApplicableRule();
        if (indexingRule == null) {
            return null;
        }
        if (ft != null && !indexingRule.isFulltextEnabled()) {
            return null;
        }
        if (!this.checkForQueryPaths()) {
            log.trace("Opting out due mismatch between path restriction {} and query paths {}", (Object)this.filter.getPath(), (Object)this.definition.getQueryPaths());
            return null;
        }
        this.result = new PlanResult(this.indexPath, this.definition, indexingRule);
        if (this.definition.hasFunctionDefined() && this.filter.getPropertyRestriction(this.definition.getFunctionName()) != null) {
            return this.getNativeFunctionPlanBuilder(indexingRule.getBaseNodeType());
        }
        List<Object> indexedProps = Lists.newArrayListWithCapacity((int)this.filter.getPropertyRestrictions().size());
        for (PropertyDefinition functionIndex : indexingRule.getFunctionRestrictions()) {
            for (Object pr : this.filter.getPropertyRestrictions()) {
                String f = functionIndex.function;
                if (!((Filter.PropertyRestriction)pr).propertyName.equals(f)) continue;
                indexedProps.add(f);
                this.result.propDefns.put(f, functionIndex);
            }
        }
        LinkedList<String> facetFields = new LinkedList<String>();
        boolean ntBaseRule = "nt:base".equals(indexingRule.getNodeTypeName());
        HashMap<String, PropertyDefinition> relativePropDefns = new HashMap<String, PropertyDefinition>();
        if (indexingRule.propertyIndexEnabled) {
            for (Filter.PropertyRestriction pr : this.filter.getPropertyRestrictions()) {
                String name = pr.propertyName;
                if (":localname".equals(name) || name.startsWith("function*")) continue;
                if ("rep:facet".equals(pr.propertyName)) {
                    String value = (String)pr.first.getValue(Type.STRING);
                    String facetProp = FulltextIndex.parseFacetField(value);
                    PropertyDefinition facetPropDef = indexingRule.getConfig(facetProp);
                    if (facetPropDef == null || !facetPropDef.facet) {
                        log.debug("{} not backed by index. Opting out", (Object)value);
                        return null;
                    }
                    facetFields.add(facetProp);
                }
                PropertyDefinition pd = indexingRule.getConfig(pr.propertyName);
                boolean relativeProps = false;
                if (pd == null && ntBaseRule) {
                    pd = FulltextIndexPlanner.getSimpleProperty(indexingRule, pr.propertyName);
                    boolean bl = relativeProps = pd != null;
                }
                if (pd == null || !pd.propertyIndexEnabled() || pr.isNullRestriction() && !pd.nullCheckEnabled || !this.matchesValuePattern(pr, pd)) continue;
                if (pd.weight != 0 && !relativeProps) {
                    indexedProps.add(name);
                }
                if (relativeProps) {
                    relativePropDefns.put(name, pd);
                    continue;
                }
                this.result.propDefns.put(name, pd);
            }
        }
        boolean evalNodeTypeRestrictions = this.canEvalNodeTypeRestrictions(indexingRule);
        boolean evalPathRestrictions = this.canEvalPathRestrictions(indexingRule);
        boolean canEvalAlFullText = this.canEvalAllFullText(indexingRule, ft);
        boolean canEvalNodeNameRestriction = this.canEvalNodeNameRestriction(indexingRule);
        if (ft != null && !canEvalAlFullText) {
            return null;
        }
        if (indexedProps.isEmpty() && !relativePropDefns.isEmpty() && !canEvalAlFullText) {
            indexedProps = this.planForRelativeProperties(relativePropDefns);
        }
        List<QueryIndex.OrderEntry> sortOrder = this.createSortOrder(indexingRule);
        boolean canSort = FulltextIndexPlanner.canSortByProperty(sortOrder);
        if (!indexedProps.isEmpty() || canSort || ft != null || evalPathRestrictions || evalNodeTypeRestrictions || canEvalNodeNameRestriction) {
            boolean uniqueIndexFound;
            int maxPossibleNumDocs;
            Pattern queryFilterPattern;
            int costPerEntryFactor = 1;
            costPerEntryFactor += sortOrder.size();
            QueryIndex.IndexPlan.Builder plan = this.defaultPlan();
            if (plan == null) {
                return null;
            }
            if (this.filter.getQueryLimits().getStrictPathRestriction().equals(StrictPathRestriction.WARN.name()) && !this.isPlanWithValidPathFilter()) {
                plan.setLogWarningForPathFilterMismatch(true);
            }
            Pattern pattern = queryFilterPattern = this.definition.getQueryFilterRegex() != null ? this.definition.getQueryFilterRegex() : this.definition.getPropertyRegex();
            if (queryFilterPattern != null) {
                if (ft != null && !queryFilterPattern.matcher(ft.toString()).find()) {
                    plan.addAdditionalMessage(Level.WARN, "Potentially improper use of index " + this.definition.getIndexPath() + " with queryFilterRegex " + queryFilterPattern + " to search for value '" + ft + "'");
                }
                for (Filter.PropertyRestriction pr : this.filter.getPropertyRestrictions()) {
                    if (pr.propertyName.startsWith(":") || queryFilterPattern.matcher(pr.toString()).find()) continue;
                    plan.addAdditionalMessage(Level.WARN, "Potentially improper use of index " + this.definition.getIndexPath() + " with queryFilterRegex " + queryFilterPattern + " to search for value '" + pr + "'");
                }
            }
            if (!sortOrder.isEmpty()) {
                plan.setSortOrder(sortOrder);
            }
            if (facetFields.size() > 0) {
                plan.setAttribute(ATTR_FACET_FIELDS, facetFields);
            }
            if (ft == null) {
                this.result.enableNonFullTextConstraints();
            }
            if (evalNodeTypeRestrictions) {
                this.result.enableNodeTypeEvaluation();
            }
            if (canEvalNodeNameRestriction) {
                this.result.enableNodeNameRestriction();
            }
            if (useActualEntryCount && !this.definition.isEntryCountDefined() && (maxPossibleNumDocs = this.getMaxPossibleNumDocs(this.result.propDefns, this.filter)) >= 0) {
                plan.setEstimatedEntryCount((long)maxPossibleNumDocs);
            }
            if (sortOrder.isEmpty() && ft == null && (uniqueIndexFound = this.planForSyncIndexes(indexingRule))) {
                plan.setEstimatedEntryCount(1L);
            }
            return plan.setCostPerEntry(this.definition.getCostPerEntry() / (double)costPerEntryFactor);
        }
        return null;
    }

    private boolean isPlanWithValidPathFilter() {
        String pathFilter = this.filter.getPath();
        PathFilter definitionPathFilter = this.definition.getPathFilter();
        return definitionPathFilter.areAllDescendantsIncluded(pathFilter);
    }

    private boolean matchesValuePattern(Filter.PropertyRestriction pr, PropertyDefinition pd) {
        if (!pd.valuePattern.matchesAll()) {
            Set values = ValuePatternUtil.getAllValues((Filter.PropertyRestriction)pr);
            if (values == null) {
                String prefix = ValuePatternUtil.getLongestPrefix((Filter)this.filter, (String)pr.propertyName);
                return pd.valuePattern.matchesPrefix(prefix);
            }
            return pd.valuePattern.matchesAll(values);
        }
        return true;
    }

    private boolean wrongIndex() {
        Filter.PropertyRestriction indexTag;
        if (!this.definition.isEnabled()) {
            return true;
        }
        Filter.PropertyRestriction indexName = this.filter.getPropertyRestriction(":indexName");
        boolean wrong = false;
        if (indexName != null && indexName.first != null) {
            String name = (String)indexName.first.getValue(Type.STRING);
            String thisName = this.definition.getIndexName();
            if (thisName != null && (thisName = PathUtils.getName((String)thisName)).equals(name)) {
                return false;
            }
            wrong = true;
        }
        if ((indexTag = this.filter.getPropertyRestriction(":indexTag")) != null && indexTag.first != null) {
            String[] tags = this.definition.getIndexTags();
            if (tags == null) {
                return true;
            }
            String tag = (String)indexTag.first.getValue(Type.STRING);
            for (String t : tags) {
                if (!t.equals(tag)) continue;
                return false;
            }
            return true;
        }
        if ("tag".equals(this.definition.getIndexSelectionPolicy())) {
            return true;
        }
        return wrong;
    }

    private QueryIndex.IndexPlan.Builder getNativeFunctionPlanBuilder(String indexingRuleBaseNodeType) {
        boolean canHandleNativeFunction = true;
        PropertyValue pv = this.filter.getPropertyRestriction((String)this.definition.getFunctionName()).first;
        String query = (String)pv.getValue(Type.STRING);
        if (query.startsWith("suggest?term=")) {
            if (this.definition.isSuggestEnabled()) {
                canHandleNativeFunction = indexingRuleBaseNodeType.equals(this.filter.getNodeType());
                this.result.disableUniquePaths();
            } else {
                canHandleNativeFunction = false;
            }
        } else if (query.startsWith("spellcheck?term=")) {
            if (this.definition.isSpellcheckEnabled()) {
                canHandleNativeFunction = indexingRuleBaseNodeType.equals(this.filter.getNodeType());
                this.result.disableUniquePaths();
            } else {
                canHandleNativeFunction = false;
            }
        }
        if (!canHandleNativeFunction) {
            return null;
        }
        QueryIndex.IndexPlan.Builder b = this.defaultPlan();
        if (b == null) {
            return null;
        }
        return b.setEstimatedEntryCount(1L);
    }

    private boolean checkForQueryPaths() {
        String[] queryPaths = this.definition.getQueryPaths();
        if (queryPaths == null) {
            return true;
        }
        String pathRestriction = this.filter.getPath();
        for (String queryPath : queryPaths) {
            if (!queryPath.equals(pathRestriction) && !PathUtils.isAncestor((String)queryPath, (String)pathRestriction)) continue;
            return true;
        }
        return false;
    }

    private boolean canEvalNodeNameRestriction(IndexDefinition.IndexingRule indexingRule) {
        Filter.PropertyRestriction pr = this.filter.getPropertyRestriction(":localname");
        if (pr == null) {
            return false;
        }
        return indexingRule.isNodeNameIndexed();
    }

    private static boolean canSortByProperty(List<QueryIndex.OrderEntry> sortOrder) {
        if (sortOrder.isEmpty()) {
            return false;
        }
        return sortOrder.size() != 1 || !"jcr:score".equals(sortOrder.get(0).getPropertyName());
    }

    private boolean canEvalAllFullText(final IndexDefinition.IndexingRule indexingRule, FullTextExpression ft) {
        if (ft == null) {
            return false;
        }
        final HashSet relPaths = new HashSet();
        final HashSet nonIndexedPaths = new HashSet();
        final AtomicBoolean relativeParentsFound = new AtomicBoolean();
        final AtomicBoolean nodeScopedCondition = new AtomicBoolean();
        ft.accept((FullTextVisitor)new FullTextVisitor.FullTextVisitorBase(){

            public boolean visit(FullTextContains contains) {
                this.visitTerm(contains.getPropertyName());
                return true;
            }

            public boolean visit(FullTextTerm term) {
                this.visitTerm(term.getPropertyName());
                return true;
            }

            private void visitTerm(String propertyName) {
                String p = propertyName;
                String propertyPath = null;
                String nodePath = null;
                if (p == null) {
                    relPaths.add("");
                } else if (p.startsWith("../") || p.startsWith("./")) {
                    relPaths.add(p);
                    relativeParentsFound.set(true);
                } else if (PathUtils.getDepth((String)p) > 1) {
                    String parent = PathUtils.getParentPath((String)p);
                    if (FulltextIndex.isNodePath(p)) {
                        nodePath = parent;
                    } else {
                        propertyPath = p;
                    }
                    relPaths.add(parent);
                } else {
                    propertyPath = p;
                    relPaths.add("");
                }
                if (nodePath != null && !indexingRule.isAggregated(nodePath)) {
                    nonIndexedPaths.add(p);
                } else if (propertyPath != null) {
                    PropertyDefinition pd = indexingRule.getConfig(propertyPath);
                    if (pd == null) {
                        nonIndexedPaths.add(p);
                    } else if (!pd.analyzed) {
                        nonIndexedPaths.add(p);
                    }
                }
                if (FulltextIndexPlanner.nodeScopedTerm(propertyName)) {
                    nodeScopedCondition.set(true);
                }
            }
        });
        if (nodeScopedCondition.get() && !indexingRule.isNodeFullTextIndexed()) {
            return false;
        }
        if (relativeParentsFound.get()) {
            log.debug("Relative parents found {} which are not supported", relPaths);
            return false;
        }
        if (!nonIndexedPaths.isEmpty()) {
            if (relPaths.size() > 1) {
                log.debug("Following relative property paths are not index: {}", relPaths);
                return false;
            }
            this.result.setParentPath((String)Iterables.getOnlyElement(relPaths, (Object)""));
            IndexDefinition.IndexingRule rule = this.definition.getApplicableIndexingRule("nt:base");
            if (rule == null) {
                return false;
            }
            for (String p : nonIndexedPaths) {
                if (FulltextIndex.isNodePath(p)) {
                    if (rule.isNodeFullTextIndexed()) continue;
                    return false;
                }
                String propertyName = PathUtils.getName((String)p);
                PropertyDefinition pd = rule.getConfig(propertyName);
                if (pd == null) {
                    return false;
                }
                if (pd.analyzed) continue;
                return false;
            }
        } else {
            this.result.setParentPath("");
        }
        return true;
    }

    private List<String> planForRelativeProperties(Map<String, PropertyDefinition> relativePropDefns) {
        ArrayListMultimap relpaths = ArrayListMultimap.create();
        int maxSize = 0;
        String maxCountedParent = null;
        for (Map.Entry<String, PropertyDefinition> e : relativePropDefns.entrySet()) {
            String relativePropertyPath = e.getKey();
            String parent = PathUtils.getParentPath((String)relativePropertyPath);
            relpaths.put((Object)parent, e);
            int count = relpaths.get((Object)parent).size();
            if (count <= maxSize) continue;
            maxSize = count;
            maxCountedParent = parent;
        }
        this.result.setParentPath(maxCountedParent);
        ArrayList<String> indexedProps = new ArrayList<String>(maxSize);
        for (Map.Entry e : relpaths.get(maxCountedParent)) {
            String relativePropertyPath = (String)e.getKey();
            this.result.propDefns.put(relativePropertyPath, (PropertyDefinition)e.getValue());
            this.result.relPropMapping.put(relativePropertyPath, PathUtils.getName((String)relativePropertyPath));
            if (((PropertyDefinition)e.getValue()).weight == 0) continue;
            indexedProps.add(relativePropertyPath);
        }
        return indexedProps;
    }

    @Nullable
    private static PropertyDefinition getSimpleProperty(IndexDefinition.IndexingRule indexingRule, String relativePropertyName) {
        String name = PathUtils.getName((String)relativePropertyName);
        if (name.equals(relativePropertyName)) {
            return null;
        }
        if (relativePropertyName.startsWith("../") || relativePropertyName.startsWith("./")) {
            return null;
        }
        return indexingRule.getConfig(name);
    }

    private boolean planForSyncIndexes(IndexDefinition.IndexingRule indexingRule) {
        PropertyDefinition pd;
        if (!this.definition.hasSyncPropertyDefinitions()) {
            return false;
        }
        if (this.result.propDefns.isEmpty() && !this.result.evaluateNodeTypeRestriction()) {
            return false;
        }
        ArrayList unique = Lists.newArrayList();
        ArrayList nonUnique = Lists.newArrayList();
        for (Filter.PropertyRestriction pr : this.filter.getPropertyRestrictions()) {
            String propertyName = this.result.getPropertyName(pr);
            PropertyDefinition pd2 = this.result.propDefns.get(pr.propertyName);
            if (pd2 == null) continue;
            PropertyIndexResult e = new PropertyIndexResult(propertyName, pr);
            if (pd2.unique) {
                unique.add(e);
                continue;
            }
            nonUnique.add(e);
        }
        boolean uniqueIndexFound = false;
        if (!unique.isEmpty()) {
            this.result.propertyIndexResult = (PropertyIndexResult)unique.get(0);
            uniqueIndexFound = true;
        } else if (!nonUnique.isEmpty()) {
            this.result.propertyIndexResult = (PropertyIndexResult)nonUnique.get(0);
        }
        if (this.result.propertyIndexResult == null && this.result.evaluateNodeTypeRestriction() && (pd = indexingRule.getConfig("jcr:primaryType")) != null && pd.sync) {
            this.result.syncNodeTypeRestrictions = true;
        }
        return uniqueIndexFound;
    }

    private boolean canEvalPathRestrictions(IndexDefinition.IndexingRule rule) {
        if (this.filter.getPathRestriction() == Filter.PathRestriction.NO_RESTRICTION || this.filter.getPathRestriction() == Filter.PathRestriction.ALL_CHILDREN && PathUtils.denotesRoot((String)this.filter.getPath())) {
            return false;
        }
        return this.definition.evaluatePathRestrictions() && rule.indexesAllNodesOfMatchingType();
    }

    private boolean canEvalNodeTypeRestrictions(IndexDefinition.IndexingRule rule) {
        if (this.filter.matchesAllTypes()) {
            return false;
        }
        return rule.indexesAllNodesOfMatchingType() && !rule.isBasedOnNtBase();
    }

    @Nullable
    private QueryIndex.IndexPlan.Builder defaultPlan() {
        if (this.indexNode.getIndexStatistics() == null) {
            return null;
        }
        return new QueryIndex.IndexPlan.Builder().setCostPerExecution(this.definition.getCostPerExecution()).setCostPerEntry(this.definition.getCostPerEntry()).setFulltextIndex(this.definition.isFullTextEnabled()).setIncludesNodeData(false).setFilter(this.filter).setPathPrefix(this.getPathPrefix()).setSupportsPathRestriction(this.definition.evaluatePathRestrictions()).setDelayed(true).setDeprecated(this.definition.isDeprecated()).setAttribute("oak.fulltext.planResult", (Object)this.result).setEstimatedEntryCount(this.estimatedEntryCount()).setPlanName(this.indexPath);
    }

    private long estimatedEntryCount() {
        if (useActualEntryCount) {
            if (this.definition.isEntryCountDefined()) {
                return this.definition.getEntryCount();
            }
            return this.getNumDocs();
        }
        return this.estimatedEntryCount_Compat(this.getNumDocs());
    }

    private long estimatedEntryCount_Compat(int numOfDocs) {
        FullTextExpression ft = this.filter.getFullTextConstraint();
        if (ft != null && this.definition.isFullTextEnabled()) {
            return this.definition.getFulltextEntryCount(numOfDocs);
        }
        return Math.min(this.definition.getEntryCount(), (long)numOfDocs);
    }

    private String getPathPrefix() {
        String parentPath = PathUtils.getAncestorPath((String)this.indexPath, (int)2);
        return PathUtils.denotesRoot((String)parentPath) ? "" : parentPath;
    }

    private int getNumDocs() {
        IndexStatistics indexStatistics = this.indexNode.getIndexStatistics();
        if (indexStatistics == null) {
            log.warn("Statistics not available - possibly index is corrupt? Returning high doc count");
            return Integer.MAX_VALUE;
        }
        return indexStatistics.numDocs();
    }

    private int getMaxPossibleNumDocs(Map<String, PropertyDefinition> propDefns, Filter filter) {
        IndexStatistics indexStatistics = this.indexNode.getIndexStatistics();
        if (indexStatistics == null) {
            log.warn("Statistics not available - possibly index is corrupt? Returning high doc count");
            return Integer.MAX_VALUE;
        }
        int minNumDocs = indexStatistics.numDocs();
        for (Map.Entry<String, PropertyDefinition> propDef : propDefns.entrySet()) {
            int docCntForField;
            String key = propDef.getKey();
            if (this.result.relPropMapping.containsKey(key)) {
                key = PathUtils.getName((String)key);
            }
            if ((docCntForField = indexStatistics.getDocCountFor(key)) == -1) continue;
            int weight = propDef.getValue().weight;
            Filter.PropertyRestriction pr = filter.getPropertyRestriction(key);
            if (pr != null) {
                if (pr.isNotNullRestriction()) {
                    weight = 1;
                } else if (weight > 1 && !FulltextIndexPlanner.isEqualityRestriction(pr)) {
                    weight = Math.min(3, weight);
                }
            }
            if (weight > 1) {
                double scaledDocCnt = Math.ceil((double)docCntForField / (double)weight);
                if ((double)minNumDocs < scaledDocCnt) continue;
                minNumDocs = (int)scaledDocCnt;
                continue;
            }
            if (docCntForField >= minNumDocs) continue;
            minNumDocs = docCntForField;
        }
        if (this.definition.evaluatePathRestrictions()) {
            Filter.PathRestriction pathRestriction = filter.getPathRestriction();
            if (pathRestriction == Filter.PathRestriction.EXACT || pathRestriction == Filter.PathRestriction.PARENT) {
                minNumDocs = 1;
            } else if (pathRestriction == Filter.PathRestriction.DIRECT_CHILDREN) {
                minNumDocs /= 2;
            } else if (pathRestriction != Filter.PathRestriction.NO_RESTRICTION) {
                minNumDocs = (int)((double)minNumDocs * 0.9);
            }
        }
        return minNumDocs;
    }

    private static boolean isEqualityRestriction(Filter.PropertyRestriction pr) {
        return pr.first != null && pr.first == pr.last;
    }

    protected List<QueryIndex.OrderEntry> createSortOrder(IndexDefinition.IndexingRule rule) {
        if (this.sortOrder == null) {
            return Collections.emptyList();
        }
        ArrayList orderEntries = Lists.newArrayListWithCapacity((int)this.sortOrder.size());
        for (QueryIndex.OrderEntry o : this.sortOrder) {
            PropertyDefinition pd = rule.getConfig(o.getPropertyName());
            if (pd != null && pd.ordered && o.getPropertyType() != null && !o.getPropertyType().isArray()) {
                orderEntries.add(o);
                this.result.sortedProperties.add(pd);
            } else if (o.getPropertyName().equals(IndexDefinition.NATIVE_SORT_ORDER.getPropertyName())) {
                orderEntries.add(IndexDefinition.NATIVE_SORT_ORDER);
            }
            for (PropertyDefinition functionIndex : rule.getFunctionRestrictions()) {
                if (!functionIndex.ordered || !o.getPropertyName().equals(functionIndex.function)) continue;
                orderEntries.add(o);
                this.result.sortedProperties.add(functionIndex);
            }
        }
        return orderEntries;
    }

    @Nullable
    private IndexDefinition.IndexingRule getApplicableRule() {
        if (this.filter.matchesAllTypes()) {
            return this.definition.getApplicableIndexingRule("nt:base");
        }
        for (IndexDefinition.IndexingRule rule : this.definition.getDefinedRules()) {
            if (this.filter.getSupertypes().contains(rule.getNodeTypeName())) {
                IndexDefinition.IndexingRule matchingRule = this.definition.getApplicableIndexingRule(rule.getNodeTypeName());
                if (matchingRule == null && rule.getNodeTypeName().equals(this.filter.getNodeType())) {
                    matchingRule = rule;
                }
                if (matchingRule != null) {
                    log.debug("Applicable IndexingRule found {}", (Object)matchingRule);
                    return rule;
                }
            }
            if (!rule.getNodeTypeName().equals("nt:base")) continue;
            return rule;
        }
        log.trace("No applicable IndexingRule found for any of the superTypes {}", (Object)this.filter.getSupertypes());
        return null;
    }

    private boolean notSupportedFeature() {
        if (this.filter.getPathRestriction() == Filter.PathRestriction.NO_RESTRICTION && this.filter.matchesAllTypes() && this.filter.getPropertyRestrictions().isEmpty()) {
            return true;
        }
        boolean failTestOnMissingFunctionIndex = true;
        if (failTestOnMissingFunctionIndex) {
            return false;
        }
        for (Filter.PropertyRestriction r : this.filter.getPropertyRestrictions()) {
            if (r.propertyName.startsWith("function*")) continue;
            return false;
        }
        return true;
    }

    private static boolean nodeScopedTerm(String propertyName) {
        return propertyName == null || ".".equals(propertyName) || "*".equals(propertyName);
    }

    static {
        if (!useActualEntryCount) {
            log.info("System property {} found to be false. IndexPlanner would use a default entryCount of 1000 instead of using the actual entry count", (Object)FLAG_ENTRY_COUNT);
        }
    }

    public static class PropertyIndexResult {
        public final String propertyName;
        public final Filter.PropertyRestriction pr;

        public PropertyIndexResult(String propertyName, Filter.PropertyRestriction pr) {
            this.propertyName = propertyName;
            this.pr = pr;
        }
    }

    public static class PlanResult {
        public final String indexPath;
        public final IndexDefinition indexDefinition;
        public final IndexDefinition.IndexingRule indexingRule;
        private final List<PropertyDefinition> sortedProperties = Lists.newArrayList();
        private final Map<String, PropertyDefinition> propDefns = Maps.newHashMap();
        private final Map<String, String> relPropMapping = Maps.newHashMap();
        private boolean nonFullTextConstraints;
        private int parentDepth;
        private String parentPathSegment;
        private boolean relativize;
        private boolean nodeTypeRestrictions;
        private boolean nodeNameRestriction;
        private boolean uniquePathsRequired = true;
        private PropertyIndexResult propertyIndexResult;
        private boolean syncNodeTypeRestrictions;

        public PlanResult(String indexPath, IndexDefinition defn, IndexDefinition.IndexingRule indexingRule) {
            this.indexPath = indexPath;
            this.indexDefinition = defn;
            this.indexingRule = indexingRule;
        }

        public PropertyDefinition getPropDefn(Filter.PropertyRestriction pr) {
            return this.propDefns.get(pr.propertyName);
        }

        public String getPropertyName(Filter.PropertyRestriction pr) {
            return this.relPropMapping.getOrDefault(pr.propertyName, pr.propertyName);
        }

        public boolean hasProperty(String propName) {
            return this.propDefns.containsKey(propName);
        }

        public PropertyDefinition getOrderedProperty(int index) {
            return this.sortedProperties.get(index);
        }

        public boolean isPathTransformed() {
            return this.relativize;
        }

        public int getParentDepth() {
            return this.parentDepth;
        }

        public String getParentPathSegment() {
            return this.parentPathSegment;
        }

        public boolean isUniquePathsRequired() {
            return this.uniquePathsRequired;
        }

        @Nullable
        public String transformPath(String path) {
            if (this.isPathTransformed()) {
                if (!this.nonFullTextConstraints && !path.endsWith(this.parentPathSegment) || this.nonFullTextConstraints && PathUtils.getDepth((String)path) < this.parentDepth) {
                    return null;
                }
                return PathUtils.getAncestorPath((String)path, (int)this.parentDepth);
            }
            return path;
        }

        public boolean evaluateNonFullTextConstraints() {
            return this.nonFullTextConstraints;
        }

        public boolean evaluateNodeTypeRestriction() {
            return this.nodeTypeRestrictions;
        }

        public boolean evaluateSyncNodeTypeRestriction() {
            return this.syncNodeTypeRestrictions;
        }

        public boolean evaluateNodeNameRestriction() {
            return this.nodeNameRestriction;
        }

        @Nullable
        public PropertyIndexResult getPropertyIndexResult() {
            return this.propertyIndexResult;
        }

        public boolean hasPropertyIndexResult() {
            return this.propertyIndexResult != null;
        }

        private void setParentPath(String relativePath) {
            this.parentPathSegment = "/" + relativePath;
            if (relativePath.isEmpty()) {
                this.enableNonFullTextConstraints();
            } else {
                this.relativize = true;
                this.parentDepth = PathUtils.getDepth((String)relativePath);
            }
        }

        private void enableNonFullTextConstraints() {
            this.nonFullTextConstraints = true;
        }

        private void enableNodeTypeEvaluation() {
            this.nodeTypeRestrictions = true;
        }

        private void enableNodeNameRestriction() {
            this.nodeNameRestriction = true;
        }

        private void disableUniquePaths() {
            this.uniquePathsRequired = false;
        }
    }
}

