/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.concurrent.NotifyingFutureTask;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexCopierClosedException;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LocalIndexFile;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyOnWriteDirectory
extends FilterDirectory {
    private static final Logger log = LoggerFactory.getLogger(CopyOnWriteDirectory.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(log.getName() + ".perf")));
    private final IndexCopier indexCopier;
    private final Callable<Void> STOP = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            return null;
        }
    };
    private final Directory remote;
    private final Directory local;
    private final Executor executor;
    private final ConcurrentMap<String, COWFileReference> fileMap = Maps.newConcurrentMap();
    private final Set<String> deletedFilesLocal = Sets.newConcurrentHashSet();
    private final Set<String> skippedFiles = Sets.newConcurrentHashSet();
    private final BlockingQueue<Callable<Void>> queue = new LinkedBlockingQueue<Callable<Void>>();
    private final AtomicReference<Throwable> errorInCopy = new AtomicReference();
    private final CountDownLatch copyDone = new CountDownLatch(1);
    private final boolean reindexMode;
    private final String indexPath;
    private boolean closed;
    private volatile NotifyingFutureTask currentTask = NotifyingFutureTask.completed();
    private final Runnable completionHandler = new Runnable(){
        Callable<Void> task = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Callable task = (Callable)CopyOnWriteDirectory.this.queue.poll();
                    if (task != null && task != CopyOnWriteDirectory.this.STOP) {
                        if (CopyOnWriteDirectory.this.errorInCopy.get() != null) {
                            log.trace("[COW][{}] Skipping task {} as some exception occurred in previous run", (Object)CopyOnWriteDirectory.this.indexPath, (Object)task);
                        } else {
                            task.call();
                        }
                        CopyOnWriteDirectory.this.currentTask.onComplete(CopyOnWriteDirectory.this.completionHandler);
                    }
                    if (task == CopyOnWriteDirectory.this.STOP) {
                        CopyOnWriteDirectory.this.copyDone.countDown();
                    }
                }
                catch (Throwable t) {
                    CopyOnWriteDirectory.this.errorInCopy.set(t);
                    log.debug("[COW][{}] Error occurred while copying files. Further processing would be skipped", (Object)CopyOnWriteDirectory.this.indexPath, (Object)t);
                    CopyOnWriteDirectory.this.currentTask.onComplete(CopyOnWriteDirectory.this.completionHandler);
                }
                return null;
            }
        };

        @Override
        public void run() {
            CopyOnWriteDirectory.this.currentTask = new NotifyingFutureTask(this.task);
            try {
                CopyOnWriteDirectory.this.executor.execute((Runnable)CopyOnWriteDirectory.this.currentTask);
            }
            catch (RejectedExecutionException e) {
                CopyOnWriteDirectory.this.checkIfClosed(false);
                throw e;
            }
        }
    };

    public CopyOnWriteDirectory(IndexCopier indexCopier, Directory remote, Directory local, boolean reindexMode, String indexPath, Executor executor) throws IOException {
        super(local);
        this.indexCopier = indexCopier;
        this.remote = remote;
        this.local = local;
        this.executor = executor;
        this.indexPath = indexPath;
        this.reindexMode = reindexMode;
        this.initialize();
    }

    @Override
    public String[] listAll() throws IOException {
        return (String[])Iterables.toArray(this.fileMap.keySet(), String.class);
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        return this.fileMap.containsKey(name);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        log.trace("[COW][{}] Deleted file {}", (Object)this.indexPath, (Object)name);
        COWFileReference ref = (COWFileReference)this.fileMap.remove(name);
        if (ref != null) {
            ref.delete();
        }
    }

    @Override
    public long fileLength(String name) throws IOException {
        COWFileReference ref = (COWFileReference)this.fileMap.get(name);
        if (ref == null) {
            throw new FileNotFoundException(name);
        }
        return ref.fileLength();
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        COWFileReference ref = (COWFileReference)this.fileMap.remove(name);
        if (ref != null) {
            ref.delete();
        }
        ref = new COWLocalFileReference(name);
        this.fileMap.put(name, ref);
        return ref.createOutput(context);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        for (String name : names) {
            COWFileReference file = (COWFileReference)this.fileMap.get(name);
            if (file == null) continue;
            file.sync();
        }
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        COWFileReference ref = (COWFileReference)this.fileMap.get(name);
        if (ref == null) {
            throw new FileNotFoundException(name);
        }
        return ref.openInput(context);
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        int pendingCopies = this.queue.size();
        this.addTask(this.STOP);
        try {
            long start = PERF_LOGGER.start();
            while (!this.copyDone.await(10L, TimeUnit.SECONDS)) {
                if (!this.indexCopier.isClosed()) continue;
                throw new IndexCopierClosedException("IndexCopier found to be closed while processing copy task for" + this.remote.toString());
            }
            PERF_LOGGER.end(start, -1L, "[COW][{}] Completed pending copying task {}", (Object)this.indexPath, (Object)pendingCopies);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        Throwable t = this.errorInCopy.get();
        if (t != null) {
            throw new IOException("Error occurred while copying files for " + this.indexPath, t);
        }
        Preconditions.checkArgument((boolean)this.queue.isEmpty(), (String)"Copy queue still has pending task left [%d]. %s", (int)this.queue.size(), this.queue);
        long skippedFilesSize = this.getSkippedFilesSize();
        for (String fileName : this.deletedFilesLocal) {
            this.deleteLocalFile(fileName);
        }
        this.indexCopier.skippedUpload(skippedFilesSize);
        String msg = "[COW][{}] CopyOnWrite stats : Skipped copying {} files with total size {}";
        if (this.reindexMode && skippedFilesSize > 0L || skippedFilesSize > 0xA00000L) {
            log.info(msg, new Object[]{this.indexPath, this.skippedFiles.size(), IOUtils.humanReadableByteCount((long)skippedFilesSize)});
        } else {
            log.debug(msg, new Object[]{this.indexPath, this.skippedFiles.size(), IOUtils.humanReadableByteCount((long)skippedFilesSize)});
        }
        if (log.isTraceEnabled()) {
            log.trace("[COW][{}] File listing - Upon completion {}", (Object)this.indexPath, (Object)Arrays.toString(this.remote.listAll()));
        }
        this.local.close();
        this.remote.close();
        this.closed = true;
    }

    @Override
    public String toString() {
        return String.format("[COW][%s] Local %s, Remote %s", this.indexPath, this.local, this.remote);
    }

    private long getSkippedFilesSize() {
        long size = 0L;
        for (String name : this.skippedFiles) {
            try {
                if (!this.local.fileExists(name)) continue;
                size += this.local.fileLength(name);
            }
            catch (Exception exception) {}
        }
        return size;
    }

    private void deleteLocalFile(String fileName) {
        this.indexCopier.deleteFile(this.local, fileName, false);
    }

    private void initialize() throws IOException {
        for (String name : this.remote.listAll()) {
            this.fileMap.put(name, new COWRemoteFileReference(name));
        }
        if (log.isTraceEnabled()) {
            log.trace("[COW][{}] File listing - At start {}", (Object)this.indexPath, (Object)Arrays.toString(this.remote.listAll()));
        }
    }

    private void addCopyTask(final String name) {
        this.indexCopier.scheduledForCopy();
        this.addTask(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CopyOnWriteDirectory.this.indexCopier.copyDone();
                if (CopyOnWriteDirectory.this.deletedFilesLocal.contains(name)) {
                    CopyOnWriteDirectory.this.skippedFiles.add(name);
                    log.trace("[COW][{}] Skip copying of deleted file {}", (Object)CopyOnWriteDirectory.this.indexPath, (Object)name);
                    return null;
                }
                long fileSize = CopyOnWriteDirectory.this.local.fileLength(name);
                LocalIndexFile file = new LocalIndexFile(CopyOnWriteDirectory.this.local, name, fileSize, false);
                long perfStart = PERF_LOGGER.start();
                long start = CopyOnWriteDirectory.this.indexCopier.startCopy(file);
                CopyOnWriteDirectory.this.local.copy(CopyOnWriteDirectory.this.remote, name, name, IOContext.DEFAULT);
                CopyOnWriteDirectory.this.indexCopier.doneCopy(file, start);
                PERF_LOGGER.end(perfStart, 0L, "[COW][{}] Copied to remote {} -- size: {}", new Object[]{CopyOnWriteDirectory.this.indexPath, name, IOUtils.humanReadableByteCount((long)fileSize)});
                return null;
            }

            public String toString() {
                return "Copy: " + name;
            }
        });
    }

    private void addDeleteTask(final String name) {
        this.addTask(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!CopyOnWriteDirectory.this.skippedFiles.contains(name)) {
                    log.trace("[COW][{}] Marking as deleted {}", (Object)CopyOnWriteDirectory.this.indexPath, (Object)name);
                    CopyOnWriteDirectory.this.remote.deleteFile(name);
                }
                return null;
            }

            public String toString() {
                return "Delete : " + name;
            }
        });
    }

    private void addTask(Callable<Void> task) {
        this.checkIfClosed(true);
        this.queue.add(task);
        this.currentTask.onComplete(this.completionHandler);
    }

    private void checkIfClosed(boolean throwException) {
        if (this.indexCopier.isClosed()) {
            IndexCopierClosedException e = new IndexCopierClosedException("IndexCopier found to be closed while processing" + this.remote.toString());
            this.errorInCopy.set(e);
            this.copyDone.countDown();
            if (throwException) {
                throw e;
            }
        }
    }

    private class COWLocalFileReference
    extends COWFileReference {
        public COWLocalFileReference(String name) {
            super(name);
        }

        @Override
        public long fileLength() throws IOException {
            return CopyOnWriteDirectory.this.local.fileLength(this.name);
        }

        @Override
        public IndexInput openInput(IOContext context) throws IOException {
            return CopyOnWriteDirectory.this.local.openInput(this.name, context);
        }

        @Override
        public IndexOutput createOutput(IOContext context) throws IOException {
            log.debug("[COW][{}] Creating output {}", (Object)CopyOnWriteDirectory.this.indexPath, (Object)this.name);
            return new CopyOnCloseIndexOutput(CopyOnWriteDirectory.this.local.createOutput(this.name, context));
        }

        @Override
        public void delete() throws IOException {
            CopyOnWriteDirectory.this.addDeleteTask(this.name);
            CopyOnWriteDirectory.this.deletedFilesLocal.add(this.name);
        }

        @Override
        public void sync() throws IOException {
            CopyOnWriteDirectory.this.local.sync(Collections.singleton(this.name));
        }

        private class CopyOnCloseIndexOutput
        extends IndexOutput {
            private final IndexOutput delegate;

            public CopyOnCloseIndexOutput(IndexOutput delegate) {
                this.delegate = delegate;
            }

            @Override
            public void flush() throws IOException {
                this.delegate.flush();
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
                CopyOnWriteDirectory.this.addCopyTask(COWLocalFileReference.this.name);
            }

            @Override
            public long getFilePointer() {
                return this.delegate.getFilePointer();
            }

            @Override
            public void seek(long pos) throws IOException {
                this.delegate.seek(pos);
            }

            @Override
            public long length() throws IOException {
                return this.delegate.length();
            }

            @Override
            public void writeByte(byte b) throws IOException {
                this.delegate.writeByte(b);
            }

            @Override
            public void writeBytes(byte[] b, int offset, int length) throws IOException {
                this.delegate.writeBytes(b, offset, length);
            }

            @Override
            public void setLength(long length) throws IOException {
                this.delegate.setLength(length);
            }
        }
    }

    private class COWRemoteFileReference
    extends COWFileReference {
        private final long length;

        public COWRemoteFileReference(String name) throws IOException {
            super(name);
            this.length = CopyOnWriteDirectory.this.remote.fileLength(name);
        }

        @Override
        public long fileLength() throws IOException {
            return this.length;
        }

        @Override
        public IndexInput openInput(IOContext context) throws IOException {
            if (this.checkIfLocalValid() && !IndexCopier.REMOTE_ONLY.contains(this.name)) {
                CopyOnWriteDirectory.this.indexCopier.readFromLocal(false);
                return CopyOnWriteDirectory.this.local.openInput(this.name, context);
            }
            CopyOnWriteDirectory.this.indexCopier.readFromRemote(false);
            return CopyOnWriteDirectory.this.remote.openInput(this.name, context);
        }

        @Override
        public IndexOutput createOutput(IOContext context) throws IOException {
            throw new UnsupportedOperationException("Cannot create output for existing remote file " + this.name);
        }

        @Override
        public void delete() throws IOException {
            CopyOnWriteDirectory.this.addDeleteTask(this.name);
        }

        private boolean checkIfLocalValid() throws IOException {
            boolean validLocalCopyPresent = CopyOnWriteDirectory.this.local.fileExists(this.name);
            if (validLocalCopyPresent) {
                long remoteFileLength;
                long localFileLength = CopyOnWriteDirectory.this.local.fileLength(this.name);
                boolean bl = validLocalCopyPresent = localFileLength == (remoteFileLength = CopyOnWriteDirectory.this.remote.fileLength(this.name));
                if (!validLocalCopyPresent) {
                    log.warn("COWRemoteFileReference::file ({}) differs in length. local: {}; remote: {}, init-remote-length", new Object[]{this.name, localFileLength, remoteFileLength});
                }
            } else if (!IndexCopier.REMOTE_ONLY.contains(this.name)) {
                log.warn("COWRemoteFileReference::local file ({}) doesn't exist", (Object)this.name);
            }
            return validLocalCopyPresent;
        }
    }

    private abstract class COWFileReference {
        protected final String name;

        public COWFileReference(String name) {
            this.name = name;
        }

        public abstract long fileLength() throws IOException;

        public abstract IndexInput openInput(IOContext var1) throws IOException;

        public abstract IndexOutput createOutput(IOContext var1) throws IOException;

        public abstract void delete() throws IOException;

        public void sync() throws IOException {
        }
    }
}

