/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.guava.common.base.Joiner;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ArrayListMultimap;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.hash.Hashing;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexMeta;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LocalIndexDir;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRootDirectory {
    static final int MAX_NAME_LENGTH = 127;
    public static final String INDEX_METADATA_FILE_NAME = "index-details.txt";
    private static final FileFilter LOCAL_DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            File metaFile = new File(file, IndexRootDirectory.INDEX_METADATA_FILE_NAME);
            return metaFile.exists();
        }
    };
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File indexRootDir;

    public IndexRootDirectory(File indexRootDir) throws IOException {
        this(indexRootDir, true);
    }

    public IndexRootDirectory(File indexRootDir, boolean gcOnStart) throws IOException {
        this.indexRootDir = indexRootDir;
        if (gcOnStart) {
            this.gcIndexDirs();
        }
    }

    public long getSize() {
        return FileUtils.sizeOfDirectory((File)this.indexRootDir);
    }

    public File getIndexDir(IndexDefinition definition, String indexPath, String dirName) throws IOException {
        File indexFolder;
        String uid = definition.getUniqueId();
        if (uid == null) {
            String version;
            File baseFolder = this.getOldFormatDir(indexPath);
            File indexDir = new File(baseFolder, version = String.valueOf(definition.getReindexCount()));
            if (!indexDir.exists()) {
                Preconditions.checkState((boolean)indexDir.mkdirs(), (String)"Not able to create folder [%s]", (Object)indexDir);
            }
            return indexDir;
        }
        String fileSystemSafeName = IndexRootDirectory.getIndexFolderBaseName(indexPath);
        String folderName = fileSystemSafeName + "-" + uid;
        File baseFolder = new File(this.indexRootDir, folderName);
        if (!baseFolder.exists()) {
            Preconditions.checkState((boolean)baseFolder.mkdir(), (String)"Not able to create folder [%s]", (Object)baseFolder);
            File readMe = new File(baseFolder, INDEX_METADATA_FILE_NAME);
            IndexMeta meta = new IndexMeta(indexPath, IndexRootDirectory.getTime());
            meta.writeTo(readMe);
        }
        if (!(indexFolder = new File(baseFolder, IndexRootDirectory.getFSSafeName(dirName))).exists()) {
            Preconditions.checkState((boolean)indexFolder.mkdir(), (String)"Not able to create folder [%s]", (Object)indexFolder);
        }
        return indexFolder;
    }

    public List<LocalIndexDir> getAllLocalIndexes() throws IOException {
        Map<String, List<LocalIndexDir>> mapping = this.getIndexesPerPath();
        ArrayList<LocalIndexDir> result = new ArrayList<LocalIndexDir>();
        for (Map.Entry<String, List<LocalIndexDir>> e : mapping.entrySet()) {
            result.addAll((Collection<LocalIndexDir>)e.getValue());
        }
        return result;
    }

    public List<LocalIndexDir> getLocalIndexes(String jcrPath) throws IOException {
        List<LocalIndexDir> result = this.getIndexesPerPath().get(jcrPath);
        return result == null ? Collections.emptyList() : result;
    }

    public long gcEmptyDirs(File subDir) throws IOException {
        File parent = ((File)Preconditions.checkNotNull((Object)subDir)).getParentFile().getCanonicalFile();
        LocalIndexDir indexDir = this.findMatchingIndexDir(parent);
        long totalDeletedSize = 0L;
        if (indexDir != null) {
            List<LocalIndexDir> idxDirs = this.getLocalIndexes(indexDir.getJcrPath());
            boolean matchingDirFound = false;
            for (LocalIndexDir d : idxDirs) {
                if (d.dir.equals(parent)) {
                    matchingDirFound = true;
                }
                if (!matchingDirFound || !d.isEmpty()) continue;
                long dirSize = FileUtils.sizeOf((File)d.dir);
                if (FileUtils.deleteQuietly((File)d.dir)) {
                    totalDeletedSize += dirSize;
                } else {
                    this.log.warn("Not able to deleted unused local index directory [{}]. Deletion would be retried later again.", (Object)d);
                }
                totalDeletedSize += this.deleteOldFormatDir(d.getJcrPath());
            }
        }
        return totalDeletedSize;
    }

    static String getIndexFolderBaseName(String indexPath) {
        ArrayList elements = Lists.newArrayList((Iterable)PathUtils.elements((String)indexPath));
        Collections.reverse(elements);
        ArrayList result = Lists.newArrayListWithCapacity((int)2);
        for (String e : Iterables.limit((Iterable)elements, (int)3)) {
            if ("oak:index".equals(e)) continue;
            result.add(IndexRootDirectory.getFSSafeName(e));
        }
        Collections.reverse(result);
        String name = Joiner.on((char)'_').join((Iterable)result);
        if (name.length() > 127) {
            name = name.substring(0, 127);
        }
        return name;
    }

    static String getPathHash(String indexPath) {
        return Hashing.sha256().hashString((CharSequence)indexPath, Charsets.UTF_8).toString();
    }

    private Map<String, List<LocalIndexDir>> getIndexesPerPath() throws IOException {
        File[] dirs = this.indexRootDir.listFiles(LOCAL_DIR_FILTER);
        ArrayListMultimap pathToDirMap = ArrayListMultimap.create();
        for (File indexDir : dirs) {
            LocalIndexDir localIndexDir = new LocalIndexDir(indexDir);
            pathToDirMap.get((Object)localIndexDir.getJcrPath()).add(localIndexDir);
        }
        TreeMap result = Maps.newTreeMap();
        for (Map.Entry e : pathToDirMap.asMap().entrySet()) {
            ArrayList sortedDirs = new ArrayList((Collection)e.getValue());
            Collections.sort(sortedDirs, Collections.reverseOrder());
            result.put((String)e.getKey(), sortedDirs);
        }
        return result;
    }

    private void gcIndexDirs() throws IOException {
        Map<String, List<LocalIndexDir>> mapping = this.getIndexesPerPath();
        long totalDeletedSize = 0L;
        for (Map.Entry<String, List<LocalIndexDir>> e : mapping.entrySet()) {
            List<LocalIndexDir> dirs = e.getValue();
            for (int i = 1; i < dirs.size(); ++i) {
                LocalIndexDir dir = dirs.get(i);
                long dirSize = FileUtils.sizeOf((File)dir.dir);
                if (FileUtils.deleteQuietly((File)dir.dir)) {
                    totalDeletedSize += dirSize;
                    continue;
                }
                this.log.warn("Not able to deleted unused local index directory [{}]. Deletion would be retried later again.", (Object)dir);
            }
            if (!dirs.isEmpty()) {
                totalDeletedSize += this.gcNRTIndexDirs(dirs.get(0));
            }
            totalDeletedSize += this.deleteOldFormatDir(dirs.get(0).getJcrPath());
        }
        if (totalDeletedSize > 0L) {
            this.log.info("Reclaimed [{}] space by removing unused/old index directories", (Object)IOUtils.humanReadableByteCount((long)totalDeletedSize));
        }
    }

    private long gcNRTIndexDirs(LocalIndexDir idxDir) {
        final String prefix = IndexRootDirectory.getFSSafeName("nrt-");
        File[] nrtDirs = idxDir.dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }
        });
        long size = 0L;
        if (nrtDirs != null) {
            for (File f : nrtDirs) {
                size += FileUtils.sizeOf((File)f);
                FileUtils.deleteQuietly((File)f);
            }
        }
        return size;
    }

    @Nullable
    private LocalIndexDir findMatchingIndexDir(File dir) throws IOException {
        dir = dir.getCanonicalFile();
        Map<String, List<LocalIndexDir>> mapping = this.getIndexesPerPath();
        for (Map.Entry<String, List<LocalIndexDir>> e : mapping.entrySet()) {
            for (LocalIndexDir idxDir : e.getValue()) {
                if (!idxDir.dir.equals(dir)) continue;
                return idxDir;
            }
        }
        return null;
    }

    private long deleteOldFormatDir(String jcrPath) {
        File oldDir = this.getOldFormatDir(jcrPath);
        if (oldDir.exists()) {
            long size = FileUtils.sizeOf((File)oldDir);
            if (!FileUtils.deleteQuietly((File)oldDir)) {
                this.log.warn("Not able to deleted unused local index directory [{}]", (Object)oldDir.getAbsolutePath());
            } else {
                return size;
            }
        }
        return 0L;
    }

    private File getOldFormatDir(String indexPath) {
        String subDir = IndexRootDirectory.getPathHash(indexPath);
        return new File(this.indexRootDir, subDir);
    }

    static String getFSSafeName(String e) {
        return e.replaceAll("\\W", "");
    }

    private static long getTime() {
        try {
            return Clock.SIMPLE.getTimeIncreasing();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Clock.SIMPLE.getTimeMonotonic();
        }
    }
}

