/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.function.Function;
import org.apache.jackrabbit.oak.commons.json.JsonObject;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LocalIndexDir;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.DefaultIndexReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.BytesRef;

public class IndexComparator {
    public static void main(String ... args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: java " + IndexComparator.class.getName() + " <lucene index directory> [<second lucene index directory>]");
            System.out.println("If only one directory is specified, then the output is json that contains the statistics of the index.");
            System.out.println("Instead of a directory, each argument can be a json file that contains the statistics of a previous run.");
            return;
        }
        String stats1 = IndexComparator.getStats(new File(args[0]));
        if (args.length > 1) {
            String stats2 = IndexComparator.getStats(new File(args[1]));
            System.out.println(IndexComparator.diff(stats1, stats2));
        } else {
            System.out.println(stats1);
        }
    }

    private static String diff(String stats1, String stats2) {
        JsonObject o1 = JsonObject.fromJson((String)stats1, (boolean)true);
        JsonObject o2 = JsonObject.fromJson((String)stats2, (boolean)true);
        o1.getProperties().remove("directory");
        o2.getProperties().remove("directory");
        JsopBuilder result = new JsopBuilder();
        result.object();
        IndexComparator.diff(o1, o2, "", result);
        result.endObject();
        if (result.toString().equals("{}")) {
            return "";
        }
        return JsopBuilder.prettyPrint((String)result.toString());
    }

    private static void diff(JsonObject o1, JsonObject o2, String path, JsopBuilder result) {
        String v2;
        String v1;
        boolean ignoreChecksums = false;
        if (path.startsWith("/files/")) {
            if (path.endsWith("index-details.txt")) {
                ignoreChecksums = true;
            } else if (path.endsWith(".si")) {
                ignoreChecksums = true;
            } else if (path.endsWith(".cfs") || path.endsWith(".cfe")) {
                ignoreChecksums = true;
            }
        }
        HashSet both = new HashSet(o1.getProperties().keySet());
        both.addAll(o2.getProperties().keySet());
        for (String k : both) {
            long x2;
            long x1;
            v1 = (String)o1.getProperties().get(k);
            v2 = (String)o2.getProperties().get(k);
            if (v1 != null && v1.equals(v2) || ignoreChecksums && ("sha256".equals(k) || "md5".equals(k) || "bytes".equals(k) && v1 != null && v2 != null && (Math.abs((x1 = Long.parseLong(v1)) - (x2 = Long.parseLong(v2))) < 1000L || Math.abs((double)x1 / (double)x2 - 1.0) < 0.001))) continue;
            result.key(path + "/" + k).object().key("v1").encodedValue(v1).key("v2").encodedValue(v2).endObject();
        }
        both = new HashSet(o1.getChildren().keySet());
        both.addAll(o2.getChildren().keySet());
        for (String k : both) {
            v1 = (JsonObject)o1.getChildren().get(k);
            v2 = (JsonObject)o2.getChildren().get(k);
            if (v1 == null || v2 == null) {
                result.key(path + "/" + k).object().key("v1").encodedValue("" + (JsonObject)v1).key("v2").encodedValue("" + (JsonObject)v2).endObject();
                continue;
            }
            IndexComparator.diff((JsonObject)v1, (JsonObject)v2, path + "/" + k, result);
        }
    }

    private static String getStats(File file) throws Exception {
        if (file.isDirectory()) {
            return IndexComparator.getStatsFromLucene(file);
        }
        return Files.readString(file.toPath());
    }

    private static String getStatsFromLucene(File directory) throws Exception {
        LocalIndexDir dir = new LocalIndexDir(directory);
        JsopBuilder builder = new JsopBuilder();
        builder.object();
        builder.key("directory").value(directory.getAbsolutePath());
        builder.key("files").object();
        IndexComparator.fileStats(directory, builder);
        builder.endObject();
        builder.key("luceneIndex").object();
        builder.key("jcrPath").value(dir.getJcrPath());
        try (SimpleFSDirectory luceneDir = new SimpleFSDirectory(new File(directory, "data"));
             DefaultIndexReader luceneReader = new DefaultIndexReader(luceneDir, null, null);){
            IndexReader reader = luceneReader.getReader();
            builder.key("numDocs").value((long)reader.numDocs());
            builder.key("maxDoc").value((long)reader.maxDoc());
            builder.key("numDeletedDocs").value((long)reader.numDeletedDocs());
            Fields fields = MultiFields.getFields(reader);
            if (fields != null) {
                builder.key("fields").object();
                for (String f : fields) {
                    BytesRef byteRef;
                    builder.key(f).object();
                    builder.key("docCount").value((long)reader.getDocCount(f));
                    Terms terms = MultiFields.getTerms(reader, f);
                    TermsEnum iterator = terms.iterator(null);
                    Function<BytesRef, String> handler = BytesRef::utf8ToString;
                    int termCount = 0;
                    int termHash = 0;
                    long docFreqSum = 0L;
                    while ((byteRef = iterator.next()) != null) {
                        ++termCount;
                        String term = handler.apply(byteRef);
                        termHash ^= term.hashCode();
                        int docFreq = iterator.docFreq();
                        docFreqSum += (long)docFreq;
                    }
                    builder.key("termCount").value((long)termCount);
                    builder.key("termHash").value((long)termHash);
                    builder.key("docFreqSum").value(docFreqSum);
                    builder.endObject();
                }
                builder.endObject();
            }
        }
        builder.endObject();
        builder.endObject();
        return JsopBuilder.prettyPrint((String)builder.toString());
    }

    private static void fileStats(File file, JsopBuilder builder) throws IOException, NoSuchAlgorithmException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                IndexComparator.fileStats(f, builder);
            }
        } else {
            builder.key(file.getName()).object();
            builder.key("bytes").value(file.length());
            try (FileInputStream in = new FileInputStream(file);){
                int numOfBytesRead;
                MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[8192];
                while ((numOfBytesRead = in.read(buffer)) > 0) {
                    sha256.update(buffer, 0, numOfBytesRead);
                    md5.update(buffer, 0, numOfBytesRead);
                }
                builder.key("sha256").value(IndexComparator.toHex(sha256.digest()));
                builder.key("md5").value(IndexComparator.toHex(md5.digest()));
            }
            builder.endObject();
        }
    }

    private static String toHex(byte[] data) {
        StringBuilder buff = new StringBuilder();
        for (byte b : data) {
            buff.append(String.format("%02x", b));
        }
        return buff.toString();
    }
}

