/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.DefaultIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterConfig;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.MultiplexersLucene;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.index.IndexableField;

class MultiplexingIndexWriter
implements LuceneIndexWriter {
    private final MountInfoProvider mountInfoProvider;
    private final DirectoryFactory directoryFactory;
    private final LuceneIndexDefinition definition;
    private final NodeBuilder definitionBuilder;
    private final boolean reindex;
    private final LuceneIndexWriterConfig writerConfig;
    private final Map<Mount, DefaultIndexWriter> writers = Maps.newHashMap();

    public MultiplexingIndexWriter(DirectoryFactory directoryFactory, MountInfoProvider mountInfoProvider, LuceneIndexDefinition definition, NodeBuilder definitionBuilder, boolean reindex, LuceneIndexWriterConfig writerConfig) {
        this.mountInfoProvider = mountInfoProvider;
        this.definition = definition;
        this.definitionBuilder = definitionBuilder;
        this.reindex = reindex;
        this.directoryFactory = directoryFactory;
        this.writerConfig = writerConfig;
    }

    @Override
    public void updateDocument(String path, Iterable<? extends IndexableField> doc) throws IOException {
        this.getWriter(path).updateDocument(path, doc);
    }

    @Override
    public void deleteDocuments(String path) throws IOException {
        Mount mount = this.mountInfoProvider.getMountByPath(path);
        this.getWriter(mount).deleteDocuments(path);
        if (mount.isDefault()) {
            for (Mount m : this.mountInfoProvider.getMountsPlacedUnder(path)) {
                this.getWriter(m).deleteAll();
            }
        }
    }

    @Override
    public boolean close(long timestamp) throws IOException {
        StreamSupport.stream(Iterables.concat(Collections.singleton(this.mountInfoProvider.getDefaultMount()), (Iterable)this.mountInfoProvider.getNonDefaultMounts()).spliterator(), false).filter(m -> this.reindex && !m.isReadOnly()).forEach(m -> this.getWriter((Mount)m));
        boolean indexUpdated = false;
        for (LuceneIndexWriter luceneIndexWriter : this.writers.values()) {
            indexUpdated |= luceneIndexWriter.close(timestamp);
        }
        return indexUpdated;
    }

    private LuceneIndexWriter getWriter(String path) {
        Mount mount = this.mountInfoProvider.getMountByPath(path);
        return this.getWriter(mount);
    }

    private DefaultIndexWriter getWriter(Mount mount) {
        DefaultIndexWriter writer = this.writers.get(mount);
        if (writer == null) {
            writer = this.createWriter(mount);
            this.writers.put(mount, writer);
        }
        return writer;
    }

    private DefaultIndexWriter createWriter(Mount m) {
        String dirName = MultiplexersLucene.getIndexDirName(m);
        String suggestDirName = MultiplexersLucene.getSuggestDirName(m);
        return new DefaultIndexWriter(this.definition, this.definitionBuilder, this.directoryFactory, dirName, suggestDirName, this.reindex, this.writerConfig);
    }
}

