/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class IndexLookup {
    private final NodeState root;
    private final Predicate<NodeState> definitionPredicate;

    public IndexLookup(NodeState root, Predicate<NodeState> definitionPredicate) {
        this.root = root;
        this.definitionPredicate = definitionPredicate;
    }

    public Collection<String> collectIndexNodePaths(Filter filter) {
        return this.collectIndexNodePaths(filter, true);
    }

    public Collection<String> collectIndexNodePaths(Filter filter, boolean recurse) {
        HashSet paths = Sets.newHashSet();
        this.collectIndexNodePaths(this.root, "/", paths);
        if (recurse) {
            StringBuilder sb = new StringBuilder();
            NodeState nodeState = this.root;
            for (String element : PathUtils.elements((String)filter.getPath())) {
                nodeState = nodeState.getChildNode(element);
                this.collectIndexNodePaths(nodeState, sb.append("/").append(element).toString(), paths);
            }
        }
        return paths;
    }

    private void collectIndexNodePaths(NodeState nodeState, String parentPath, Collection<String> paths) {
        NodeState state = nodeState.getChildNode("oak:index");
        for (ChildNodeEntry entry : state.getChildNodeEntries()) {
            if (!this.definitionPredicate.test(entry.getNodeState())) continue;
            paths.add(IndexLookup.createIndexNodePath(parentPath, entry.getName()));
        }
    }

    private static String createIndexNodePath(String parentPath, String name) {
        return PathUtils.concat((String)parentPath, (String[])new String[]{"oak:index", name});
    }
}

