/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.binary;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TikaParserConfig {
    private static final String EMPTY_PARSER = "org.apache.tika.parser.EmptyParser";

    public static Set<MediaType> getNonIndexedMediaTypes(InputStream configStream) throws TikaException, IOException, SAXException {
        HashSet<MediaType> result = new HashSet<MediaType>();
        Element element = TikaParserConfig.getBuilder().parse(configStream).getDocumentElement();
        NodeList nodes = element.getElementsByTagName("parsers");
        if (nodes.getLength() == 1) {
            Node parentNode = nodes.item(0);
            NodeList parsersNodes = parentNode.getChildNodes();
            for (int i = 0; i < parsersNodes.getLength(); ++i) {
                String className;
                Node node = parsersNodes.item(i);
                if (!(node instanceof Element) || !EMPTY_PARSER.equals(className = ((Element)node).getAttribute("class"))) continue;
                NodeList mimes = ((Element)node).getElementsByTagName("mime");
                TikaParserConfig.parseMimeTypes(result, mimes);
            }
        }
        return result;
    }

    private static void parseMimeTypes(Set<MediaType> result, NodeList mimes) {
        for (int j = 0; j < mimes.getLength(); ++j) {
            MediaType mediaType;
            Node mime = mimes.item(j);
            if (!(mime instanceof Element)) continue;
            String mimeValue = mime.getTextContent();
            if ((mimeValue = Strings.emptyToNull((String)mimeValue)) == null || (mediaType = MediaType.parse((String)mimeValue.trim())) == null) continue;
            result.add(mediaType);
        }
    }

    private static DocumentBuilder getBuilder() throws TikaException {
        return new ParseContext().getDocumentBuilder();
    }
}

