/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.query;

import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.search.update.ReaderRefreshPolicy;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;

public abstract class IndexNodeManager<I extends IndexNode> {
    public static final String ASYNC = ":async";
    private boolean closed = false;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Semaphore refreshLock = new Semaphore(1);
    private final Runnable refreshCallback = () -> {
        if (this.refreshLock.tryAcquire()) {
            try {
                this.refreshReaders();
            }
            finally {
                this.refreshLock.release();
            }
        }
    };

    protected abstract String getName();

    protected abstract I getIndexNode();

    protected abstract IndexDefinition getDefinition();

    protected abstract ReaderRefreshPolicy getReaderRefreshPolicy();

    protected abstract void refreshReaders();

    protected abstract void releaseResources();

    static boolean hasAsyncIndexerRun(NodeState root, String indexPath, NodeState defnNodeState) {
        boolean hasAsyncNode = root.hasChildNode(ASYNC);
        String asyncLaneName = IndexUtils.getAsyncLaneName((NodeState)defnNodeState, (String)indexPath, (PropertyState)defnNodeState.getProperty("async"));
        if (asyncLaneName != null) {
            return hasAsyncNode && root.getChildNode(ASYNC).hasProperty(asyncLaneName);
        }
        return false;
    }

    protected void release() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public I acquire() {
        this.lock.readLock().lock();
        if (this.closed) {
            this.lock.readLock().unlock();
            return null;
        }
        boolean success = false;
        try {
            this.getReaderRefreshPolicy().refreshOnReadIfRequired(this.refreshCallback);
            I indexNode = this.getIndexNode();
            success = true;
            I i = indexNode;
            return i;
        }
        finally {
            if (!success) {
                this.lock.readLock().unlock();
            }
        }
    }

    public void close() {
        this.lock.writeLock().lock();
        try {
            if (this.closed) {
                throw new IllegalStateException("IndexNodeManager already closed");
            }
            this.closed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.releaseResources();
    }
}

