/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.util;

import java.util.Iterator;
import java.util.Random;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;

public class TapeSampling<T> {
    private final Random rGen;
    private final Iterator<T> input;
    private final int N;
    private final int k;

    public TapeSampling(Random rGen, Iterator<T> input, int N, int k) {
        this.rGen = rGen;
        this.input = input;
        this.N = N;
        this.k = k;
    }

    public Iterator<T> getSamples() {
        return new AbstractIterator<T>(){
            int sampled = 0;
            int seen = 0;

            protected T computeNext() {
                Object i;
                int r;
                if (this.sampled == TapeSampling.this.k) {
                    return this.endOfData();
                }
                do {
                    Preconditions.checkArgument((boolean)TapeSampling.this.input.hasNext(), (Object)("Not enough input items provided. Declared: " + TapeSampling.this.N + "; got " + this.seen + "; sampled: " + this.sampled));
                    i = TapeSampling.this.input.next();
                    r = TapeSampling.this.rGen.nextInt(TapeSampling.this.N - this.seen) + 1;
                    ++this.seen;
                } while (r > TapeSampling.this.k - this.sampled);
                ++this.sampled;
                return i;
            }
        };
    }
}

