/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import java.util.HashSet;
import java.util.Objects;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneDocumentMaker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexedPathInfo;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexedPaths;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexingQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDoc;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.observation.Filter;
import org.apache.jackrabbit.oak.spi.commit.CommitContext;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalIndexObserver
implements Observer,
Filter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IndexingQueue indexingQueue;
    private final IndexTracker indexTracker;
    private final MeterStats added;
    private final TimerStats timer;

    public ExternalIndexObserver(IndexingQueue indexingQueue, IndexTracker indexTracker, StatisticsProvider statisticsProvider) {
        this.indexingQueue = Objects.requireNonNull(indexingQueue);
        this.indexTracker = Objects.requireNonNull(indexTracker);
        this.added = statisticsProvider.getMeter("HYBRID_EXTERNAL_ADDED", StatsOptions.METRICS_ONLY);
        this.timer = statisticsProvider.getTimer("HYBRID_EXTERNAL_TIME", StatsOptions.METRICS_ONLY);
    }

    public boolean excludes(@NotNull NodeState root, @NotNull CommitInfo info) {
        if (!info.isExternal()) {
            return true;
        }
        CommitContext commitContext = (CommitContext)info.getInfo().get("oak.commitAttributes");
        if (commitContext == null) {
            return true;
        }
        IndexedPaths indexedPaths = (IndexedPaths)commitContext.get("luceneDocs");
        if (indexedPaths == null) {
            this.log.debug("IndexPaths not found. Journal support missing");
            return true;
        }
        return indexedPaths.isEmpty();
    }

    public void contentChanged(@NotNull NodeState after, @NotNull CommitInfo info) {
        if (this.excludes(after, info)) {
            return;
        }
        CommitContext commitContext = (CommitContext)info.getInfo().get("oak.commitAttributes");
        IndexedPaths indexedPaths = (IndexedPaths)commitContext.get("luceneDocs");
        commitContext.remove("luceneDocs");
        this.log.trace("Received indexed paths {}", (Object)indexedPaths);
        int droppedCount = 0;
        int indexedCount = 0;
        TimerStats.Context ctx = this.timer.time();
        HashSet<String> indexPaths = new HashSet<String>();
        for (IndexedPathInfo indexData : indexedPaths) {
            String path = indexData.getPath();
            NodeState indexedNode = null;
            for (String indexPath : indexData.getIndexPaths()) {
                LuceneIndexDefinition defn = this.indexTracker.getIndexDefinition(indexPath);
                if (defn == null) continue;
                if (indexedNode == null) {
                    indexedNode = NodeStateUtils.getNode((NodeState)after, (String)path);
                }
                if (!indexedNode.exists()) continue;
                IndexDefinition.IndexingRule indexingRule = defn.getApplicableIndexingRule(indexedNode);
                if (indexingRule == null) {
                    this.log.debug("No indexingRule found for path {} for index {}", (Object)path, (Object)indexPath);
                    continue;
                }
                indexPaths.add(indexPath);
                try {
                    Document doc = (Document)new LuceneDocumentMaker(defn, indexingRule, path).makeDocument(indexedNode);
                    if (doc == null) continue;
                    if (this.indexingQueue.add(LuceneDoc.forUpdate(indexPath, path, doc))) {
                        ++indexedCount;
                        continue;
                    }
                    ++droppedCount;
                }
                catch (Exception e) {
                    this.log.warn("Ignoring making LuceneDocument for path {} for index {} due to exception", new Object[]{path, indexPath, e});
                }
            }
        }
        if (droppedCount > 0) {
            this.log.warn("Dropped [{}] docs from indexing as queue is full", (Object)droppedCount);
        }
        this.added.mark((long)indexedCount);
        ctx.stop();
        this.log.debug("Added {} documents for {} indexes from external changes", (Object)indexedCount, (Object)indexPaths.size());
    }
}

