/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.guava.common.collect.ArrayListMultimap;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.ListMultimap;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalProperty;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexingQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDoc;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDocInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneDocumentHolder
implements JournalProperty {
    private static final Logger log = LoggerFactory.getLogger(LuceneDocumentHolder.class);
    public static final String NAME = "luceneDocs";
    private final ListMultimap<String, LuceneDoc> nrtIndexedList = ArrayListMultimap.create();
    private final ListMultimap<String, LuceneDoc> syncIndexedList = ArrayListMultimap.create();
    private final ListMultimap<String, String> queuedNrtIndexedPath = ArrayListMultimap.create();
    private final ListMultimap<String, LuceneDoc> queuedSyncIndexedPath = ArrayListMultimap.create();
    private final int inMemoryDocsLimit;
    private final IndexingQueue documentQueue;
    private boolean limitWarningLogged;
    private boolean docAddedToQueue;
    private boolean schedulingDone;

    public LuceneDocumentHolder(@NotNull IndexingQueue documentQueue, int inMemoryDocsLimit) {
        this.documentQueue = Objects.requireNonNull(documentQueue);
        this.inMemoryDocsLimit = inMemoryDocsLimit;
    }

    public Iterable<LuceneDoc> getNRTIndexedDocs() {
        return this.nrtIndexedList.values();
    }

    public Map<String, Collection<LuceneDoc>> getSyncIndexedDocs() {
        for (Map.Entry e : this.queuedSyncIndexedPath.entries()) {
            if (((LuceneDoc)e.getValue()).isProcessed()) continue;
            this.syncIndexedList.put((Object)((String)e.getKey()), (Object)((LuceneDoc)e.getValue()));
        }
        return this.syncIndexedList.asMap();
    }

    public void add(boolean sync, LuceneDoc doc) {
        if (this.documentQueue.addIfNotFullWithoutWait(doc = Objects.requireNonNull(doc))) {
            if (sync) {
                this.queuedSyncIndexedPath.put((Object)doc.indexPath, (Object)doc);
            } else {
                this.queuedNrtIndexedPath.put((Object)doc.indexPath, (Object)doc.docPath);
            }
            this.docAddedToQueue = true;
        } else if (sync) {
            this.syncIndexedList.put((Object)doc.indexPath, (Object)doc);
        } else if (this.queueSizeWithinLimits()) {
            this.nrtIndexedList.put((Object)doc.indexPath, (Object)doc);
        }
    }

    public void done(String indexPath) {
        if (this.docAddedToQueue && !this.schedulingDone) {
            this.documentQueue.scheduleQueuedDocsProcessing();
            this.schedulingDone = true;
        }
    }

    Iterable<? extends LuceneDocInfo> getAllLuceneDocInfo() {
        return Iterables.concat((Iterable)this.nrtIndexedList.values(), (Iterable)this.syncIndexedList.values(), LuceneDocumentHolder.asLuceneDocInfo(this.queuedNrtIndexedPath), (Iterable)this.queuedSyncIndexedPath.values());
    }

    private boolean queueSizeWithinLimits() {
        if (this.nrtIndexedList.size() >= this.inMemoryDocsLimit) {
            if (!this.limitWarningLogged) {
                log.warn("Number of in memory documents meant for hybrid indexing has exceeded limit [{}]. Some documents would be dropped", (Object)this.inMemoryDocsLimit);
                this.limitWarningLogged = true;
            }
            return false;
        }
        return true;
    }

    private static Iterable<? extends LuceneDocInfo> asLuceneDocInfo(ListMultimap<String, String> docs) {
        return Iterables.transform((Iterable)docs.entries(), input -> new LuceneDocInfo((Map.Entry)input){
            final /* synthetic */ Map.Entry val$input;
            {
                this.val$input = entry;
            }

            @Override
            public String getIndexPath() {
                return (String)this.val$input.getKey();
            }

            @Override
            public String getDocPath() {
                return (String)this.val$input.getValue();
            }
        });
    }
}

