/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.HybridPropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePatternUtil;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.UniqueEntryStoreStrategy;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridPropertyIndexLookup {
    private static final Logger log = LoggerFactory.getLogger(HybridPropertyIndexLookup.class);
    private final String indexPath;
    private final NodeState indexState;
    private final String pathPrefix;
    private final boolean prependPathPrefix;

    public HybridPropertyIndexLookup(String indexPath, NodeState indexState) {
        this(indexPath, indexState, "", false);
    }

    public HybridPropertyIndexLookup(String indexPath, NodeState indexState, String pathPrefix, boolean prependPathPrefix) {
        this.indexPath = indexPath;
        this.indexState = indexState;
        this.pathPrefix = pathPrefix;
        this.prependPathPrefix = prependPathPrefix;
    }

    public Iterable<String> query(Filter filter, String propertyName, Filter.PropertyRestriction restriction) {
        Set values = ValuePatternUtil.getAllValues((Filter.PropertyRestriction)restriction);
        Set encodedValues = PropertyIndexUtil.encode((Set)values);
        return this.query(filter, propertyName, encodedValues);
    }

    public Iterable<String> query(Filter filter, String propertyName, PropertyValue value) {
        Set values = CollectionUtils.toSet((Iterable)((Iterable)value.getValue(Type.STRINGS)));
        return this.query(filter, propertyName, PropertyIndexUtil.encode((Set)values));
    }

    private Iterable<String> query(Filter filter, String propertyName, Set<String> encodedValues) {
        String propIdxNodeName = HybridPropertyIndexUtil.getNodeName(propertyName);
        NodeState propIndexRootNode = this.indexState.getChildNode(":property-index");
        NodeState propIndexNode = propIndexRootNode.getChildNode(propIdxNodeName);
        if (!propIndexNode.exists()) {
            return Collections.emptyList();
        }
        String indexName = this.indexPath + "(" + propertyName + ")";
        Iterable<String> result = HybridPropertyIndexUtil.uniquePropertyIndex(propIndexNode) ? HybridPropertyIndexLookup.queryUnique(filter, indexName, propIndexRootNode, propIdxNodeName, encodedValues) : this.querySimple(filter, indexName, propIndexNode, encodedValues);
        Iterable paths = Iterables.transform(result, path -> PathUtils.isAbsolute((String)path) ? path : "/" + path);
        if (log.isTraceEnabled()) {
            paths = Iterables.transform((Iterable)paths, path -> {
                log.trace("[{}] {} = {} -> {}", new Object[]{this.indexPath, propertyName, encodedValues, path});
                return path;
            });
        }
        return paths;
    }

    private static Iterable<String> queryUnique(Filter filter, String indexName, NodeState propIndexRootNode, String propIdxNodeName, Set<String> values) {
        UniqueEntryStoreStrategy s = new UniqueEntryStoreStrategy(propIdxNodeName);
        return s.query(filter, indexName, propIndexRootNode, values);
    }

    private Iterable<String> querySimple(Filter filter, String indexName, NodeState propIndexNode, Set<String> values) {
        return Iterables.concat(this.queryBucket(filter, indexName, propIndexNode, "head", values), this.queryBucket(filter, indexName, propIndexNode, "previous", values));
    }

    private Iterable<String> queryBucket(Filter filter, String indexName, NodeState propIndexNode, String bucketPropName, Set<String> values) {
        String bucketName = propIndexNode.getString(bucketPropName);
        if (bucketName == null) {
            return Collections.emptyList();
        }
        NodeState bucket = propIndexNode.getChildNode(bucketName);
        if (bucket.getChildNodeCount(1L) == 0L) {
            return Collections.emptyList();
        }
        ContentMirrorStoreStrategy s = new ContentMirrorStoreStrategy(bucketName, this.pathPrefix, this.prependPathPrefix);
        return s.query(filter, indexName, propIndexNode, bucketName, values);
    }
}

