/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.base.Suppliers;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.HybridPropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.UniquenessConstraintValidator;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePattern;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.ContentMirrorStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.UniqueEntryStoreStrategy;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyUpdateCallback;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIndexUpdateCallback
implements PropertyUpdateCallback {
    private static final Logger log = LoggerFactory.getLogger(PropertyIndexUpdateCallback.class);
    private static final String DEFAULT_HEAD_BUCKET = String.valueOf(1);
    private final NodeBuilder builder;
    private final String indexPath;
    private final UniquenessConstraintValidator uniquenessConstraintValidator;
    private final long updateTime;

    public PropertyIndexUpdateCallback(String indexPath, NodeBuilder builder, NodeState rootState) {
        this(indexPath, builder, rootState, Clock.SIMPLE);
    }

    public PropertyIndexUpdateCallback(String indexPath, NodeBuilder builder, NodeState rootState, Clock clock) {
        this.builder = builder;
        this.indexPath = indexPath;
        this.updateTime = clock.getTime();
        this.uniquenessConstraintValidator = new UniquenessConstraintValidator(indexPath, builder, rootState);
    }

    @Override
    public void propertyUpdated(String nodePath, String propertyRelativePath, PropertyDefinition pd, @Nullable PropertyState before, @Nullable PropertyState after) {
        if (!pd.sync) {
            return;
        }
        Set<String> beforeKeys = PropertyIndexUpdateCallback.getValueKeys(before, pd.valuePattern);
        Set<String> afterKeys = PropertyIndexUpdateCallback.getValueKeys(after, pd.valuePattern);
        HashSet<String> sharedKeys = new HashSet<String>(beforeKeys);
        sharedKeys.retainAll(afterKeys);
        beforeKeys.removeAll(sharedKeys);
        afterKeys.removeAll(sharedKeys);
        if (!beforeKeys.isEmpty() || !afterKeys.isEmpty()) {
            NodeBuilder indexNode = this.getIndexNode(propertyRelativePath, pd.unique);
            if (pd.unique) {
                UniqueEntryStoreStrategy s = new UniqueEntryStoreStrategy(":index", nb -> nb.setProperty("jcr:created", (Object)this.updateTime));
                s.update((Supplier)Suppliers.ofInstance((Object)indexNode), nodePath, null, null, beforeKeys, afterKeys);
                this.uniquenessConstraintValidator.add(propertyRelativePath, afterKeys);
            } else {
                ContentMirrorStoreStrategy s = new ContentMirrorStoreStrategy();
                s.update((Supplier)Suppliers.ofInstance((Object)indexNode), nodePath, null, null, Collections.emptySet(), afterKeys);
            }
            if (log.isTraceEnabled()) {
                log.trace("[{}] Property index updated for [{}/@{}] with values {}", new Object[]{this.indexPath, nodePath, propertyRelativePath, afterKeys});
            }
        }
    }

    @Override
    public void done() throws CommitFailedException {
        this.uniquenessConstraintValidator.validate();
    }

    public UniquenessConstraintValidator getUniquenessConstraintValidator() {
        return this.uniquenessConstraintValidator;
    }

    private NodeBuilder getIndexNode(String propertyRelativePath, boolean unique) {
        NodeBuilder propertyIndex = this.builder.child(":property-index");
        if (propertyIndex.isNew()) {
            propertyIndex.setProperty("retainNodeInReindex", (Object)true);
        }
        String nodeName = HybridPropertyIndexUtil.getNodeName(propertyRelativePath);
        if (unique) {
            return PropertyIndexUpdateCallback.getUniqueIndexBuilder(propertyIndex, nodeName);
        }
        return this.getSimpleIndexBuilder(propertyIndex, nodeName);
    }

    private NodeBuilder getSimpleIndexBuilder(NodeBuilder propertyIndex, String nodeName) {
        NodeBuilder idx = propertyIndex.child(nodeName);
        if (idx.isNew()) {
            idx.setProperty("head", (Object)DEFAULT_HEAD_BUCKET);
            idx.setProperty("storageType", (Object)"contentMirror");
        }
        String headBucketName = idx.getString("head");
        Objects.requireNonNull(headBucketName, String.format("[%s] property not found in [%s] for index [%s]", "head", idx, this.indexPath));
        return idx.child(headBucketName);
    }

    private static NodeBuilder getUniqueIndexBuilder(NodeBuilder propertyIndex, String nodeName) {
        NodeBuilder idx = propertyIndex.child(nodeName);
        if (idx.isNew()) {
            idx.setProperty("storageType", (Object)"unique");
        }
        return idx;
    }

    private static Set<String> getValueKeys(PropertyState property, ValuePattern pattern) {
        HashSet<String> keys = new HashSet<String>();
        if (property != null && property.getType().tag() != 2 && property.count() != 0) {
            keys.addAll(PropertyIndexUtil.encode((PropertyValue)PropertyValues.create((PropertyState)property), (ValuePattern)pattern));
        }
        return keys;
    }
}

