/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.property;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.HashMultimap;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Multimap;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.PropertyIndexQuery;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.PropertyQuery;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public class UniquenessConstraintValidator {
    private final NodeState rootState;
    private final String indexPath;
    private final Multimap<String, String> uniqueKeys = HashMultimap.create();
    private final PropertyQuery firstStore;
    private PropertyQuery secondStore = PropertyQuery.DEFAULT;

    public UniquenessConstraintValidator(String indexPath, NodeBuilder builder, NodeState rootState) {
        this.indexPath = indexPath;
        this.rootState = rootState;
        this.firstStore = new PropertyIndexQuery(builder);
    }

    public void add(String propertyRelativePath, Set<String> afterKeys) {
        this.uniqueKeys.putAll((Object)propertyRelativePath, afterKeys);
    }

    public void validate() throws CommitFailedException {
        for (Map.Entry e : this.uniqueKeys.entries()) {
            String value;
            String propertyRelativePath = (String)e.getKey();
            Iterable<String> indexedPaths = this.getIndexedPaths(propertyRelativePath, value = (String)e.getValue());
            Object allPaths = ImmutableSet.copyOf(indexedPaths);
            if (allPaths.size() > 1) {
                allPaths = this.getValidPaths((Set<String>)allPaths, propertyRelativePath, value);
            }
            if (allPaths.size() <= 1) continue;
            String msg = String.format("Uniqueness constraint violated for property [%s] with value [%s] for index [%s]. Indexed paths %s", propertyRelativePath, value, this.indexPath, allPaths);
            throw new CommitFailedException("Constraint", 30, msg);
        }
    }

    public void setSecondStore(PropertyQuery secondStore) {
        this.secondStore = Objects.requireNonNull(secondStore);
    }

    private Iterable<String> getIndexedPaths(String propertyRelativePath, String value) {
        return Iterables.concat(this.firstStore.getIndexedPaths(propertyRelativePath, value), this.secondStore.getIndexedPaths(propertyRelativePath, value));
    }

    private Set<String> getValidPaths(Set<String> allPaths, String propertyRelativePath, String value) {
        HashSet<String> validPaths = new HashSet<String>();
        block0: for (String path : allPaths) {
            PropertyState uniqueProp;
            NodeState node = NodeStateUtils.getNode((NodeState)this.rootState, (String)path);
            if (!node.exists() || (uniqueProp = UniquenessConstraintValidator.getValue(node, propertyRelativePath)) == null) continue;
            for (String v : (Iterable)uniqueProp.getValue(Type.STRINGS)) {
                if (!v.equals(value)) continue;
                validPaths.add(path);
                continue block0;
            }
        }
        return validPaths;
    }

    private static PropertyState getValue(NodeState node, String propertyRelativePath) {
        int depth = PathUtils.getDepth((String)propertyRelativePath);
        NodeState propNode = node;
        String propName = propertyRelativePath;
        if (depth > 1) {
            propName = PathUtils.getName((String)propertyRelativePath);
            String parentPath = PathUtils.getParentPath((String)propertyRelativePath);
            propNode = NodeStateUtils.getNode((NodeState)node, (String)parentPath);
        }
        return propNode.getProperty(propName);
    }
}

