/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.writer;

import java.util.Objects;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexWriterFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.DefaultIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterConfig;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.MultiplexingIndexWriter;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class DefaultIndexWriterFactory
implements LuceneIndexWriterFactory {
    private final MountInfoProvider mountInfoProvider;
    private final DirectoryFactory directoryFactory;
    private final LuceneIndexWriterConfig writerConfig;

    public DefaultIndexWriterFactory(MountInfoProvider mountInfoProvider, DirectoryFactory directoryFactory, LuceneIndexWriterConfig writerConfig) {
        this.mountInfoProvider = Objects.requireNonNull(mountInfoProvider);
        this.directoryFactory = Objects.requireNonNull(directoryFactory);
        this.writerConfig = Objects.requireNonNull(writerConfig);
    }

    @Override
    public LuceneIndexWriter newInstance(IndexDefinition def, NodeBuilder definitionBuilder, CommitInfo commitInfo, boolean reindex) {
        Validate.checkArgument((boolean)(def instanceof LuceneIndexDefinition), (String)"Expected %s but found %s for index definition", (Object[])new Object[]{LuceneIndexDefinition.class, def.getClass()});
        LuceneIndexDefinition definition = (LuceneIndexDefinition)def;
        if (this.mountInfoProvider.hasNonDefaultMounts()) {
            return new MultiplexingIndexWriter(this.directoryFactory, this.mountInfoProvider, definition, definitionBuilder, reindex, this.writerConfig);
        }
        return new DefaultIndexWriter(definition, definitionBuilder, this.directoryFactory, ":data", ":suggest-data", reindex, this.writerConfig);
    }
}

