/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FieldNames {
    public static final String PATH = ":path";
    public static final String ANCESTORS = ":ancestors";
    public static final String PATH_DEPTH = ":depth";
    public static final String FULLTEXT = ":fulltext";
    private static final String SIMILARITY_PREFIX = "sim:";
    private static final String SIMILARITY_BINARY_PREFIX = "simbin:";
    public static final String SIMILARITY_TAGS = "simtags";
    public static final String SUGGEST = ":suggest";
    public static final String SPELLCHECK = ":spellcheck";
    public static final String ANALYZED_FIELD_PREFIX = "full:";
    public static final String FULLTEXT_RELATIVE_NODE = "fullnode:";
    public static final String NULL_PROPS = ":nullProps";
    public static final String NOT_NULL_PROPS = ":notNullProps";
    public static final String NODE_NAME = ":nodeName";
    public static final String FUNCTION_PREFIX = "function*";
    public static final Set<String> PATH_SELECTOR = new HashSet<String>(Collections.singletonList(":path"));

    private FieldNames() {
    }

    public static String createDocValFieldName(String name) {
        return ":dv" + name;
    }

    public static String createAnalyzedFieldName(String pname) {
        return ANALYZED_FIELD_PREFIX + pname;
    }

    public static String createFulltextFieldName(String nodeRelativePath) {
        if (nodeRelativePath == null) {
            return FULLTEXT;
        }
        return FULLTEXT_RELATIVE_NODE + nodeRelativePath;
    }

    public static String createFacetFieldName(String pname) {
        return pname + "_facet";
    }

    public static boolean isPropertyField(String field) {
        return !field.startsWith(ANALYZED_FIELD_PREFIX) && !field.startsWith(FULLTEXT_RELATIVE_NODE) && !field.startsWith(":") && !field.endsWith("_facet");
    }

    public static boolean isNullPropsField(String field) {
        return field.equals(NULL_PROPS);
    }

    public static String createSimilarityFieldName(String name) {
        return SIMILARITY_PREFIX + name;
    }

    public static String createBinSimilarityFieldName(String name) {
        return SIMILARITY_BINARY_PREFIX + name;
    }
}

