/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.util;

import java.util.Set;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexHelper {
    public static final Set<String> JR_PROPERTY_INCLUDES = Set.of("String", "Binary");
    private static final Set<String> NOT_TOKENIZED = CollectionUtils.toSet((Object[])new String[]{"jcr:uuid"});

    public static NodeBuilder newFTIndexDefinition(@NotNull NodeBuilder index, @NotNull String name, String type, @Nullable Set<String> propertyTypes) {
        return IndexHelper.newFTIndexDefinition(index, name, type, propertyTypes, null, null, null);
    }

    public static NodeBuilder newFTIndexDefinition(@NotNull NodeBuilder index, @NotNull String name, String type, @Nullable Set<String> propertyTypes, @Nullable Set<String> excludes, @Nullable String async) {
        return IndexHelper.newFTIndexDefinition(index, type, name, propertyTypes, excludes, async, null);
    }

    public static NodeBuilder newFTIndexDefinition(@NotNull NodeBuilder index, @NotNull String name, String type, @Nullable Set<String> propertyTypes, @Nullable Set<String> excludes, @Nullable String async, @Nullable Boolean stored) {
        if (index.hasChildNode(name)) {
            return index.child(name);
        }
        index = index.child(name);
        index.setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME).setProperty("type", (Object)type).setProperty("reindex", (Object)true);
        if (async != null) {
            index.setProperty("async", (Object)async);
        }
        if (propertyTypes != null && !propertyTypes.isEmpty()) {
            index.setProperty(PropertyStates.createProperty((String)"includePropertyTypes", propertyTypes, (Type)Type.STRINGS));
        }
        if (excludes != null && !excludes.isEmpty()) {
            index.setProperty(PropertyStates.createProperty((String)"excludePropertyNames", excludes, (Type)Type.STRINGS));
        }
        if (stored != null) {
            index.setProperty(PropertyStates.createProperty((String)"oak.experimental.storage", (Object)stored));
        }
        return index;
    }

    public static NodeBuilder newFTFileIndexDefinition(@NotNull NodeBuilder index, @NotNull String name, String type, @Nullable Set<String> propertyTypes, @NotNull String path) {
        return IndexHelper.newFTFileIndexDefinition(index, type, name, propertyTypes, null, path, null);
    }

    public static NodeBuilder newFTFileIndexDefinition(@NotNull NodeBuilder index, @NotNull String name, String type, @Nullable Set<String> propertyTypes, @Nullable Set<String> excludes, @NotNull String path, @Nullable String async) {
        if (index.hasChildNode(name)) {
            return index.child(name);
        }
        index = index.child(name);
        index.setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME).setProperty("type", (Object)type).setProperty("persistence", (Object)"file").setProperty("path", (Object)path).setProperty("reindex", (Object)true);
        if (async != null) {
            index.setProperty("async", (Object)async);
        }
        if (propertyTypes != null && !propertyTypes.isEmpty()) {
            index.setProperty(PropertyStates.createProperty((String)"includePropertyTypes", propertyTypes, (Type)Type.STRINGS));
        }
        if (excludes != null && !excludes.isEmpty()) {
            index.setProperty(PropertyStates.createProperty((String)"excludePropertyNames", excludes, (Type)Type.STRINGS));
        }
        return index;
    }

    public static NodeBuilder newFTPropertyIndexDefinition(@NotNull NodeBuilder index, @NotNull String name, String type, @NotNull Set<String> includes, @NotNull String async) {
        Validate.checkArgument((!includes.isEmpty() ? 1 : 0) != 0, (String)"Fulltext property index requires explicit list of property names to be indexed");
        index = index.child(name);
        index.setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition", Type.NAME).setProperty("type", (Object)type).setProperty("reindex", (Object)true);
        index.setProperty("fulltextEnabled", (Object)false);
        index.setProperty(PropertyStates.createProperty((String)"includePropertyNames", includes, (Type)Type.STRINGS));
        if (async != null) {
            index.setProperty("async", (Object)async);
        }
        return index;
    }

    public static boolean skipTokenization(String name) {
        return NOT_TOKENIZED.contains(name);
    }

    public static boolean isIndexNodeOfType(NodeState node, String type) {
        return type.equals(node.getString("type"));
    }

    static {
        NOT_TOKENIZED.addAll(UserConstants.USER_PROPERTY_NAMES);
        NOT_TOKENIZED.addAll(UserConstants.GROUP_PROPERTY_NAMES);
    }
}

