/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.util;

import java.math.BigDecimal;
import java.util.Objects;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public class NodeStateCopyUtils {
    private static final String OAK_CHILD_ORDER = ":childOrder";

    public static void copyToTree(NodeState state, Tree tree) {
        tree.setOrderableChildren(state.hasProperty(OAK_CHILD_ORDER));
        NodeStateCopyUtils.copyProps(state, tree);
        Tree src = TreeFactory.createReadOnlyTree((NodeState)state);
        for (Tree srcChild : src.getChildren()) {
            String childName = srcChild.getName();
            Tree child = tree.addChild(childName);
            NodeStateCopyUtils.copyToTree(state.getChildNode(childName), child);
        }
    }

    public static void copyToNode(NodeState state, Node node) throws RepositoryException {
        NodeStateCopyUtils.copyProps(state, node);
        Tree src = TreeFactory.createReadOnlyTree((NodeState)state);
        for (Tree srcChild : src.getChildren()) {
            String childName = srcChild.getName();
            if (NodeStateUtils.isHidden((String)childName)) continue;
            NodeState childState = state.getChildNode(childName);
            Node child = JcrUtils.getOrAddNode((Node)node, (String)childName, (String)NodeStateCopyUtils.primaryType(childState));
            NodeStateCopyUtils.copyToNode(childState, child);
        }
    }

    private static void copyProps(NodeState state, Tree tree) {
        for (PropertyState ps : state.getProperties()) {
            if (ps.getName().equals(OAK_CHILD_ORDER)) continue;
            tree.setProperty(ps);
        }
    }

    private static void copyProps(NodeState state, Node node) throws RepositoryException {
        ValueFactory vf = node.getSession().getValueFactory();
        for (PropertyState ps : state.getProperties()) {
            String name = ps.getName();
            if (name.equals("jcr:primaryType") || name.equals(OAK_CHILD_ORDER)) continue;
            if (name.equals("jcr:mixinTypes")) {
                for (String n : (Iterable)ps.getValue(Type.NAMES)) {
                    node.addMixin(n);
                }
                continue;
            }
            if (NodeStateUtils.isHidden((String)name)) continue;
            if (ps.isArray()) {
                Value[] values = new Value[ps.count()];
                for (int i = 0; i < ps.count(); ++i) {
                    values[i] = NodeStateCopyUtils.createValue(vf, ps, i);
                }
                node.setProperty(name, values, ps.getType().tag());
                continue;
            }
            node.setProperty(name, NodeStateCopyUtils.createValue(vf, ps, -1), ps.getType().tag());
        }
    }

    private static Value createValue(ValueFactory vf, PropertyState ps, int index) throws RepositoryException {
        switch (ps.getType().tag()) {
            case 1: {
                return vf.createValue((String)NodeStateCopyUtils.getValue(ps, Type.STRING, index));
            }
            case 2: {
                Blob blob = (Blob)NodeStateCopyUtils.getValue(ps, Type.BINARY, index);
                Binary bin = vf.createBinary(blob.getNewStream());
                return vf.createValue(bin);
            }
            case 3: {
                return vf.createValue(((Long)NodeStateCopyUtils.getValue(ps, Type.LONG, index)).longValue());
            }
            case 4: {
                return vf.createValue(((Double)NodeStateCopyUtils.getValue(ps, Type.DOUBLE, index)).doubleValue());
            }
            case 5: {
                return vf.createValue((String)NodeStateCopyUtils.getValue(ps, Type.DATE, index));
            }
            case 6: {
                return vf.createValue(((Boolean)NodeStateCopyUtils.getValue(ps, Type.BOOLEAN, index)).booleanValue());
            }
            case 7: {
                return vf.createValue((String)NodeStateCopyUtils.getValue(ps, Type.NAME, index));
            }
            case 8: {
                return vf.createValue((String)NodeStateCopyUtils.getValue(ps, Type.PATH, index));
            }
            case 9: {
                return vf.createValue((String)NodeStateCopyUtils.getValue(ps, Type.REFERENCE, index));
            }
            case 10: {
                return vf.createValue((String)NodeStateCopyUtils.getValue(ps, Type.WEAKREFERENCE, index));
            }
            case 11: {
                return vf.createValue((String)NodeStateCopyUtils.getValue(ps, Type.URI, index));
            }
            case 12: {
                return vf.createValue((BigDecimal)NodeStateCopyUtils.getValue(ps, Type.DECIMAL, index));
            }
        }
        throw new IllegalStateException("Unsupported type " + ps.getType());
    }

    private static <T> T getValue(PropertyState ps, Type<T> type, int index) {
        return (T)(index < 0 ? ps.getValue(type) : ps.getValue(type, index));
    }

    private static String primaryType(NodeState state) {
        return Objects.requireNonNull(state.getName("jcr:primaryType"), String.format("jcr:primaryType not defined for %s", state));
    }
}

