/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetsConfigProvider;
import org.apache.jackrabbit.oak.plugins.index.search.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.search.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.spi.binary.FulltextBinaryTextExtractor;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextDocumentMaker;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneDocumentMaker
extends FulltextDocumentMaker<Document> {
    private static final Logger log = LoggerFactory.getLogger(LuceneDocumentMaker.class);
    private final FacetsConfigProvider facetsConfigProvider;
    private final IndexAugmentorFactory augmentorFactory;

    public LuceneDocumentMaker(IndexDefinition definition, IndexDefinition.IndexingRule indexingRule, String path) {
        this(null, null, null, definition, indexingRule, path);
    }

    public LuceneDocumentMaker(@Nullable FulltextBinaryTextExtractor textExtractor, @Nullable FacetsConfigProvider facetsConfigProvider, @Nullable IndexAugmentorFactory augmentorFactory, IndexDefinition definition, IndexDefinition.IndexingRule indexingRule, String path) {
        super(textExtractor, definition, indexingRule, path);
        this.facetsConfigProvider = facetsConfigProvider;
        this.augmentorFactory = augmentorFactory;
    }

    @Override
    protected void indexAnalyzedProperty(Document doc, String pname, String value, PropertyDefinition pd) {
        String analyzedPropName = this.constructAnalyzedPropertyName(pname);
        doc.add(FieldFactory.newPropertyField(analyzedPropName, value, !pd.skipTokenization(pname), pd.stored));
    }

    @Override
    protected void indexSuggestValue(Document doc, String value) {
        doc.add(FieldFactory.newSuggestField(value));
    }

    @Override
    protected void indexSpellcheckValue(Document doc, String value) {
        doc.add(FieldFactory.newPropertyField(":spellcheck", value, true, false));
    }

    @Override
    protected void indexFulltextValue(Document doc, String value) {
        doc.add(FieldFactory.newFulltextField(value));
    }

    @Override
    protected void indexAncestors(Document doc, String path) {
        doc.add(FieldFactory.newAncestorsField(PathUtils.getParentPath((String)path)));
        doc.add(FieldFactory.newDepthField(path));
    }

    @Override
    protected boolean indexTypedProperty(Document doc, PropertyState property, String pname, PropertyDefinition pd) {
        int tag = property.getType().tag();
        boolean fieldAdded = false;
        for (int i = 0; i < property.count(); ++i) {
            Field f;
            if (tag == Type.LONG.tag()) {
                f = new LongField(pname, (long)((Long)property.getValue(Type.LONG, i)), Field.Store.NO);
            } else if (tag == Type.DATE.tag()) {
                String date = (String)property.getValue(Type.DATE, i);
                f = new LongField(pname, (long)FieldFactory.dateToLong(date), Field.Store.NO);
            } else {
                f = tag == Type.DOUBLE.tag() ? new DoubleField(pname, (double)((Double)property.getValue(Type.DOUBLE, i)), Field.Store.NO) : (tag == Type.BOOLEAN.tag() ? new StringField(pname, ((Boolean)property.getValue(Type.BOOLEAN, i)).toString(), Field.Store.NO) : new StringField(pname, (String)property.getValue(Type.STRING, i), Field.Store.NO));
            }
            if (!this.includePropertyValue(property, i, pd)) continue;
            doc.add(f);
            fieldAdded = true;
        }
        return fieldAdded;
    }

    @Override
    protected void indexNotNullProperty(Document doc, PropertyDefinition pd) {
        doc.add(new StringField(":notNullProps", pd.name, Field.Store.NO));
    }

    @Override
    protected void indexNullProperty(Document doc, PropertyDefinition pd) {
        doc.add(new StringField(":nullProps", pd.name, Field.Store.NO));
    }

    private String constructAnalyzedPropertyName(String pname) {
        if (this.definition.getVersion().isAtLeast(IndexFormatVersion.V2)) {
            return FieldNames.createAnalyzedFieldName(pname);
        }
        return pname;
    }

    @Override
    protected boolean addBinary(Document doc, String path, List<String> binaryValues) {
        boolean added = false;
        for (String binaryValue : binaryValues) {
            if (path != null) {
                doc.add(FieldFactory.newFulltextField(path, binaryValue, true));
            } else {
                doc.add(FieldFactory.newFulltextField(binaryValue, true));
            }
            added = true;
        }
        return added;
    }

    @Override
    protected boolean indexFacetProperty(Document doc, int tag, PropertyState property, String pname) {
        String facetFieldName = FieldNames.createFacetFieldName(pname);
        this.getFacetsConfig().setIndexFieldName(pname, facetFieldName);
        boolean fieldAdded = false;
        try {
            String value;
            if (tag == Type.STRINGS.tag() && property.isArray()) {
                this.getFacetsConfig().setMultiValued(pname, true);
                Iterable values = (Iterable)property.getValue(Type.STRINGS);
                for (String value2 : values) {
                    if (value2 == null || value2.length() <= 0) continue;
                    doc.add(new SortedSetDocValuesFacetField(pname, value2));
                }
                fieldAdded = true;
            } else if (tag == Type.STRING.tag() && (value = (String)property.getValue(Type.STRING)).length() > 0) {
                doc.add(new SortedSetDocValuesFacetField(pname, value));
                fieldAdded = true;
            }
        }
        catch (Throwable e) {
            log.warn("[{}] Ignoring facet property. Could not convert property {} of type {} to type {} for path {}", new Object[]{this.getIndexName(), pname, Type.fromTag((int)property.getType().tag(), (boolean)false), Type.fromTag((int)tag, (boolean)false), this.path, e});
        }
        return fieldAdded;
    }

    @Override
    protected void indexAggregateValue(Document doc, Aggregate.NodeIncludeResult result, String value, PropertyDefinition pd) {
        Field field;
        Field field2 = field = result.isRelativeNode() ? FieldFactory.newFulltextField(result.rootIncludePath, value) : FieldFactory.newFulltextField(value);
        if (pd != null) {
            field.setBoost(pd.boost);
        }
        doc.add(field);
    }

    @Override
    protected Document initDoc() {
        Document doc = new Document();
        doc.add(FieldFactory.newPathField(this.path));
        return doc;
    }

    @Override
    protected boolean augmentCustomFields(String path, Document doc, NodeState document) {
        boolean dirty = false;
        if (this.augmentorFactory != null) {
            Iterable<Field> augmentedFields = this.augmentorFactory.getIndexFieldProvider(this.indexingRule.getNodeTypeName()).getAugmentedFields(path, document, this.definition.getDefinitionNodeState());
            for (Field field : augmentedFields) {
                doc.add(field);
                dirty = true;
            }
        }
        return dirty;
    }

    @Override
    protected Document finalizeDoc(Document doc, boolean dirty, boolean facet) throws IOException {
        if (facet && this.isFacetingEnabled()) {
            doc = this.getFacetsConfig().build(doc);
        }
        List<IndexableField> fields = doc.getFields();
        Field suggestField = null;
        for (IndexableField f : fields) {
            if (!":suggest".equals(f.name())) continue;
            if (suggestField == null) {
                suggestField = FieldFactory.newSuggestField(f.stringValue());
                continue;
            }
            suggestField = FieldFactory.newSuggestField(suggestField.stringValue(), f.stringValue());
        }
        doc.removeFields(":suggest");
        if (suggestField != null) {
            doc.add(suggestField);
        }
        return doc;
    }

    @Override
    protected boolean isFacetingEnabled() {
        return this.facetsConfigProvider != null;
    }

    @Override
    protected boolean indexTypeOrderedFields(Document doc, String pname, int tag, PropertyState property, PropertyDefinition pd) {
        String name = FieldNames.createDocValFieldName(pname);
        boolean fieldAdded = false;
        Field f = null;
        try {
            if (tag == Type.LONG.tag()) {
                f = new NumericDocValuesField(name, (Long)property.getValue(Type.LONG));
            } else if (tag == Type.DATE.tag()) {
                String date = (String)property.getValue(Type.DATE);
                f = new NumericDocValuesField(name, FieldFactory.dateToLong(date));
            } else if (tag == Type.DOUBLE.tag()) {
                f = new DoubleDocValuesField(name, (Double)property.getValue(Type.DOUBLE));
            } else if (tag == Type.BOOLEAN.tag()) {
                f = new SortedDocValuesField(name, new BytesRef(((Boolean)property.getValue(Type.BOOLEAN)).toString()));
            } else if (tag == Type.STRING.tag()) {
                f = new SortedDocValuesField(name, new BytesRef((CharSequence)property.getValue(Type.STRING)));
            }
            if (f != null && this.includePropertyValue(property, 0, pd)) {
                doc.add(f);
                fieldAdded = true;
            }
        }
        catch (Exception e) {
            log.warn("[{}] Ignoring ordered property. Could not convert property {} of type {} to type {} for path {}", new Object[]{this.getIndexName(), pname, Type.fromTag((int)property.getType().tag(), (boolean)false), Type.fromTag((int)tag, (boolean)false), this.path, e});
        }
        return fieldAdded;
    }

    private FacetsConfig getFacetsConfig() {
        return this.facetsConfigProvider.getFacetsConfig();
    }

    @Override
    protected void indexNodeName(Document doc, String value) {
        doc.add(new StringField(":nodeName", value, Field.Store.NO));
    }

    @Override
    protected void indexSimilarityStrings(Document doc, PropertyDefinition pd, String value) throws IOException {
        for (Field f : FieldFactory.newSimilarityFields(pd.name, value)) {
            doc.add(f);
        }
        if (pd.similarityRerank) {
            for (Field f : FieldFactory.newBinSimilarityFields(pd.name, value)) {
                doc.add(f);
            }
        }
    }

    @Override
    protected void indexSimilarityBinaries(Document doc, PropertyDefinition pd, Blob blob) throws IOException {
        for (Field f : FieldFactory.newSimilarityFields(pd.name, blob)) {
            doc.add(f);
        }
        if (pd.similarityRerank) {
            for (Field f : FieldFactory.newBinSimilarityFields(pd.name, blob)) {
                doc.add(f);
            }
        }
    }
}

