/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexMeta;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.IndexRootDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LocalIndexDir;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;

public class DirectoryUtils {
    public static long getFileLength(Directory dir, String fileName) {
        try {
            if (dir.fileExists(fileName)) {
                return dir.fileLength(fileName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public static long dirSize(Directory directory) throws IOException {
        long totalFileSize = 0L;
        if (directory == null) {
            return -1L;
        }
        String[] files = directory.listAll();
        if (files == null) {
            return totalFileSize;
        }
        for (String file : files) {
            totalFileSize += directory.fileLength(file);
        }
        return totalFileSize;
    }

    public static File createIndexDir(File baseDir, String indexPath) throws IOException {
        File indexDir;
        String subDirPath = IndexRootDirectory.getIndexFolderBaseName(indexPath);
        IndexRootDirectory rootDir = new IndexRootDirectory(baseDir, false);
        List<LocalIndexDir> existingDirs = rootDir.getLocalIndexes(indexPath);
        if (existingDirs.isEmpty()) {
            indexDir = new File(baseDir, subDirPath);
            int count = 0;
            while (indexDir.exists()) {
                indexDir = new File(baseDir, subDirPath + "_" + count++);
            }
            FileUtils.forceMkdir((File)indexDir);
        } else {
            indexDir = existingDirs.get((int)0).dir;
        }
        return indexDir;
    }

    public static int getNumDocs(Directory dir) throws IOException {
        int count = 0;
        SegmentInfos sis = new SegmentInfos();
        sis.read(dir);
        for (SegmentCommitInfo sci : sis) {
            count += sci.info.getDocCount() - sci.getDelCount();
        }
        return count;
    }

    static File createSubDir(File indexDir, String name) throws IOException {
        String fsSafeName = name.replace(":", "");
        File dir = new File(indexDir, fsSafeName);
        FileUtils.forceMkdir((File)dir);
        return dir;
    }

    static void writeMeta(File indexDir, IndexMeta meta) throws IOException {
        File readMe = new File(indexDir, "index-details.txt");
        meta.writeTo(readMe);
    }
}

