/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.directory;

import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.BlobFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.OakIndexFile;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;

final class OakIndexOutput
extends IndexOutput {
    private final String dirDetails;
    final OakIndexFile file;

    public OakIndexOutput(String name, NodeBuilder file, String dirDetails, BlobFactory blobFactory, boolean streamingWriteEnabled) throws IOException {
        this.dirDetails = dirDetails;
        this.file = OakIndexFile.getOakIndexFile(name, file, dirDetails, blobFactory, streamingWriteEnabled);
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long getFilePointer() {
        return this.file.position();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        try {
            this.file.writeBytes(b, offset, length);
        }
        catch (IOException e) {
            throw this.wrapWithDetails(e);
        }
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.writeBytes(new byte[]{b}, 0, 1);
    }

    @Override
    public void copyBytes(DataInput input, long numBytes) throws IOException {
        if (this.file.supportsCopyFromDataInput()) {
            this.file.copyBytes(input, numBytes);
        } else {
            super.copyBytes(input, numBytes);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.file.flush();
        }
        catch (IOException e) {
            throw this.wrapWithDetails(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.file.close();
    }

    private IOException wrapWithDetails(IOException e) {
        String msg = String.format("Error occurred while writing to blob [%s][%s]", this.dirDetails, this.file.getName());
        return new IOException(msg, e);
    }
}

