/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.hybrid;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalProperty;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexedPathInfo;

class IndexedPaths
implements JournalProperty,
Iterable<IndexedPathInfo> {
    private final Multimap<String, String> indexedPaths;

    public IndexedPaths(Multimap<String, String> indexedPaths) {
        this.indexedPaths = (Multimap)Preconditions.checkNotNull(indexedPaths);
    }

    @Override
    public Iterator<IndexedPathInfo> iterator() {
        return Iterators.transform(this.indexedPaths.asMap().entrySet().iterator(), (Function)new Function<Map.Entry<String, Collection<String>>, IndexedPathInfo>(){

            public IndexedPathInfo apply(final Map.Entry<String, Collection<String>> input) {
                return new IndexedPathInfo(){

                    @Override
                    public String getPath() {
                        return (String)input.getKey();
                    }

                    @Override
                    public Iterable<String> getIndexPaths() {
                        return (Iterable)input.getValue();
                    }
                };
            }
        });
    }

    public String toString() {
        return this.indexedPaths.toString();
    }

    public boolean isEmpty() {
        return this.indexedPaths.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedPaths that = (IndexedPaths)o;
        return this.indexedPaths.equals(that.indexedPaths);
    }

    public int hashCode() {
        return 0;
    }
}

