/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.sortedset.DefaultSortedSetDocValuesReaderState;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetCounts;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.jetbrains.annotations.NotNull;

class FilteredSortedSetDocValuesFacetCounts
extends SortedSetDocValuesFacetCounts {
    private final TopDocs docs;
    private final Filter filter;
    private final IndexReader reader;
    private final SortedSetDocValuesReaderState state;

    public FilteredSortedSetDocValuesFacetCounts(DefaultSortedSetDocValuesReaderState state, FacetsCollector facetsCollector, Filter filter, TopDocs docs) throws IOException {
        super(state, facetsCollector);
        this.reader = state.origReader;
        this.filter = filter;
        this.docs = docs;
        this.state = state;
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        FacetResult topChildren = super.getTopChildren(topN, dim, path);
        if (topChildren == null) {
            return null;
        }
        LabelAndValue[] labelAndValues = topChildren.labelValues;
        InaccessibleFacetCountManager inaccessibleFacetCountManager = new InaccessibleFacetCountManager();
        for (ScoreDoc scoreDoc : this.docs.scoreDocs) {
            labelAndValues = this.filterFacet(scoreDoc.doc, dim, labelAndValues, inaccessibleFacetCountManager);
        }
        int childCount = labelAndValues.length;
        Number value = 0;
        for (LabelAndValue lv : labelAndValues) {
            value = ((Number)value).longValue() + lv.value.longValue();
        }
        return new FacetResult(dim, path, value, labelAndValues, childCount);
    }

    private LabelAndValue[] filterFacet(int docId, String dimension, LabelAndValue[] labelAndValues, InaccessibleFacetCountManager inaccessibleFacetCountManager) throws IOException {
        Document document = this.reader.document(docId);
        if (!this.filter.isAccessible(document.getField(":path").stringValue() + "/" + dimension)) {
            SortedSetDocValues docValues = this.state.getDocValues();
            docValues.setDocument(docId);
            TermsEnum termsEnum = docValues.termsEnum();
            long ord = docValues.nextOrd();
            while (ord != -1L) {
                termsEnum.seekExact(ord);
                String facetDVTerm = termsEnum.term().utf8ToString();
                String[] facetDVDimPaths = FacetsConfig.stringToPath(facetDVTerm);
                for (int i = 1; i < facetDVDimPaths.length; ++i) {
                    inaccessibleFacetCountManager.markInaccessbile(facetDVDimPaths[i]);
                }
                ord = docValues.nextOrd();
            }
        }
        return inaccessibleFacetCountManager.updateLabelAndValue(labelAndValues);
    }

    static class InaccessibleFacetCountManager {
        Map<String, Long> inaccessbileCounts = Maps.newHashMap();

        InaccessibleFacetCountManager() {
        }

        void markInaccessbile(@NotNull String label) {
            Long count = this.inaccessbileCounts.get(label);
            if (count == null) {
                count = 1L;
            } else {
                Long l = count;
                Long l2 = count = Long.valueOf(count - 1L);
            }
            this.inaccessbileCounts.put(label, count);
        }

        LabelAndValue[] updateLabelAndValue(LabelAndValue[] currentLabels) {
            LabelAndValue[] newValues;
            int i;
            int numZeros = 0;
            for (i = 0; i < currentLabels.length; ++i) {
                LabelAndValue lv = currentLabels[i];
                Long inaccessibleCount = this.inaccessbileCounts.get(lv.label);
                if (inaccessibleCount == null) continue;
                long newValue = lv.value.longValue() - inaccessibleCount;
                if (newValue <= 0L) {
                    newValue = 0L;
                    ++numZeros;
                }
                currentLabels[i] = new LabelAndValue(lv.label, newValue);
            }
            if (numZeros > 0) {
                newValues = new LabelAndValue[currentLabels.length - numZeros];
                i = 0;
                for (LabelAndValue lv : currentLabels) {
                    if (lv.value.longValue() <= 0L) continue;
                    newValues[i++] = lv;
                }
            } else {
                newValues = currentLabels;
            }
            return newValues;
        }
    }
}

