/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search;

import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.search.util.NodeStateCloner;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ReindexOperations {
    private final NodeState root;
    private final NodeBuilder definitionBuilder;
    private final String indexPath;
    private final IndexDefinition.Builder indexDefBuilder;

    public ReindexOperations(NodeState root, NodeBuilder definitionBuilder, String indexPath, IndexDefinition.Builder indexDefBuilder) {
        this.root = root;
        this.definitionBuilder = definitionBuilder;
        this.indexPath = indexPath;
        this.indexDefBuilder = indexDefBuilder;
    }

    public IndexDefinition apply(boolean useStateFromBuilder) {
        NodeState defnState;
        IndexFormatVersion version = IndexDefinition.determineVersionForFreshIndex(this.definitionBuilder);
        this.definitionBuilder.setProperty(":version", (Object)version.getVersion());
        NodeState nodeState = defnState = useStateFromBuilder ? this.definitionBuilder.getNodeState() : this.definitionBuilder.getBaseState();
        if (!IndexDefinition.isDisableStoredIndexDefinition()) {
            this.definitionBuilder.setChildNode(":index-definition", NodeStateCloner.cloneVisibleState(defnState));
        }
        String uid = FulltextIndexEditorContext.configureUniqueId(this.definitionBuilder);
        return this.indexDefBuilder.root(this.root).defn(defnState).indexPath(this.indexPath).version(version).uid(uid).reindex().build();
    }
}

