/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.search.spi.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.search.BadIndexTracker;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.search.spi.query.IndexNodeManager;
import org.apache.jackrabbit.oak.plugins.index.search.util.IndexHelper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.SubtreeEditor;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FulltextIndexTracker {
    private static final Logger log = LoggerFactory.getLogger(FulltextIndexTracker.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(FulltextIndexTracker.class.getName() + ".perf")));
    private final BadIndexTracker badIndexTracker = new BadIndexTracker();
    private NodeState root = EmptyNodeState.EMPTY_NODE;
    private AsyncIndexInfoService asyncIndexInfoService;
    private volatile Map<String, IndexNodeManager> indices = Collections.emptyMap();
    private volatile boolean refresh;

    protected abstract IndexNodeManager openIndex(String var1, NodeState var2, NodeState var3);

    synchronized void close() {
        Map<String, IndexNodeManager> indices = this.indices;
        this.indices = Collections.emptyMap();
        for (Map.Entry<String, IndexNodeManager> entry : indices.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Failed to close the Lucene index at " + entry.getKey(), (Throwable)e);
            }
        }
    }

    public synchronized void update(NodeState root) {
        if (this.refresh) {
            this.root = root;
            this.close();
            this.refresh = false;
            log.info("Refreshed the opened indexes");
        } else {
            this.diffAndUpdate(root);
        }
    }

    public void setAsyncIndexInfoService(AsyncIndexInfoService asyncIndexInfoService) {
        this.asyncIndexInfoService = asyncIndexInfoService;
    }

    AsyncIndexInfoService getAsyncIndexInfoService() {
        return this.asyncIndexInfoService;
    }

    private synchronized void diffAndUpdate(final NodeState root) {
        if (this.asyncIndexInfoService != null && !this.asyncIndexInfoService.hasIndexerUpdatedForAnyLane(this.root, root)) {
            log.trace("No changed detected in async indexer state. Skipping further diff");
            this.root = root;
            return;
        }
        Map<String, IndexNodeManager> original = this.indices;
        final HashMap updates = Maps.newHashMap();
        HashSet indexPaths = Sets.newHashSet();
        indexPaths.addAll(original.keySet());
        indexPaths.addAll(this.badIndexTracker.getIndexPaths());
        ArrayList editors = Lists.newArrayListWithCapacity((int)indexPaths.size());
        for (final String path : indexPaths) {
            editors.add(new SubtreeEditor((Editor)new DefaultEditor(){

                public void leave(NodeState before, NodeState after) {
                    try {
                        if (FulltextIndexTracker.isStatusChanged(before, after) || FulltextIndexTracker.isIndexDefinitionChanged(before, after)) {
                            long start = PERF_LOGGER.start();
                            IndexNodeManager index = FulltextIndexTracker.this.openIndex(path, root, after);
                            PERF_LOGGER.end(start, -1L, "[{}] Index found to be updated. Reopening the IndexNode", (Object)path);
                            updates.put(path, index);
                        }
                    }
                    catch (Exception e) {
                        FulltextIndexTracker.this.badIndexTracker.markBadPersistedIndex(path, e);
                    }
                }
            }, (String[])Iterables.toArray((Iterable)PathUtils.elements((String)path), String.class)));
        }
        EditorDiff.process((Editor)CompositeEditor.compose((Collection)editors), (NodeState)this.root, (NodeState)root);
        this.root = root;
        if (!updates.isEmpty()) {
            this.indices = ImmutableMap.builder().putAll(Maps.filterKeys(original, (Predicate)Predicates.not((Predicate)Predicates.in(updates.keySet())))).putAll(Maps.filterValues((Map)updates, (Predicate)Predicates.notNull())).build();
            this.badIndexTracker.markGoodIndexes(updates.keySet());
            for (final String path : updates.keySet()) {
                IndexNodeManager index = original.get(path);
                try {
                    if (index == null) continue;
                    index.close();
                }
                catch (IOException e) {
                    log.error("Failed to close Lucene index at " + path, (Throwable)e);
                }
            }
        }
    }

    void refresh() {
        log.info("Marked tracker to refresh upon next cycle");
        this.refresh = true;
    }

    public IndexNode acquireIndexNode(String path, String type) {
        IndexNode indexNode;
        IndexNodeManager index = this.indices.get(path);
        IndexNode indexNode2 = indexNode = index != null ? index.acquire() : null;
        if (indexNode != null) {
            return indexNode;
        }
        return this.findIndexNode(path, type);
    }

    @Nullable
    public IndexDefinition getIndexDefinition(String indexPath) {
        IndexNodeManager node = this.indices.get(indexPath);
        if (node != null) {
            return node.getDefinition();
        }
        return null;
    }

    Set<String> getIndexNodePaths() {
        return this.indices.keySet();
    }

    BadIndexTracker getBadIndexTracker() {
        return this.badIndexTracker;
    }

    NodeState getRoot() {
        return this.root;
    }

    private synchronized IndexNode findIndexNode(String path, String type) {
        IndexNodeManager index = this.indices.get(path);
        if (index != null) {
            IndexNode indexNode = index.acquire();
            return (IndexNode)Preconditions.checkNotNull((Object)indexNode);
        }
        if (this.badIndexTracker.isIgnoredBadIndex(path)) {
            return null;
        }
        NodeState node = this.root;
        for (String name : PathUtils.elements((String)path)) {
            node = node.getChildNode(name);
        }
        try {
            if (IndexHelper.isIndexNodeOfType(node, type)) {
                index = this.openIndex(path, this.root, node);
                if (index != null) {
                    IndexNode indexNode = index.acquire();
                    Preconditions.checkNotNull((Object)indexNode);
                    this.indices = ImmutableMap.builder().putAll(this.indices).put((Object)path, (Object)index).build();
                    this.badIndexTracker.markGoodIndex(path);
                    return indexNode;
                }
            } else if (node.exists()) {
                log.warn("Cannot open Index at path {} as the index is not of type {}", (Object)path, (Object)type);
            }
        }
        catch (Throwable e) {
            this.badIndexTracker.markBadIndexForRead(path, e);
        }
        return null;
    }

    private static boolean isStatusChanged(NodeState before, NodeState after) {
        return !EqualsDiff.equals((NodeState)before.getChildNode(":status"), (NodeState)after.getChildNode(":status"));
    }

    private static boolean isIndexDefinitionChanged(NodeState before, NodeState after) {
        return !EqualsDiff.equals((NodeState)before.getChildNode(":index-definition"), (NodeState)after.getChildNode(":index-definition"));
    }
}

