/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.server.Request;
import org.apache.jackrabbit.mk.server.Response;
import org.apache.jackrabbit.mk.util.IOUtils;
import org.apache.jackrabbit.mk.util.MicroKernelInputStream;

class MicroKernelServlet {
    public static MicroKernelServlet INSTANCE = new MicroKernelServlet();
    private static final Map<String, Command> COMMANDS = new HashMap<String, Command>();

    private MicroKernelServlet() {
    }

    public void service(MicroKernel mk, Request request, Response response) throws IOException {
        Command command;
        String file = request.getFile();
        int dotIndex = file.indexOf(46);
        if (dotIndex == -1) {
            dotIndex = file.length();
        }
        if ((command = COMMANDS.get(file.substring(1, dotIndex))) != null && mk != null) {
            try {
                command.execute(mk, request, response);
            }
            catch (MicroKernelException e) {
                response.setStatusCode(500);
                response.setContentType("text/plain");
                e.printStackTrace(new PrintStream(response.getOutputStream()));
            }
            catch (Throwable e) {
                response.setStatusCode(500);
                response.setContentType("text/plain");
                e.printStackTrace(new PrintStream(response.getOutputStream()));
            }
            return;
        }
        response.setStatusCode(404);
    }

    static {
        COMMANDS.put("getHeadRevision", new GetHeadRevision());
        COMMANDS.put("checkpoint", new Checkpoint());
        COMMANDS.put("getRevisionHistory", new GetRevisionHistory());
        COMMANDS.put("waitForCommit", new WaitForCommit());
        COMMANDS.put("getJournal", new GetJournal());
        COMMANDS.put("diff", new Diff());
        COMMANDS.put("nodeExists", new NodeExists());
        COMMANDS.put("getChildNodeCount", new GetChildNodeCount());
        COMMANDS.put("getNodes", new GetNodes());
        COMMANDS.put("commit", new Commit());
        COMMANDS.put("branch", new Branch());
        COMMANDS.put("merge", new Merge());
        COMMANDS.put("reset", new Reset());
        COMMANDS.put("getLength", new GetLength());
        COMMANDS.put("read", new Read());
        COMMANDS.put("write", new Write());
    }

    static class Write
    implements Command {
        Write() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            InputStream in = request.getFileParameter("file");
            String blobId = mk.write(in);
            response.setContentType("text/plain");
            response.write(blobId);
        }
    }

    static class Read
    implements Command {
        Read() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String blobId = request.getParameter("blob_id", "");
            long pos = request.getParameter("pos", 0L);
            int length = request.getParameter("length", -1);
            if (request.getUserAgent() == null) {
                response.setContentType("application/octet-stream");
            }
            OutputStream out = response.getOutputStream();
            if (pos == 0L && length == -1) {
                MicroKernelInputStream in = new MicroKernelInputStream(mk, blobId);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            } else {
                byte[] buff = new byte[length];
                int count = mk.read(blobId, pos, buff, 0, length);
                if (count > 0) {
                    out.write(buff, 0, count);
                }
            }
        }
    }

    static class GetLength
    implements Command {
        GetLength() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String blobId = request.getParameter("blob_id", "");
            long length = mk.getLength(blobId);
            response.setContentType("text/plain");
            response.write(Long.toString(length));
        }
    }

    static class Reset
    implements Command {
        Reset() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String branchRevisionId = request.getParameter("branch_revision_id");
            String ancestorRevisionId = request.getParameter("ancestor_revision_id");
            String newRevision = mk.reset(branchRevisionId, ancestorRevisionId);
            response.setContentType("test/plain");
            response.write(newRevision);
        }
    }

    static class Merge
    implements Command {
        Merge() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String branchRevisionId = request.getParameter("branch_revision_id");
            String message = request.getParameter("message");
            String newRevision = mk.merge(branchRevisionId, message);
            response.setContentType("text/plain");
            response.write(newRevision);
        }
    }

    static class Branch
    implements Command {
        Branch() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String headRevision = mk.getHeadRevision();
            String trunkRevisionId = request.getParameter("trunk_revision_id", headRevision);
            String newRevision = mk.branch(trunkRevisionId);
            response.setContentType("text/plain");
            response.write(newRevision);
        }
    }

    static class Commit
    implements Command {
        Commit() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String headRevision = mk.getHeadRevision();
            String path = request.getParameter("path", "/");
            String jsonDiff = request.getParameter("json_diff");
            String revisionId = request.getParameter("revision_id", headRevision);
            String message = request.getParameter("message");
            String newRevision = mk.commit(path, jsonDiff, revisionId, message);
            response.setContentType("text/plain");
            response.write(newRevision);
        }
    }

    static class GetNodes
    implements Command {
        GetNodes() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String headRevision = mk.getHeadRevision();
            String path = request.getParameter("path", "/");
            String revisionId = request.getParameter("revision_id", headRevision);
            int depth = request.getParameter("depth", 1);
            long offset = request.getParameter("offset", 0L);
            int maxChildNodes = request.getParameter("max_child_nodes", -1);
            String filter = request.getParameter("filter", "");
            response.setContentType("application/json");
            String json = mk.getNodes(path, revisionId, depth, offset, maxChildNodes, filter);
            if (json == null) {
                json = "null";
            }
            if (request.getUserAgent() != null) {
                json = JsopBuilder.prettyPrint((String)json);
            }
            response.write(json);
        }
    }

    static class GetChildNodeCount
    implements Command {
        GetChildNodeCount() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String headRevision = mk.getHeadRevision();
            String path = request.getParameter("path", "/");
            String revisionId = request.getParameter("revision_id", headRevision);
            response.setContentType("text/plain");
            response.write(Long.toString(mk.getChildNodeCount(path, revisionId)));
        }
    }

    static class NodeExists
    implements Command {
        NodeExists() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String headRevision = mk.getHeadRevision();
            String path = request.getParameter("path", "/");
            String revisionId = request.getParameter("revision_id", headRevision);
            response.setContentType("text/plain");
            response.write(Boolean.toString(mk.nodeExists(path, revisionId)));
        }
    }

    static class Diff
    implements Command {
        Diff() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String headRevision = mk.getHeadRevision();
            String fromRevisionId = request.getParameter("from_revision_id", headRevision);
            String toRevisionId = request.getParameter("to_revision_id", headRevision);
            String path = request.getParameter("path", "");
            int depth = request.getParameter("depth", 1);
            response.setContentType("text/plain");
            String json = mk.diff(fromRevisionId, toRevisionId, path, depth);
            if (request.getUserAgent() != null) {
                json = JsopBuilder.prettyPrint((String)json);
            }
            response.write(json);
        }
    }

    static class GetJournal
    implements Command {
        GetJournal() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String headRevision = mk.getHeadRevision();
            String fromRevisionId = request.getParameter("from_revision_id", headRevision);
            String toRevisionId = request.getParameter("to_revision_id", headRevision);
            String path = request.getParameter("path", "");
            response.setContentType("application/json");
            String json = mk.getJournal(fromRevisionId, toRevisionId, path);
            if (request.getUserAgent() != null) {
                json = JsopBuilder.prettyPrint((String)json);
            }
            response.write(json);
        }
    }

    static class WaitForCommit
    implements Command {
        WaitForCommit() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            String currentHead;
            String headRevision = mk.getHeadRevision();
            String oldHead = request.getParameter("revision_id", headRevision);
            long maxWaitMillis = request.getParameter("max_wait_millis", 0L);
            try {
                currentHead = mk.waitForCommit(oldHead, maxWaitMillis);
            }
            catch (InterruptedException e) {
                throw new MicroKernelException((Throwable)e);
            }
            response.setContentType("text/plain");
            response.write(currentHead == null ? "null" : currentHead);
        }
    }

    static class GetRevisionHistory
    implements Command {
        GetRevisionHistory() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            long since = request.getParameter("since", 0L);
            int maxEntries = request.getParameter("max_entries", 10);
            String path = request.getParameter("path", "");
            response.setContentType("application/json");
            String json = mk.getRevisionHistory(since, maxEntries, path);
            if (request.getUserAgent() != null) {
                json = JsopBuilder.prettyPrint((String)json);
            }
            response.write(json);
        }
    }

    static class Checkpoint
    implements Command {
        Checkpoint() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            long lifetime = request.getParameter("lifetime", 1000L);
            response.setContentType("text/plain");
            response.write(mk.checkpoint(lifetime));
        }
    }

    static class GetHeadRevision
    implements Command {
        GetHeadRevision() {
        }

        @Override
        public void execute(MicroKernel mk, Request request, Response response) throws IOException, MicroKernelException {
            response.setContentType("text/plain");
            response.write(mk.getHeadRevision());
        }
    }

    private static interface Command {
        public void execute(MicroKernel var1, Request var2, Response var3) throws IOException, MicroKernelException;
    }
}

