/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.remote.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final byte[] LAST_CHUNK = "0000\r\n\r\n".getBytes();
    private final byte[] prefix = new byte[4];
    private final byte[] data;
    private int offset;

    public ChunkedOutputStream(OutputStream out, int size) {
        super(out);
        if (size < 1 || size > 0x100000) {
            String msg = "Chunk size smaller than 1 or bigger than 1048576";
            throw new IllegalArgumentException(msg);
        }
        this.data = new byte[size];
    }

    public ChunkedOutputStream(OutputStream out) {
        this(out, 0x100000);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.offset == this.data.length) {
            this.writeChunk();
        }
        this.data[this.offset++] = (byte)(b & 0xFF);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int written = 0;
        while (written < len) {
            if (this.offset == this.data.length) {
                this.writeChunk();
            }
            int available = Math.min(len - written, this.data.length - this.offset);
            System.arraycopy(b, off + written, this.data, this.offset, available);
            written += available;
            this.offset += available;
        }
    }

    private void writeChunk() throws IOException {
        ChunkedOutputStream.toHexString(this.offset, this.prefix);
        this.out.write(this.prefix);
        this.out.write(CRLF);
        this.out.write(this.data, 0, this.offset);
        this.out.write(CRLF);
        this.offset = 0;
    }

    private static void toHexString(int n, byte[] b) {
        for (int i = b.length - 1; i >= 0; --i) {
            int c = n & 0xF;
            c = c >= 0 && c <= 9 ? (c += 48) : (c += 55);
            b[i] = (byte)c;
            n >>= 4;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.offset > 0) {
            this.writeChunk();
        }
        super.flush();
    }

    public void recycle(OutputStream out) {
        this.out = out;
        this.offset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        try {
            if (this.offset > 0) {
                this.writeChunk();
            }
            this.out.write(LAST_CHUNK);
        }
        finally {
            this.out = null;
        }
    }
}

