/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.SocketFactory;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.client.HttpExecutor;
import org.apache.jackrabbit.mk.client.Request;
import org.apache.jackrabbit.mk.util.IOUtils;

public class Client
implements MicroKernel {
    private static final String MK_EXCEPTION_PREFIX = MicroKernelException.class.getName() + ":";
    private final InetSocketAddress addr;
    private final SocketFactory socketFactory;
    private final AtomicBoolean disposed = new AtomicBoolean();
    private HttpExecutor executor;

    private static InetSocketAddress getAddress(String url) {
        try {
            URI uri = new URI(url);
            return new InetSocketAddress(uri.getHost(), uri.getPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Client(String url) {
        this(Client.getAddress(url));
    }

    public Client(InetSocketAddress addr) {
        this(addr, SocketFactory.getDefault());
    }

    public Client(InetSocketAddress addr, SocketFactory socketFactory) {
        this.addr = addr;
        this.socketFactory = socketFactory;
    }

    public void dispose() {
    }

    public String getHeadRevision() throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("getHeadRevision");
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw new MicroKernelException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String getRevisionHistory(long since, int maxEntries, String path) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("getRevisionHistory");
            request.addParameter("since", since);
            request.addParameter("max_entries", maxEntries);
            request.addParameter("path", path);
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String waitForCommit(String oldHeadRevisionId, long maxWaitMillis) throws MicroKernelException, InterruptedException {
        Request request = null;
        try {
            request = this.createRequest("waitForCommit");
            request.addParameter("revision_id", oldHeadRevisionId);
            request.addParameter("max_wait_millis", maxWaitMillis);
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String getJournal(String fromRevisionId, String toRevisionId, String path) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("getJournal");
            request.addParameter("from_revision_id", fromRevisionId);
            request.addParameter("to_revision_id", toRevisionId);
            request.addParameter("path", path);
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String diff(String fromRevisionId, String toRevisionId, String path) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("diff");
            request.addParameter("from_revision_id", fromRevisionId);
            request.addParameter("to_revision_id", toRevisionId);
            request.addParameter("path", path);
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public boolean nodeExists(String path, String revisionId) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("nodeExists");
            request.addParameter("path", path);
            request.addParameter("revision_id", revisionId);
            boolean bl = request.getBoolean();
            return bl;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public long getChildNodeCount(String path, String revisionId) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("getChildNodeCount");
            request.addParameter("path", path);
            request.addParameter("revision_id", revisionId);
            long l = request.getLong();
            return l;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int count, String filter) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("getNodes");
            request.addParameter("path", path);
            request.addParameter("revision_id", revisionId);
            request.addParameter("depth", depth);
            request.addParameter("offset", offset);
            request.addParameter("max_child_nodes", count);
            request.addParameter("filter", filter);
            String result = request.getString();
            String string = result.equals("null") ? null : result;
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String commit(String path, String jsonDiff, String revisionId, String message) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("commit");
            request.addParameter("path", path);
            request.addParameter("json_diff", jsonDiff);
            request.addParameter("revision_id", revisionId);
            request.addParameter("message", message);
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String branch(String trunkRevisionId) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("branch");
            request.addParameter("trunk_revision_id", trunkRevisionId);
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String merge(String branchRevisionId, String message) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("merge");
            request.addParameter("branch_revision_id", branchRevisionId);
            request.addParameter("message", message);
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public long getLength(String blobId) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("getLength");
            request.addParameter("blob_id", blobId);
            long l = request.getLong();
            return l;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("read");
            request.addParameter("blob_id", blobId);
            request.addParameter("pos", pos);
            request.addParameter("length", length);
            int n = request.read(buff, off, length);
            return n;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
        }
    }

    public String write(InputStream in) throws MicroKernelException {
        Request request = null;
        try {
            request = this.createRequest("write");
            request.addFileParameter("file", in);
            String string = request.getString();
            return string;
        }
        catch (IOException e) {
            throw this.toMicroKernelException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)request);
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    private MicroKernelException toMicroKernelException(IOException e) {
        String msg = e.getMessage();
        if (msg != null && msg.startsWith(MK_EXCEPTION_PREFIX)) {
            return new MicroKernelException(msg.substring(MK_EXCEPTION_PREFIX.length()).trim());
        }
        return new MicroKernelException((Throwable)e);
    }

    private Request createRequest(String command) throws IOException, MicroKernelException {
        return new Request(this.socketFactory, this.addr, command);
    }
}

