/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.remote.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.jackrabbit.mk.util.IOUtils;

public class ChunkedInputStream
extends FilterInputStream {
    public static final int MAX_CHUNK_SIZE = 0x100000;
    private static final byte[] CRLF = "\r\n".getBytes();
    private final byte[] data = new byte[0x100000];
    private final byte[] suffix = new byte[2];
    private int offset;
    private int length;
    private boolean lastChunk;
    private boolean chunkError;

    public ChunkedInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (!this.lastChunk) {
            if (this.offset == this.length) {
                this.readChunk();
            }
            if (this.offset < this.length) {
                return this.data[this.offset++] & 0xFF;
            }
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        while (read < len && !this.lastChunk) {
            if (this.offset == this.length) {
                this.readChunk();
            }
            int available = Math.min(len - read, this.length - this.offset);
            System.arraycopy(this.data, this.offset, b, off + read, available);
            read += available;
            this.offset += available;
        }
        return read == 0 && this.lastChunk ? -1 : read;
    }

    private void readChunk() throws IOException {
        this.length = 0;
        this.offset = 0;
        this.length = this.readLength(this.in);
        if (this.length < 0 || this.length > 0x100000) {
            this.chunkError = true;
            String msg = "Chunk size smaller than 0 or bigger than 1048576";
            throw new IOException(msg);
        }
        ChunkedInputStream.readFully(this.in, this.data, 0, this.length);
        ChunkedInputStream.readFully(this.in, this.suffix);
        if (!Arrays.equals(this.suffix, CRLF)) {
            this.chunkError = true;
            String msg = "Missing carriage return/line feed combination.";
            throw new IOException(msg);
        }
        if (this.length == 0) {
            this.lastChunk = true;
        }
    }

    private int readLength(InputStream in) throws IOException {
        int ch;
        int len = 0;
        for (int i = 0; i < 5 && (ch = in.read()) != -1; ++i) {
            int n;
            if (ch >= 48 && ch <= 57) {
                n = ch - 48;
            } else if (ch >= 65 && ch <= 70) {
                n = ch - 65 + 10;
            } else if (ch >= 97 && ch <= 102) {
                n = ch - 97 + 10;
            } else {
                if (ch == 13) {
                    ch = in.read();
                    if (ch != 10) {
                        this.chunkError = true;
                        String msg = "Missing carriage return/line feed combination.";
                        throw new IOException(msg);
                    }
                    return len;
                }
                this.chunkError = true;
                String msg = String.format("Expected hexadecimal character, actual: %c", ch);
                throw new IOException(msg);
            }
            len = len * 16 + n;
        }
        ChunkedInputStream.readFully(in, this.suffix);
        if (!Arrays.equals(this.suffix, CRLF)) {
            this.chunkError = true;
            String msg = "Missing carriage return/line feed combination.";
            throw new IOException(msg);
        }
        return len;
    }

    private static void readFully(InputStream in, byte[] b) throws IOException {
        ChunkedInputStream.readFully(in, b, 0, b.length);
    }

    private static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int count = IOUtils.readFully((InputStream)in, (byte[])b, (int)off, (int)len);
        if (count < len) {
            String msg = String.format("Expected %d bytes, actually received: %d", len, count);
            throw new EOFException(msg);
        }
    }

    public void recycle(InputStream in) {
        this.in = in;
        this.length = 0;
        this.offset = 0;
        this.lastChunk = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                while (!this.chunkError && !this.lastChunk) {
                    this.readChunk();
                }
            }
            finally {
                this.in = null;
            }
        }
    }
}

