/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.server;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.mk.remote.util.BoundedInputStream;
import org.apache.jackrabbit.mk.remote.util.ChunkedInputStream;
import org.apache.jackrabbit.mk.server.BoundaryInputStream;
import org.apache.jackrabbit.mk.util.IOUtils;

class Request
implements Closeable {
    private static final String HTTP_11_PROTOCOL = "HTTP/1.1";
    private InputStream in;
    private String method;
    private String file;
    private String queryString;
    private String protocol;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private boolean paramsChecked;
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private final ChunkedInputStream chunkedIn = new ChunkedInputStream(null);
    private InputStream reqIn;

    Request() {
    }

    void parse(InputStream in) throws IOException {
        String headerLine;
        String requestLine = Request.readLine(in);
        String[] parts = requestLine.split(" ");
        if (parts.length != 3) {
            String msg = String.format("Bad HTTP request line: %s", requestLine);
            throw new IOException(msg);
        }
        this.method = parts[0];
        String uri = parts[1];
        int index = uri.lastIndexOf(63);
        if (index == -1) {
            this.file = uri;
            this.queryString = null;
        } else {
            this.file = uri.substring(0, index);
            this.queryString = uri.substring(index + 1);
        }
        this.protocol = parts[2];
        this.headers.clear();
        while ((headerLine = Request.readLine(in)).length() != 0) {
            parts = headerLine.split(":");
            if (parts.length != 2) continue;
            this.headers.put(parts[0].trim(), parts[1].trim());
        }
        this.params.clear();
        this.paramsChecked = false;
        this.reqIn = null;
        this.in = in;
    }

    private static String readLine(InputStream in) throws IOException {
        StringBuilder line = new StringBuilder(128);
        block5: while (true) {
            int c = in.read();
            switch (c) {
                case 13: {
                    continue block5;
                }
                case 10: {
                    return line.toString();
                }
                case -1: {
                    throw new EOFException();
                }
            }
            line.append((char)c);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getFile() {
        return this.file;
    }

    private String getContentType() {
        int sep;
        String ct = this.headers.get("Content-Type");
        if (ct != null && (sep = ct.indexOf(59)) != -1) {
            ct = ct.substring(0, sep).trim();
        }
        return ct;
    }

    private int getContentLength() {
        String s = this.headers.get("Content-Length");
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return -1;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getQueryString() {
        return this.queryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String name) throws IOException {
        if (!this.paramsChecked) {
            try {
                String contentType = this.getContentType();
                if ("application/x-www-form-urlencoded".equals(contentType)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)this.getInputStream(), (OutputStream)out);
                    Request.collectParameters(out.toString(), this.params);
                }
            }
            finally {
                this.paramsChecked = true;
            }
        }
        return this.params.get(name);
    }

    public String getParameter(String name, String defaultValue) throws IOException {
        String s = this.getParameter(name);
        if (s != null) {
            return s;
        }
        return defaultValue;
    }

    public int getParameter(String name, int defaultValue) throws IOException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public long getParameter(String name, long defaultValue) throws IOException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public InputStream getFileParameter(String name) throws IOException {
        String line;
        String ct = this.getContentType();
        if (ct == null || !ct.startsWith("multipart/form-data")) {
            return null;
        }
        if (this.reqIn != null) {
            return null;
        }
        InputStream body = this.getInputStream();
        String boundary = Request.readLine(body);
        while ((line = Request.readLine(body)).length() != 0) {
        }
        return new BoundaryInputStream(body, boundary);
    }

    private static void collectParameters(String s, Map<String, String> map) throws IOException {
        for (String param : s.split("&")) {
            String[] nv = param.split("=", 2);
            if (nv.length != 2) continue;
            map.put(URLDecoder.decode(nv[0], "UTF-8"), URLDecoder.decode(nv[1], "UTF-8"));
        }
    }

    public InputStream getInputStream() {
        if (this.reqIn == null) {
            String encoding = this.headers.get("Transfer-Encoding");
            if ("chunked".equalsIgnoreCase(encoding)) {
                this.chunkedIn.recycle(this.in);
                this.reqIn = this.chunkedIn;
            } else {
                int contentLength = this.getContentLength();
                if (contentLength == -1) {
                    contentLength = 0;
                }
                this.reqIn = new BoundedInputStream(this.in, contentLength);
            }
        }
        return this.reqIn;
    }

    boolean isKeepAlive() {
        return HTTP_11_PROTOCOL.equals(this.protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.getInputStream();
                IOUtils.closeQuietly((Closeable)this.reqIn);
            }
            finally {
                this.in = null;
            }
        }
    }
}

